/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import androidx.annotation.NonNull;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

class SessionCapabilities {
    @NonNull
    private final Map<String, Boolean> capabilities = new HashMap<String, Boolean>();

    SessionCapabilities(@NonNull String[] capabilities) {
        this.fill(capabilities);
    }

    void fill(@NonNull String[] capabilities) {
        this.capabilities.clear();
        for (String capability : capabilities) {
            this.capabilities.put(capability, true);
        }
    }

    @NonNull
    Map<String, Boolean> all() {
        return this.capabilities;
    }

    @NonNull
    String[] toArray() {
        HashSet<String> capabilities = new HashSet<String>();
        for (String capability : this.capabilities.keySet()) {
            if (!Boolean.TRUE.equals(this.capabilities.get(capability))) continue;
            capabilities.add(capability);
        }
        return capabilities.toArray(new String[0]);
    }

    void toggle(@NonNull String capability, boolean state) {
        if (this.capabilities.containsKey(capability)) {
            this.capabilities.put(capability, state);
        }
    }

    void toggle(@NonNull String[] capabilities, boolean state) {
        for (String capability : capabilities) {
            this.toggle(capability, state);
        }
    }

    static boolean isForbidden(@NonNull String[] capabilities, @NonNull String capability) {
        return !Arrays.asList(capabilities).contains(capability);
    }
}

