/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.app.Application;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.WindowId;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import androidx.core.util.Pair;
import io.cobrowse.AgentEvent;
import io.cobrowse.AnnotationOverlayManager;
import io.cobrowse.CobrowseIO;
import io.cobrowse.ControlInjector;
import io.cobrowse.FrameLoopManager;
import io.cobrowse.KeyEvent;
import io.cobrowse.RedactionManager;
import io.cobrowse.Session;
import io.cobrowse.SessionCapabilities;
import io.cobrowse.SessionContextModule;
import io.cobrowse.SessionUIManager;
import io.cobrowse.StreamProtocol;
import io.cobrowse.Touch;
import io.cobrowse.Windows;

@UiThread
final class SessionContext
extends SessionContextModule
implements StreamProtocol.Listener {
    private final StreamProtocol stream;
    private final FrameLoopManager frames;
    private final RedactionManager redaction;
    private final AnnotationOverlayManager overlay;
    private final ControlInjector control;
    private final SessionUIManager ui;

    SessionContext(@NonNull Delegate delegate, @NonNull Application app, @NonNull Session session) {
        super(app, session);
        this.stream = new StreamProtocol(app, session);
        this.frames = new FrameLoopManager(app, this.stream);
        this.ui = new SessionUIManager(app, session);
        this.redaction = new RedactionManager(delegate, app, session);
        this.frames.registerFrameListener(this.redaction);
        this.overlay = new AnnotationOverlayManager(app, session);
        this.stream.registerStreamProtocolListener(this.overlay);
        this.control = new ControlInjector(app, session);
        this.stream.registerStreamProtocolListener(this);
    }

    @Override
    void destroy() {
        this.frames.removeFrameListener(this.redaction);
        this.stream.removeStreamProtocolListener(this.overlay);
        this.stream.removeStreamProtocolListener(this);
        this.stream.destroy();
        this.frames.destroy();
        this.redaction.destroy();
        this.overlay.destroy();
        this.control.destroy();
        this.ui.destroy();
        this.session.destroy();
    }

    private boolean shouldAllowRemoteTouch(View root, PointF pos) {
        for (View view : this.redaction.getRedaction().getRedactions()) {
            Rect r;
            if (root != view.getRootView() || !view.getGlobalVisibleRect(r = new Rect()) || !r.contains((int)pos.x, (int)pos.y)) continue;
            return false;
        }
        for (Pair pair : this.redaction.getRedaction().getRedactionsExternal()) {
            if (root == null || pair.second == null || !((WindowId)pair.second).equals((Object)root.getWindowId()) || pos == null || pair.first == null || !((Rect)pair.first).contains((int)pos.x, (int)pos.y)) continue;
            return false;
        }
        return true;
    }

    private boolean shouldAllowRemoteKeyEvent(View root) {
        if (this.redaction.getRedaction().isRedacted(root)) {
            return false;
        }
        return !this.redaction.getRedaction().isRedactionExternalFocused();
    }

    @Override
    public void agentEventReceived(@NonNull Session session, @NonNull AgentEvent event) {
        if (!session.allowRemoteControl()) {
            return;
        }
        Display display = this.getDisplay(event.display);
        if (display == null) {
            return;
        }
        View window = Windows.getFocused(display);
        CobrowseIO.RemoteControlDelegate delegate = (CobrowseIO.RemoteControlDelegate)CobrowseIO.instance().getDelegate(CobrowseIO.RemoteControlDelegate.class);
        if (event instanceof Touch) {
            Touch scaled = ((Touch)event).scaledFor(display);
            if (!this.shouldAllowRemoteTouch(window, scaled.position)) {
                if (!scaled.isMove()) {
                    Log.v((String)"CobrowseIO", (String)("Blocking remote control for " + window));
                }
                return;
            }
            if (SessionCapabilities.isForbidden(session.capabilities(), "pointer")) {
                Log.w((String)"CobrowseIO", (String)"Capability 'pointer' not allowed.");
                return;
            }
            if (delegate != null && !delegate.shouldAllowTouch(window, scaled, session)) {
                return;
            }
            this.control.inject(window, scaled);
        }
        if (event instanceof KeyEvent) {
            View view;
            View view2 = view = window != null ? window.findFocus() : null;
            if (view == null) {
                view = window;
            }
            if (!this.shouldAllowRemoteKeyEvent(view)) {
                Log.v((String)"CobrowseIO", (String)("Blocking remote key events for " + view));
                return;
            }
            if (SessionCapabilities.isForbidden(session.capabilities(), "keypress")) {
                Log.w((String)"CobrowseIO", (String)"Capability 'keypress' not allowed.");
                return;
            }
            if (delegate != null && !delegate.shouldAllowKeyEvent(view, (KeyEvent)event, session)) {
                return;
            }
            this.control.inject(window, (KeyEvent)event);
        }
    }

    static interface Delegate
    extends RedactionManager.Delegate {
    }
}

