/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.app.Activity;
import android.app.Application;
import android.hardware.display.DisplayManager;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.ActivityWatcher;
import io.cobrowse.Session;

abstract class SessionContextModule {
    @NonNull
    final Application application;
    @NonNull
    final Session session;

    SessionContextModule(@NonNull Application app, @NonNull Session session) {
        this.application = app;
        this.session = session;
    }

    abstract void destroy();

    @Nullable
    Activity getActivity() {
        return ActivityWatcher.foregroundActivity();
    }

    @NonNull
    Application getApplication() {
        return this.application;
    }

    @NonNull
    DisplayManager getDisplayManager() {
        return (DisplayManager)this.getApplication().getSystemService("display");
    }

    @NonNull
    WindowManager getWindowManager() {
        return (WindowManager)this.getApplication().getSystemService("window");
    }

    @Nullable
    Display getDisplay(@Nullable String displayId) {
        if (displayId == null) {
            return null;
        }
        try {
            return this.getDisplay(Integer.parseInt(displayId));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    Display getDisplay(int displayId) {
        DisplayManager mgr = this.getDisplayManager();
        return mgr.getDisplay(displayId);
    }
}

