/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowMetrics;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.lifecycle.LifecycleObserver;
import io.cobrowse.ActivityWatcher;
import io.cobrowse.CobrowseIO;
import io.cobrowse.CobrowseService;
import io.cobrowse.Session;
import io.cobrowse.SessionContextModule;
import io.cobrowse.ui.RemoteControlConsentDialogFragment;
import io.cobrowse.ui.SessionConsentDialogFragment;

@UiThread
final class SessionUIManager
extends SessionContextModule
implements Session.Listener,
ActivityWatcher.Observer,
LifecycleObserver {
    private boolean handleSessionCalled;
    @Nullable
    private SessionConsentDialogFragment sessionRequest;
    @Nullable
    private RemoteControlConsentDialogFragment remoteControlRequest;
    @Nullable
    private View[] controls;
    private final ViewTreeObserver.OnWindowFocusChangeListener windowFocus = hasFocus -> this.updateSessionControls(this.getActivity(), this.session);

    SessionUIManager(@NonNull Application app, @NonNull Session session) {
        super(app, session);
        session.registerSessionListener(this);
        ActivityWatcher.registerActivityObserver(this);
    }

    @Override
    void destroy() {
        this.hideControls(this.getActivity(), this.session);
        if (this.getActivity() != null) {
            ViewTreeObserver observers = this.getActivity().getWindow().getDecorView().getViewTreeObserver();
            observers.removeOnWindowFocusChangeListener(this.windowFocus);
        }
        this.session.removeSessionListener(this);
        this.sessionDidEnd(this.session);
        ActivityWatcher.removeActivityObserver(this);
    }

    @NonNull
    private View[] createDefaultControls(@NonNull Activity activity) {
        if (Build.VERSION.SDK_INT >= 24 && activity.isInMultiWindowMode()) {
            if (Build.VERSION.SDK_INT >= 30) {
                WindowMetrics cwm = activity.getWindowManager().getCurrentWindowMetrics();
                if (cwm.getBounds().top == 0) {
                    return SessionUIManager.createDefaultControlsFullScreen(activity);
                }
            }
            return SessionUIManager.createDefaultControlsMultiWindow(activity);
        }
        return SessionUIManager.createDefaultControlsFullScreen(activity);
    }

    @NonNull
    private static View[] createDefaultControlsFullScreen(@NonNull Activity activity) {
        Rect rectangle = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rectangle);
        TextView controls = new TextView((Context)activity);
        controls.setBackgroundColor(-65536);
        controls.setTextAlignment(4);
        controls.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, rectangle.top));
        controls.addOnLayoutChangeListener((v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> {
            Activity viewActivity = (Activity)v.getContext();
            Rect viewActivityRectangle = new Rect();
            viewActivity.getWindow().getDecorView().getWindowVisibleDisplayFrame(viewActivityRectangle);
            v.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, viewActivityRectangle.top));
        });
        return new View[]{controls};
    }

    @SuppressLint(value={"RtlHardcoded"})
    @NonNull
    private static View[] createDefaultControlsMultiWindow(@NonNull Activity activity) {
        Rect rectangle = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rectangle);
        int defaultSize = (int)(6.0f * activity.getResources().getDisplayMetrics().density);
        int color2 = -65536;
        TextView left = new TextView((Context)activity);
        FrameLayout.LayoutParams leftParams = new FrameLayout.LayoutParams(defaultSize, -1);
        leftParams.gravity = 3;
        left.setBackgroundColor(-65536);
        left.setLayoutParams((ViewGroup.LayoutParams)leftParams);
        TextView top = new TextView((Context)activity);
        FrameLayout.LayoutParams topParams = new FrameLayout.LayoutParams(-1, defaultSize);
        topParams.gravity = 48;
        top.setBackgroundColor(-65536);
        top.setLayoutParams((ViewGroup.LayoutParams)topParams);
        TextView right = new TextView((Context)activity);
        FrameLayout.LayoutParams rightParams = new FrameLayout.LayoutParams(defaultSize, -1);
        rightParams.gravity = 5;
        right.setBackgroundColor(-65536);
        right.setLayoutParams((ViewGroup.LayoutParams)rightParams);
        TextView bottom = new TextView((Context)activity);
        FrameLayout.LayoutParams bottomParams = new FrameLayout.LayoutParams(-1, defaultSize);
        bottomParams.gravity = 80;
        bottom.setBackgroundColor(-65536);
        bottom.setLayoutParams((ViewGroup.LayoutParams)bottomParams);
        return new View[]{left, top, right, bottom};
    }

    private static void setDefaultIndicatorLayoutParams(@NonNull View target, @NonNull Activity activity) {
        int width;
        int height;
        Rect rectangle = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rectangle);
        if (Build.VERSION.SDK_INT >= 30) {
            WindowMetrics cwm = activity.getWindowManager().getCurrentWindowMetrics();
            height = rectangle.top - cwm.getBounds().top;
            width = cwm.getBounds().right - cwm.getBounds().left;
            Log.d((String)"CobrowseIO", (String)("rectangle.top: " + rectangle.top + "; cwm.getBounds().top: " + cwm.getBounds().top + ";"));
        } else {
            height = rectangle.top;
            width = -1;
        }
        target.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(width, height));
    }

    private void showDefaultControls(@NonNull Activity activity) {
        this.hideDefaultControls();
        this.controls = this.createDefaultControls(activity);
        ViewGroup container = this.getControlsContainer();
        if (container != null) {
            for (View next : this.controls) {
                container.addView(next);
                next.bringToFront();
            }
        }
    }

    private void hideDefaultControls() {
        if (this.controls == null) {
            return;
        }
        for (View next : this.controls) {
            ViewGroup parent = (ViewGroup)next.getParent();
            if (parent == null) continue;
            parent.removeView(next);
        }
        this.controls = null;
    }

    @Nullable
    private ViewGroup getControlsContainer() {
        Activity activity = this.getActivity();
        if (activity == null) {
            return null;
        }
        return (ViewGroup)activity.getWindow().getDecorView();
    }

    private void showControls(@Nullable Activity activity, @NonNull Session session) {
        CobrowseIO.SessionControlsDelegate delegate;
        if (!CobrowseService.needMediaProjectionPermissionBeforeStart()) {
            CobrowseService.setForeground();
        }
        if ((delegate = (CobrowseIO.SessionControlsDelegate)CobrowseIO.instance().getDelegate(CobrowseIO.SessionControlsDelegate.class)) != null) {
            delegate.showSessionControls(activity, session);
        } else if (activity != null) {
            this.showDefaultControls(activity);
        }
    }

    private void hideControls(@Nullable Activity activity, @NonNull Session session) {
        CobrowseIO.SessionControlsDelegate delegate;
        if (!CobrowseService.needMediaProjectionPermissionBeforeStart()) {
            CobrowseService.setBackground();
        }
        if ((delegate = (CobrowseIO.SessionControlsDelegate)CobrowseIO.instance().getDelegate(CobrowseIO.SessionControlsDelegate.class)) != null) {
            delegate.hideSessionControls(activity, session);
        }
        this.hideDefaultControls();
    }

    private void updateSessionControls(@Nullable Activity activity, @NonNull Session session) {
        if (session.isActive()) {
            this.showControls(activity, session);
        } else {
            this.hideControls(activity, session);
        }
    }

    private void showSessionConsent(@Nullable Activity activity, @NonNull Session session) {
        CobrowseIO.SessionRequestDelegate delegate = (CobrowseIO.SessionRequestDelegate)CobrowseIO.instance().getDelegate(CobrowseIO.SessionRequestDelegate.class);
        if (delegate != null) {
            if (activity == null) {
                return;
            }
            if (!this.handleSessionCalled) {
                delegate.handleSessionRequest(activity, session);
            }
            this.handleSessionCalled = true;
            return;
        }
        if (activity == null) {
            CobrowseIO.instance().launchApp();
            return;
        }
        if (this.sessionRequest == null) {
            this.sessionRequest = new SessionConsentDialogFragment();
            this.sessionRequest.show(activity);
        }
    }

    private void hideDefaultSessionConsent() {
        if (this.sessionRequest != null) {
            if (this.sessionRequest.isAdded()) {
                this.sessionRequest.dismiss();
            }
            this.sessionRequest = null;
        }
    }

    private void updateSessionConsent(@NonNull Session session) {
        if (session.isAuthorizing()) {
            this.showSessionConsent(this.getActivity(), session);
        } else {
            this.hideDefaultSessionConsent();
        }
    }

    private void showRemoteControlConsent(@NonNull Activity activity, @NonNull Session session) {
        CobrowseIO.RemoteControlRequestDelegate delegate = (CobrowseIO.RemoteControlRequestDelegate)CobrowseIO.instance().getDelegate(CobrowseIO.RemoteControlRequestDelegate.class);
        if (delegate != null) {
            delegate.handleRemoteControlRequest(activity, session);
            return;
        }
        if (this.remoteControlRequest == null) {
            this.remoteControlRequest = new RemoteControlConsentDialogFragment();
            this.remoteControlRequest.show(activity);
        }
    }

    private void hideDefaultRemoteControlConsent() {
        if (this.remoteControlRequest != null) {
            if (this.remoteControlRequest.isAdded()) {
                this.remoteControlRequest.dismiss();
            }
            this.remoteControlRequest = null;
        }
    }

    private void updateRemoteControlConsent(@NonNull Session session) {
        if (!session.isEnded() && session.remoteControl() == Session.RemoteControlState.Requested) {
            if (this.getActivity() != null) {
                this.showRemoteControlConsent(this.getActivity(), session);
            }
        } else {
            this.hideDefaultRemoteControlConsent();
        }
    }

    private void updateFullDeviceConsent(@Nullable Activity activity, @NonNull Session session) {
        if (!session.isEnded() && session.fullDeviceState() == Session.FullDeviceState.Requested) {
            CobrowseIO.FullDeviceRequestDelegate delegate = (CobrowseIO.FullDeviceRequestDelegate)CobrowseIO.instance().getDelegate(CobrowseIO.FullDeviceRequestDelegate.class);
            if (delegate != null && activity != null) {
                delegate.handleFullDeviceRequest(activity, session);
                return;
            }
            session.setFullDeviceState(Session.FullDeviceState.On, null);
        }
    }

    @Override
    public void sessionDidUpdate(@NonNull Session session) {
        this.updateSessionConsent(session);
        this.updateRemoteControlConsent(session);
        this.updateFullDeviceConsent(this.getActivity(), session);
        this.updateSessionControls(this.getActivity(), session);
    }

    @Override
    public void sessionDidEnd(@NonNull Session session) {
        this.hideDefaultSessionConsent();
        this.hideDefaultRemoteControlConsent();
    }

    @Override
    public void activityChanged(Activity to, Activity from) {
        ViewTreeObserver observers;
        if (to != null && from == null && !CobrowseService.needMediaProjectionPermissionBeforeStart()) {
            if (this.session.isActive()) {
                CobrowseService.setForeground();
            } else {
                CobrowseService.setBackground();
            }
        }
        this.updateSessionControls(to, this.session);
        this.updateSessionConsent(this.session);
        this.updateRemoteControlConsent(this.session);
        if (from != null) {
            observers = from.getWindow().getDecorView().getViewTreeObserver();
            observers.removeOnWindowFocusChangeListener(this.windowFocus);
        }
        if (to != null) {
            observers = to.getWindow().getDecorView().getViewTreeObserver();
            observers.removeOnWindowFocusChangeListener(this.windowFocus);
            observers.addOnWindowFocusChangeListener(this.windowFocus);
        }
    }
}

