/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.app.Activity;
import android.app.Application;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.util.SparseArray;
import android.view.Display;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.ProcessLifecycleOwner;
import io.cobrowse.ActivityWatcher;
import io.cobrowse.AgentEvent;
import io.cobrowse.CBORSocket;
import io.cobrowse.CobrowseIO;
import io.cobrowse.Drawing;
import io.cobrowse.Encoder;
import io.cobrowse.Frame;
import io.cobrowse.H264Encoder;
import io.cobrowse.JPEGEncoder;
import io.cobrowse.KeyEvent;
import io.cobrowse.Laser;
import io.cobrowse.SerializationError;
import io.cobrowse.Session;
import io.cobrowse.SessionContextModule;
import io.cobrowse.SocketURL;
import io.cobrowse.StreamAliveMessage;
import io.cobrowse.StreamFrameMessage;
import io.cobrowse.StreamMessage;
import io.cobrowse.StreamScreenStateMessage;
import io.cobrowse.Touch;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class StreamProtocol
extends SessionContextModule
implements Session.Listener,
ActivityWatcher.Observer,
ViewTreeObserver.OnWindowFocusChangeListener,
Encoder.Delegate,
LifecycleObserver {
    @NonNull
    private static final String ControlUrlField = "control_url";
    @NonNull
    private static final String ControlTokenField = "control_token";
    @NonNull
    private static final String StreamUrlField = "stream_url";
    @NonNull
    private static final String StreamTokenField = "stream_token";
    @NonNull
    private final SparseArray<Encoder> encoders = new SparseArray();
    @NonNull
    private final Set<Listener> listeners = new HashSet<Listener>();
    @Nullable
    private Handler handler = new Handler(Looper.getMainLooper());
    @Nullable
    private CBORSocket control;
    @Nullable
    private CBORSocket stream;
    private boolean isDestroyed;
    private static int frameId = 0;

    StreamProtocol(@NonNull Application app, @NonNull Session session) {
        super(app, session);
        session.registerSessionListener(this);
        ActivityWatcher.registerActivityObserver(this);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this);
        } else {
            this.handler.post(() -> {
                if (this.isDestroyed) {
                    return;
                }
                ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this);
            });
        }
    }

    void registerStreamProtocolListener(@NonNull Listener listener) {
        this.listeners.add(listener);
    }

    void removeStreamProtocolListener(@NonNull Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    void destroy() {
        this.isDestroyed = true;
        Runnable removeLifecycleObserver = () -> {
            ProcessLifecycleOwner.get().getLifecycle().removeObserver((LifecycleObserver)this);
            this.handler = null;
        };
        if (Looper.myLooper() == Looper.getMainLooper()) {
            removeLifecycleObserver.run();
        } else if (this.handler != null) {
            this.handler.post(removeLifecycleObserver);
        }
        this.session.removeSessionListener(this);
        ActivityWatcher.removeActivityObserver(this);
        this.disconnectControl();
        this.disconnectStream();
        this.listeners.clear();
        for (int i = 0; i < this.encoders.size(); ++i) {
            ((Encoder)this.encoders.valueAt(i)).destroy();
        }
        this.encoders.clear();
    }

    private String preferredEncoder(List<String> allowed) {
        if (!H264Encoder.isSupported()) {
            return "image/jpeg";
        }
        if (allowed == null || allowed.isEmpty() || allowed.contains("video/avc")) {
            return "video/avc";
        }
        return "image/jpeg";
    }

    private Encoder encoderForDisplay(Display display) {
        Encoder encoder = (Encoder)this.encoders.get(display.getDisplayId());
        String preferred = this.preferredEncoder(this.session.videoCodecs());
        if (encoder == null || !encoder.mimeType().equals(preferred)) {
            if (encoder != null) {
                encoder.destroy();
            }
            if (preferred.equals("video/avc")) {
                if (Build.VERSION.SDK_INT < 21) {
                    Log.e((String)"CobrowseIO", (String)"H264Encoder required Android 5.0 or above. Using JPEG instead");
                    encoder = new JPEGEncoder(this);
                } else {
                    encoder = new H264Encoder(this);
                }
            } else {
                encoder = new JPEGEncoder(this);
            }
            this.encoders.put(display.getDisplayId(), (Object)encoder);
        }
        return encoder;
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        this.sendMessage(new StreamScreenStateMessage(ActivityWatcher.foregroundActivity(), true));
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    public void onBackground() {
        this.sendMessage(new StreamScreenStateMessage(ActivityWatcher.foregroundActivity(), false));
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public void onForeground() {
        this.sendMessage(new StreamScreenStateMessage(ActivityWatcher.foregroundActivity(), true));
    }

    @Override
    public void activityChanged(@Nullable Activity to, @Nullable Activity from) {
        ViewTreeObserver tree;
        if (from != null) {
            tree = from.getWindow().getDecorView().getViewTreeObserver();
            tree.removeOnWindowFocusChangeListener((ViewTreeObserver.OnWindowFocusChangeListener)this);
        }
        if (to != null) {
            tree = to.getWindow().getDecorView().getViewTreeObserver();
            tree.addOnWindowFocusChangeListener((ViewTreeObserver.OnWindowFocusChangeListener)this);
        }
        this.sendMessage(new StreamScreenStateMessage(to, true));
    }

    @NonNull
    private CBORSocket socket(@NonNull Session session, @NonNull String urlField, @NonNull String tokenField) {
        CBORSocket socket = new CBORSocket(() -> {
            String host = session.field(urlField, String.class);
            String token = session.field(tokenField, String.class);
            return CobrowseIO.request(this.application).url(SocketURL.resolve(host, CobrowseIO.instance().apiUrl())).header("Authorization", "Bearer " + token).build();
        });
        socket.onError((err, res) -> Log.i((String)"CobrowseIO", (String)("Socket error (" + urlField + ") " + err)));
        return socket;
    }

    private void updateSockets(@NonNull Session session) {
        if (session.field(ControlUrlField, String.class) != null && session.field(ControlTokenField, String.class) != null) {
            this.connectControl(session);
        } else {
            this.disconnectControl();
        }
        if (session.field(StreamUrlField, String.class) != null && session.field(StreamTokenField, String.class) != null) {
            this.connectStream(session);
        } else {
            this.disconnectStream();
        }
    }

    private void connectControl(@NonNull Session session) {
        if (this.control != null) {
            return;
        }
        this.control = this.socket(session, ControlUrlField, ControlTokenField);
        this.control.onMessage("session", message -> this.sessionUpdateReceived(session, message));
        this.control.onConnect(() -> session.fetch(null));
    }

    private void disconnectControl() {
        if (this.control != null) {
            this.control.disconnect();
            this.control = null;
        }
    }

    private void connectStream(@NonNull Session session) {
        if (this.stream != null) {
            return;
        }
        this.stream = this.socket(session, StreamUrlField, StreamTokenField);
        this.stream.onMessage("drawing", message -> {
            try {
                this.agentEventReceived(session, new Drawing(message));
            }
            catch (SerializationError e) {
                Log.w((String)"CobrowseIO", (String)("Error parsing drawing event: " + e.getMessage()));
            }
        });
        this.stream.onMessage("laser", message -> {
            try {
                this.agentEventReceived(session, new Laser(message));
            }
            catch (SerializationError e) {
                Log.w((String)"CobrowseIO", (String)("Error parsing laser event: " + e.getMessage()));
            }
        });
        this.stream.onMessage("touch", message -> {
            try {
                this.agentEventReceived(session, new Touch(message));
            }
            catch (SerializationError e) {
                Log.w((String)"CobrowseIO", (String)("Error parsing touch event: " + e.getMessage()));
            }
        });
        this.stream.onMessage("keypress", message -> {
            try {
                this.agentEventReceived(session, new KeyEvent(message));
            }
            catch (SerializationError e) {
                Log.w((String)"CobrowseIO", (String)("Error parsing keypress event: " + e.getMessage()));
            }
        });
        this.stream.onConnect(() -> this.sendMessage(new StreamScreenStateMessage(ActivityWatcher.foregroundActivity(), this.getActivity() != null)));
        this.stream.onMessage("sync", message -> this.syncRequestReceived());
        this.stream.onMessage("probe", message -> this.sendMessage(new StreamAliveMessage(message)));
    }

    private void disconnectStream() {
        if (this.stream != null) {
            this.stream.disconnect();
            this.stream = null;
        }
    }

    private void sessionUpdateReceived(@NonNull Session session, @NonNull Map<String, Object> message) {
        if (this.handler != null) {
            this.handler.post(() -> session.updateResource(message));
        }
    }

    private void agentEventReceived(@NonNull Session session, @NonNull AgentEvent e) {
        if (this.handler != null) {
            this.handler.post(() -> {
                for (Listener l : this.listeners) {
                    l.agentEventReceived(session, e);
                }
            });
        }
    }

    private void syncRequestReceived() {
        for (int i = 0; i < this.encoders.size(); ++i) {
            ((Encoder)this.encoders.valueAt(i)).reset();
        }
        this.sendMessage(new StreamScreenStateMessage(ActivityWatcher.foregroundActivity(), this.getActivity() != null));
    }

    boolean sendFrame(@NonNull Display display, @NonNull Frame frame) {
        if (this.stream == null) {
            return false;
        }
        if (!this.stream.isConnected()) {
            return false;
        }
        if (this.stream.queueSize() > 30000L) {
            return false;
        }
        Encoder encoder = this.encoderForDisplay(display);
        if (this.stream.messageLag() >= (long)encoder.maximumFramesInFlight()) {
            return false;
        }
        frame.setScale(this.session.scale(display));
        encoder.encode(frame);
        return true;
    }

    void sendMessage(@NonNull StreamMessage message) {
        CBORSocket streamInstance = this.stream;
        if (streamInstance == null) {
            return;
        }
        try {
            streamInstance.send(message.getMessageKey(), message);
        }
        catch (IOException e) {
            Log.w((String)"CobrowseIO", (String)String.format("Failed to send \"%s\" message: %s", message.getMessageKey(), e.getMessage()));
        }
    }

    @Override
    public void onEncodedFrameData(Encoder encoder, byte[] data) {
        if (data == null) {
            Log.i((String)"CobrowseIO", (String)"Encoder return null frame");
            return;
        }
        int displayId = this.encoders.keyAt(this.encoders.indexOfValue((Object)encoder));
        this.sendMessage(new StreamFrameMessage(displayId, frameId++, data, encoder.mimeType()));
    }

    @Override
    public void onEncoderError(Encoder encoder, Error error) {
        Log.e((String)"CobrowseIO", (String)("Encoder error " + error));
    }

    @Override
    public void sessionDidUpdate(@NonNull Session session) {
        this.updateSockets(session);
    }

    @Override
    public void sessionDidEnd(@NonNull Session session) {
        this.destroy();
    }

    static interface Listener {
        public void agentEventReceived(@NonNull Session var1, @NonNull AgentEvent var2);
    }
}

