/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.view.PixelCopy;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.util.concurrent.ConcurrentHashMap;

final class SurfaceCapture {
    @NonNull
    private final ConcurrentHashMap<Integer, Bitmap> cache = new ConcurrentHashMap();
    @Nullable
    private Handler backgroundHandler;
    @Nullable
    private HandlerThread backgroundHandlerThread;

    public boolean capture(@NonNull View view, @NonNull Canvas canvas) {
        if (view instanceof TextureView) {
            TextureView textureView = (TextureView)view;
            Bitmap cached = this.cache.get(textureView.hashCode());
            if (cached != null) {
                this.draw((View)textureView, cached, canvas);
            }
            Runnable capture = () -> {
                Bitmap bitmap = textureView.getBitmap();
                if (bitmap == null) {
                    return;
                }
                this.cache.put(textureView.hashCode(), bitmap);
            };
            if (Build.VERSION.SDK_INT >= 21 || !textureView.isHardwareAccelerated()) {
                this.invokeInBackground(capture);
            } else {
                capture.run();
            }
            return true;
        }
        if (view instanceof SurfaceView) {
            if (Build.VERSION.SDK_INT < 24) {
                return false;
            }
            SurfaceView surfaceView = (SurfaceView)view;
            Bitmap cached = this.cache.get(surfaceView.hashCode());
            if (cached != null) {
                this.draw((View)surfaceView, cached, canvas);
            }
            this.invokeInBackground(() -> {
                Bitmap bitmap = this.capture(surfaceView);
                if (bitmap == null) {
                    return;
                }
                this.cache.put(surfaceView.hashCode(), bitmap);
            });
            return true;
        }
        if (view instanceof ViewGroup) {
            boolean rvalue = false;
            ViewGroup group = (ViewGroup)view;
            for (int i = 0; i < group.getChildCount(); ++i) {
                rvalue |= this.capture(group.getChildAt(i), canvas);
            }
            return rvalue;
        }
        return false;
    }

    public void clear() {
        if (this.backgroundHandlerThread != null) {
            this.backgroundHandlerThread.quit();
            this.backgroundHandlerThread = null;
            this.backgroundHandler = null;
        }
        this.cache.clear();
    }

    private void invokeInBackground(@NonNull Runnable runnable) {
        if (this.backgroundHandlerThread == null) {
            this.backgroundHandlerThread = new HandlerThread("SurfaceCapture");
            this.backgroundHandlerThread.start();
            this.backgroundHandler = new Handler(this.backgroundHandlerThread.getLooper());
        }
        this.backgroundHandler.post(runnable);
    }

    @RequiresApi(api=24)
    @Nullable
    private Bitmap capture(@NonNull SurfaceView surfaceView) {
        try {
            Bitmap output = Bitmap.createBitmap((int)surfaceView.getWidth(), (int)surfaceView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            PixelCopy.request((SurfaceView)surfaceView, (Bitmap)output, (PixelCopy.OnPixelCopyFinishedListener)new PixelCopy.OnPixelCopyFinishedListener(){

                public void onPixelCopyFinished(int copyResult) {
                    if (copyResult != 0) {
                        Log.e((String)"CobrowseIO", (String)("Cannot capture SurfaceView pixel data; result is " + copyResult));
                    }
                }
            }, (Handler)this.backgroundHandler);
            return output;
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    private void draw(@NonNull View view, @NonNull Bitmap bitmap, @NonNull Canvas canvas) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        Paint paint = new Paint(1);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OVER));
        Matrix matrix = new Matrix(view.getMatrix());
        matrix.postTranslate((float)location[0], (float)location[1]);
        canvas.drawBitmap(bitmap, matrix, paint);
    }
}

