/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.Callback;
import java.util.concurrent.CountDownLatch;

final class ThreadUtils {
    @NonNull
    private static final Handler handler = new Handler(Looper.getMainLooper());

    ThreadUtils() {
    }

    static void invokeAndWait(@NonNull Runnable r) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            r.run();
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            handler.post(() -> {
                try {
                    r.run();
                }
                finally {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while waiting for task to complete", e);
            }
        }
    }

    static <TError extends Error, TArg> void invoke(@Nullable Callback<TError, TArg> callback, @Nullable TError error, @Nullable TArg arg) {
        if (callback == null) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            if (error != null) {
                callback.call(error, arg);
            } else if (arg != null) {
                callback.call(null, arg);
            }
        } else if (error != null) {
            handler.post(() -> callback.call(error, arg));
        } else if (arg != null) {
            handler.post(() -> callback.call(null, arg));
        }
    }

    static <TError extends Error, TArg> void invoke(@Nullable Callback<TError, TArg> callback, @NonNull TError error) {
        ThreadUtils.invoke(callback, error, null);
    }

    static <TError extends Error, TArg> void invoke(@Nullable Callback<Error, TArg> callback, @NonNull TArg arg) {
        ThreadUtils.invoke(callback, null, arg);
    }
}

