/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.Tls12SocketFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;

class Tls12OkHttpClient {
    private Tls12OkHttpClient() {
    }

    static OkHttpClient reuse() {
        return ReusableClientSingleton.INSTANCE;
    }

    static OkHttpClient create() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().pingInterval(60L, TimeUnit.SECONDS).connectTimeout(2000L, TimeUnit.MILLISECONDS);
        return Tls12OkHttpClient.enableTls12OnPreLollipop(builder).build();
    }

    @NonNull
    private static OkHttpClient.Builder enableTls12OnPreLollipop(@NonNull OkHttpClient.Builder client) {
        if (Build.VERSION.SDK_INT >= 22) {
            return client;
        }
        try {
            TrustManager[] trustManagers = Tls12OkHttpClient.findTrustManagers();
            X509TrustManager x509TrustManager = trustManagers != null ? Tls12OkHttpClient.findX509TrustManager(trustManagers) : null;
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            sc.init(null, trustManagers, null);
            Tls12SocketFactory tls12Factory = new Tls12SocketFactory(sc.getSocketFactory());
            if (x509TrustManager != null) {
                client.sslSocketFactory((SSLSocketFactory)tls12Factory, x509TrustManager);
            } else {
                client.sslSocketFactory((SSLSocketFactory)tls12Factory);
            }
            ConnectionSpec cs = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).build();
            ArrayList<ConnectionSpec> specs = new ArrayList<ConnectionSpec>();
            specs.add(cs);
            client.connectionSpecs(specs);
        }
        catch (Exception e) {
            Log.e((String)"CobrowseIO", (String)"Error while setting TLS v1.2", (Throwable)e);
        }
        return client;
    }

    @Nullable
    private static TrustManager[] findTrustManagers() {
        try {
            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(algorithm);
            trustManagerFactory.init((KeyStore)null);
            return trustManagerFactory.getTrustManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            Log.e((String)"CobrowseIO", (String)"Cannot obtain TrustManager instances", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static X509TrustManager findX509TrustManager(@NonNull TrustManager[] trustManagers) {
        for (TrustManager next : trustManagers) {
            if (!(next instanceof X509TrustManager)) continue;
            return (X509TrustManager)next;
        }
        Log.e((String)"CobrowseIO", (String)"Cannot find an X509TrustManager instance");
        return null;
    }

    private static class ReusableClientSingleton {
        private static final OkHttpClient INSTANCE = Tls12OkHttpClient.create();

        private ReusableClientSingleton() {
        }
    }
}

