/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.graphics.PointF;
import android.view.Display;
import androidx.annotation.NonNull;
import io.cobrowse.AgentEvent;
import io.cobrowse.DisplayScaling;
import io.cobrowse.SerializationError;
import io.cobrowse.TypeUtils;
import io.cobrowse.UTCDate;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

final class Touch
extends AgentEvent {
    @NonNull
    final String id;
    @NonNull
    final String state;
    @NonNull
    PointF position;
    @NonNull
    final Date timestamp;

    private Touch(@NonNull Touch existing) {
        super(existing.display);
        this.id = existing.id;
        this.state = existing.state;
        this.position = existing.position;
        this.timestamp = existing.timestamp;
    }

    Touch(@NonNull Map<String, Object> obj) throws SerializationError {
        super(obj);
        this.id = TypeUtils.checkNonNull(obj.get("id"), String.class);
        this.state = TypeUtils.checkNonNull(obj.get("state"), String.class);
        Double x = TypeUtils.checkNonNull(obj.get("x"), Double.class);
        Double y = TypeUtils.checkNonNull(obj.get("y"), Double.class);
        this.position = new PointF(x.floatValue(), y.floatValue());
        try {
            this.timestamp = UTCDate.parse(TypeUtils.checkNonNull(obj.get("timestamp"), String.class));
        }
        catch (ParseException e) {
            throw new SerializationError("Invalid date format in agent event");
        }
    }

    @NonNull
    Touch scaledFor(@NonNull Display display) {
        Touch scaled = new Touch(this);
        scaled.position = DisplayScaling.scale(display, this.position);
        return scaled;
    }

    public boolean isStart() {
        return this.state.equalsIgnoreCase("touchstart");
    }

    public boolean isMove() {
        return this.state.equalsIgnoreCase("touchmove");
    }

    public boolean isEnd() {
        return this.state.equalsIgnoreCase("touchend");
    }

    @NonNull
    PointF delta(@NonNull Touch other) {
        return new PointF(this.position.x - other.position.x, this.position.y - other.position.y);
    }

    double distance(@NonNull Touch other) {
        PointF delta = this.delta(other);
        return Math.hypot(delta.x, delta.y);
    }
}

