/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.Predicate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class TreeUtils {
    TreeUtils() {
    }

    @NonNull
    public static Set<View> directChildren(@NonNull View root) {
        HashSet<View> children = new HashSet<View>();
        if (root instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)root;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                children.add(viewGroup.getChildAt(i));
            }
        }
        return children;
    }

    @NonNull
    public static List<View> allParents(@NonNull View root) {
        ArrayList<View> parents = new ArrayList<View>();
        for (ViewParent target = root.getParent(); target != null; target = target.getParent()) {
            if (!(target instanceof View)) continue;
            parents.add(0, (View)target);
        }
        return parents;
    }

    @Nullable
    public static View closest(@NonNull View root, @NonNull Predicate<View> predicate) {
        if (predicate.test(root)) {
            return root;
        }
        ViewParent parent = root.getParent();
        if (parent instanceof ViewGroup) {
            return TreeUtils.closest((View)((ViewGroup)parent), predicate);
        }
        return null;
    }
}

