/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.SerializationError;

final class TypeUtils {
    TypeUtils() {
    }

    @Nullable
    private static Float checkFloat(@Nullable Object thing) {
        if (thing instanceof Double) {
            return Float.valueOf(((Double)thing).floatValue());
        }
        if (thing instanceof Float) {
            return (Float)thing;
        }
        Integer intVal = TypeUtils.checkInteger(thing);
        if (intVal != null) {
            return Float.valueOf(intVal.floatValue());
        }
        return null;
    }

    @Nullable
    private static Double checkDouble(@Nullable Object thing) {
        if (thing instanceof Double) {
            return (Double)thing;
        }
        if (thing instanceof Float) {
            return ((Float)thing).doubleValue();
        }
        Integer intVal = TypeUtils.checkInteger(thing);
        if (intVal != null) {
            return intVal.doubleValue();
        }
        return null;
    }

    @Nullable
    private static Integer checkInteger(@Nullable Object thing) {
        if (thing instanceof Long) {
            return ((Long)thing).intValue();
        }
        if (thing instanceof Integer) {
            return (Integer)thing;
        }
        return null;
    }

    @Nullable
    private static Long checkLong(@Nullable Object thing) {
        if (thing instanceof Long) {
            return (Long)thing;
        }
        if (thing instanceof Integer) {
            return ((Integer)thing).longValue();
        }
        return null;
    }

    @Nullable
    static <T> T check(@Nullable Object thing, @NonNull Class<T> cls, @Nullable T def) {
        if (thing == null) {
            return def;
        }
        if (cls.isAssignableFrom(thing.getClass())) {
            return (T)thing;
        }
        Number val = null;
        if (cls.equals(Double.class) || cls.equals(Double.TYPE)) {
            val = TypeUtils.checkDouble(thing);
        }
        if (cls.equals(Float.class) || cls.equals(Float.TYPE)) {
            val = TypeUtils.checkFloat(thing);
        }
        if (cls.equals(Long.class) || cls.equals(Long.TYPE)) {
            val = TypeUtils.checkLong(thing);
        }
        if (cls.equals(Integer.class) || cls.equals(Integer.TYPE)) {
            val = TypeUtils.checkInteger(thing);
        }
        if (val != null) {
            return (T)val;
        }
        return def;
    }

    static float check(@Nullable Object thing, float def) {
        Float checked = TypeUtils.check(thing, Float.class, null);
        if (checked != null) {
            return checked.floatValue();
        }
        return def;
    }

    static double check(@Nullable Object thing, double def) {
        Double checked = TypeUtils.check(thing, Double.class, null);
        if (checked != null) {
            return checked;
        }
        return def;
    }

    static int check(@Nullable Object thing, int def) {
        Integer checked = TypeUtils.check(thing, Integer.class, null);
        if (checked != null) {
            return checked;
        }
        return def;
    }

    static long check(@Nullable Object thing, long def) {
        Long checked = TypeUtils.check(thing, Long.class, null);
        if (checked != null) {
            return checked;
        }
        return def;
    }

    @Nullable
    static <T> T check(@Nullable Object thing, @NonNull Class<T> cls) {
        return TypeUtils.check(thing, cls, null);
    }

    @NonNull
    static <T> T checkNonNull(@Nullable Object thing, @NonNull Class<T> cls) throws SerializationError {
        T checked = TypeUtils.check(thing, cls, null);
        if (checked == null) {
            throw new SerializationError("Value required");
        }
        return checked;
    }
}

