/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.ActivityWatcher;
import io.cobrowse.BitmapUtils;
import io.cobrowse.DisplayScaling;
import io.cobrowse.Frame;
import io.cobrowse.FrameLoop;
import io.cobrowse.SurfaceCapture;
import io.cobrowse.Windows;
import java.util.HashSet;
import java.util.Objects;

final class ViewRenderingFrameSource
implements ActivityWatcher.Observer,
FrameLoop.Source {
    @NonNull
    private final HashSet<ViewTreeObserver> watchedWindows = new HashSet();
    @NonNull
    private final SurfaceCapture surfaceCapture = new SurfaceCapture();
    @Nullable
    private Frame mostRecent;
    @Nullable
    private Bitmap writableBitmap;
    @Nullable
    private Bitmap previousBitmap;
    private long renderingForScreenshot;
    private boolean updateScheduled;
    private long suppressUntil;
    private static final int CAPTURE_RESULT_OK = 0;
    private static final int CAPTURE_RESULT_PARTIAL = 1;
    private static final int CAPTURE_RESULT_FAIL = 2;
    @NonNull
    private final ViewTreeObserver.OnDrawListener changeListener = new ViewTreeObserver.OnDrawListener(){

        public void onDraw() {
            if (!ViewRenderingFrameSource.this.isProbablyScreenshotRender()) {
                ViewRenderingFrameSource.this.suppressFor(0L);
                ViewRenderingFrameSource.this.renderingForScreenshot = 0L;
            }
        }
    };
    @NonNull
    private final ViewTreeObserver.OnGlobalLayoutListener layoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            if (!ViewRenderingFrameSource.this.isProbablyScreenshotRender()) {
                ViewRenderingFrameSource.this.suppressFor(0L);
                ViewRenderingFrameSource.this.renderingForScreenshot = 0L;
            }
        }
    };
    @NonNull
    private final ViewTreeObserver.OnWindowFocusChangeListener windowListener = hasFocus -> {
        this.updateWatchedWindows();
        this.suppressFor(0L);
    };

    ViewRenderingFrameSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int captureView(@NonNull View view, @NonNull Canvas canvas) {
        int rvalue;
        int[] location;
        block10: {
            if (view.getWidth() == 0 || view.getHeight() == 0) {
                return 0;
            }
            location = new int[2];
            view.getLocationOnScreen(location);
            canvas.save();
            WindowManager.LayoutParams wm = (WindowManager.LayoutParams)view.getLayoutParams();
            if ((wm.flags & 2) != 0) {
                Paint paint = new Paint();
                paint.setColor(-16777216);
                paint.setStyle(Paint.Style.FILL);
                paint.setAlpha((int)(255.0f * wm.dimAmount));
                canvas.drawPaint(paint);
            }
            canvas.translate((float)location[0], (float)location[1]);
            try {
                view.draw(canvas);
                rvalue = 0;
            }
            catch (Exception e) {
                if (ViewRenderingFrameSource.isHardwareBitmapError(e)) {
                    Log.e((String)"CobrowseIO", (String)("Cannot capture the app view: " + e.getMessage()));
                    rvalue = 1;
                    break block10;
                }
                if (ViewRenderingFrameSource.isComposeDrawRenderNodeError(e)) {
                    Log.e((String)"CobrowseIO", (String)("Cannot capture hardware-accelerated Compose UI: " + e.getMessage()));
                    rvalue = 2;
                    break block10;
                }
                throw e;
            }
            finally {
                canvas.restore();
            }
        }
        if (rvalue == 1) {
            canvas.restoreToCount(1);
            canvas.save();
            Paint paint = new Paint();
            paint.setColor(-16777216);
            paint.setStyle(Paint.Style.FILL);
            canvas.drawRect((float)location[0], (float)location[1], (float)(location[0] + view.getWidth()), (float)(location[1] + view.getHeight()), paint);
            canvas.restore();
        }
        return rvalue;
    }

    private static boolean isComposeDrawRenderNodeError(@NonNull Exception e) {
        return e instanceof IllegalArgumentException && Objects.equals(e.getMessage(), "Software rendering doesn't support drawRenderNode");
    }

    private static boolean isHardwareBitmapError(@NonNull Exception e) {
        return (e instanceof IllegalStateException || e instanceof IllegalArgumentException) && Objects.equals(e.getMessage(), "Software rendering doesn't support hardware bitmaps");
    }

    @Override
    public void capturingWillStart(@NonNull Display display) {
        ActivityWatcher.registerActivityObserver(this);
        this.updateWatchedWindows();
        this.updateScheduled = true;
        this.suppressUntil = 0L;
    }

    @Override
    public void capturingWillStop(@NonNull Display display) {
        this.updateScheduled = false;
        this.surfaceCapture.clear();
        ActivityWatcher.removeActivityObserver(this);
        this.unwatchWindows(this.watchedWindows);
        this.previousBitmap = null;
        this.writableBitmap = null;
    }

    @Override
    @Nullable
    public Frame newFrame(@NonNull Display display) {
        this.renderingForScreenshot = System.currentTimeMillis();
        if (!display.isValid()) {
            return null;
        }
        DisplayMetrics metrics = DisplayScaling.getMetrics(display);
        int width = metrics.widthPixels;
        int height = metrics.heightPixels;
        if (width == 0 || height == 0) {
            return null;
        }
        if (this.mostRecent == null || this.writableBitmap == null || this.writableBitmap.getWidth() != width || this.writableBitmap.getHeight() != height) {
            this.writableBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (this.writableBitmap == null) {
                throw new RuntimeException(String.format("Failed to create a bitmap %d:%d", width, height));
            }
            this.mostRecent = new Frame(this.writableBitmap);
        } else {
            this.writableBitmap.eraseColor(0);
        }
        Canvas canvas = new Canvas(this.writableBitmap);
        boolean foundSurface = false;
        for (View window : Windows.getAll()) {
            Context windowContext = window.getContext();
            if (windowContext instanceof Activity && ((Activity)windowContext).isFinishing() || !window.isAttachedToWindow() || window.getDisplay().getDisplayId() != display.getDisplayId()) continue;
            int result = ViewRenderingFrameSource.captureView(window, canvas);
            if (result == 2) {
                return null;
            }
            foundSurface |= this.surfaceCapture.capture(window, canvas);
        }
        this.updateScheduled = foundSurface;
        if (this.previousBitmap == null || !BitmapUtils.sameSize(this.previousBitmap, this.writableBitmap)) {
            this.mostRecent.setDirty(true);
            this.previousBitmap = BitmapUtils.copy(this.writableBitmap);
        } else if (!this.previousBitmap.sameAs(this.writableBitmap)) {
            this.mostRecent.setDirty(true);
            BitmapUtils.copy(this.writableBitmap, this.previousBitmap);
        } else {
            this.mostRecent.setDirty(false);
        }
        return this.mostRecent;
    }

    @Override
    public boolean isNewFrameAvailable(@NonNull Display display) {
        this.updateWatchedWindows();
        if (this.isSuppressed()) {
            return false;
        }
        return this.updateScheduled || this.wasRecentlySuppressed();
    }

    private void suppressFor(long milliseconds) {
        this.suppressUntil = Math.max(System.currentTimeMillis() + milliseconds, this.suppressUntil);
        this.updateScheduled = true;
    }

    private boolean isSuppressed() {
        return this.suppressUntil > System.currentTimeMillis();
    }

    private boolean wasRecentlySuppressed() {
        long interval = this.suppressUntil - System.currentTimeMillis();
        return interval < 0L && interval > -1000L;
    }

    private boolean isProbablyScreenshotRender() {
        long delta = System.currentTimeMillis() - this.renderingForScreenshot;
        return delta < 90L;
    }

    private boolean watchWindow(@NonNull ViewTreeObserver observer) {
        if (!observer.isAlive()) {
            return false;
        }
        if (!this.watchedWindows.add(observer)) {
            return false;
        }
        observer.addOnDrawListener(this.changeListener);
        observer.addOnWindowFocusChangeListener(this.windowListener);
        observer.addOnGlobalLayoutListener(this.layoutListener);
        return true;
    }

    private boolean unwatchWindow(@NonNull ViewTreeObserver observer) {
        boolean rvalue;
        if (!observer.isAlive()) {
            rvalue = false;
        } else {
            observer.removeOnDrawListener(this.changeListener);
            observer.removeOnWindowFocusChangeListener(this.windowListener);
            observer.removeOnGlobalLayoutListener(this.layoutListener);
            rvalue = true;
        }
        this.watchedWindows.remove(observer);
        return rvalue;
    }

    private void updateWatchedWindows() {
        boolean windowsChanged = false;
        HashSet<ViewTreeObserver> unwatched = new HashSet<ViewTreeObserver>(this.watchedWindows);
        for (View window : Windows.getAll()) {
            ViewTreeObserver observer = window.getRootView().getViewTreeObserver();
            windowsChanged |= this.watchWindow(observer);
            unwatched.remove(observer);
        }
        if (windowsChanged |= this.unwatchWindows(unwatched)) {
            this.suppressFor(0L);
        }
    }

    private boolean unwatchWindows(@NonNull HashSet<ViewTreeObserver> windows) {
        boolean rvalue = false;
        for (ViewTreeObserver observer : new HashSet<ViewTreeObserver>(windows)) {
            rvalue |= this.unwatchWindow(observer);
        }
        return rvalue;
    }

    @Override
    public void activityChanged(@Nullable Activity to, @Nullable Activity from) {
        this.suppressFor(0L);
        if (to != null) {
            this.updateWatchedWindows();
            this.watchWindow(to.getWindow().getDecorView().getRootView().getViewTreeObserver());
        }
    }
}

