/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.ClientCertRequest;
import android.webkit.HttpAuthHandler;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SafeBrowsingResponse;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.WebViewCustomClient;
import java.util.Set;

class WebViewClientProxy
extends WebViewClient {
    @NonNull
    private final WebViewCustomClient customWebViewClient;
    @Nullable
    public final WebViewClient userWebViewClient;

    public WebViewClientProxy(@NonNull WebViewCustomClient customWebViewClient, @Nullable WebViewClient userWebViewClient) {
        this.customWebViewClient = customWebViewClient;
        this.userWebViewClient = userWebViewClient;
    }

    public void doUpdateVisitedHistory(@NonNull WebView view, String url, boolean isReload) {
        this.customWebViewClient.doUpdateVisitedHistory(view, url, isReload);
        if (this.userWebViewClient != null) {
            this.userWebViewClient.doUpdateVisitedHistory(view, url, isReload);
        }
    }

    public void onPageStarted(@NonNull WebView view, @NonNull String url, @NonNull Bitmap favicon) {
        this.customWebViewClient.onPageStarted(view, url, favicon);
        if (this.userWebViewClient != null) {
            this.userWebViewClient.onPageStarted(view, url, favicon);
        }
    }

    public void onPageFinished(@NonNull WebView view, @NonNull String url) {
        this.customWebViewClient.onPageFinished(view, url);
        if (this.userWebViewClient != null) {
            this.userWebViewClient.onPageFinished(view, url);
        }
    }

    public boolean shouldOverrideUrlLoading(@NonNull WebView view, @NonNull String url) {
        if (this.userWebViewClient != null) {
            return this.userWebViewClient.shouldOverrideUrlLoading(view, url);
        }
        return super.shouldOverrideUrlLoading(view, url);
    }

    public boolean shouldOverrideUrlLoading(@NonNull WebView view, @NonNull WebResourceRequest request) {
        if (this.userWebViewClient != null && Build.VERSION.SDK_INT >= 24) {
            return this.userWebViewClient.shouldOverrideUrlLoading(view, request);
        }
        return super.shouldOverrideUrlLoading(view, request);
    }

    public void onLoadResource(@NonNull WebView view, @NonNull String url) {
        if (this.userWebViewClient != null) {
            this.userWebViewClient.onLoadResource(view, url);
        }
    }

    public void onPageCommitVisible(@NonNull WebView view, @NonNull String url) {
        if (this.userWebViewClient != null && Build.VERSION.SDK_INT >= 23) {
            this.userWebViewClient.onPageCommitVisible(view, url);
        }
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(@NonNull WebView view, @NonNull String url) {
        if (this.userWebViewClient != null) {
            return this.userWebViewClient.shouldInterceptRequest(view, url);
        }
        return super.shouldInterceptRequest(view, url);
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(@NonNull WebView view, @NonNull WebResourceRequest request) {
        if (this.userWebViewClient != null && Build.VERSION.SDK_INT >= 21) {
            return this.userWebViewClient.shouldInterceptRequest(view, request);
        }
        return super.shouldInterceptRequest(view, request);
    }

    public void onTooManyRedirects(@NonNull WebView view, @NonNull Message cancelMsg, @NonNull Message continueMsg) {
        if (this.userWebViewClient != null) {
            this.userWebViewClient.onTooManyRedirects(view, cancelMsg, continueMsg);
        }
    }

    public void onReceivedError(@NonNull WebView view, int errorCode, @NonNull String description, @NonNull String failingUrl) {
        if (this.userWebViewClient != null) {
            this.userWebViewClient.onReceivedError(view, errorCode, description, failingUrl);
        }
    }

    public void onReceivedError(@NonNull WebView view, @NonNull WebResourceRequest request, @NonNull WebResourceError error) {
        if (this.userWebViewClient != null && Build.VERSION.SDK_INT >= 23) {
            this.userWebViewClient.onReceivedError(view, request, error);
        }
    }

    public void onReceivedHttpError(@NonNull WebView view, @NonNull WebResourceRequest request, @NonNull WebResourceResponse errorResponse) {
        if (this.userWebViewClient != null && Build.VERSION.SDK_INT >= 23) {
            this.userWebViewClient.onReceivedHttpError(view, request, errorResponse);
        }
    }

    public void onFormResubmission(@NonNull WebView view, @NonNull Message dontResend, @NonNull Message resend) {
        if (this.userWebViewClient != null) {
            this.userWebViewClient.onFormResubmission(view, dontResend, resend);
        }
    }

    public void onReceivedSslError(@NonNull WebView view, @NonNull SslErrorHandler handler, @NonNull SslError error) {
        if (this.userWebViewClient != null) {
            this.userWebViewClient.onReceivedSslError(view, handler, error);
        }
    }

    public void onReceivedClientCertRequest(@NonNull WebView view, @NonNull ClientCertRequest request) {
        if (this.userWebViewClient != null && Build.VERSION.SDK_INT >= 21) {
            this.userWebViewClient.onReceivedClientCertRequest(view, request);
        }
    }

    public void onReceivedHttpAuthRequest(@NonNull WebView view, @NonNull HttpAuthHandler handler, @NonNull String host, @NonNull String realm) {
        if (this.userWebViewClient != null) {
            this.userWebViewClient.onReceivedHttpAuthRequest(view, handler, host, realm);
        }
    }

    public boolean shouldOverrideKeyEvent(@NonNull WebView view, @NonNull KeyEvent event) {
        if (this.userWebViewClient != null) {
            return this.userWebViewClient.shouldOverrideKeyEvent(view, event);
        }
        return super.shouldOverrideKeyEvent(view, event);
    }

    public void onUnhandledKeyEvent(@NonNull WebView view, @NonNull KeyEvent event) {
        if (this.userWebViewClient != null) {
            this.userWebViewClient.onUnhandledKeyEvent(view, event);
        }
    }

    public void onScaleChanged(@NonNull WebView view, float oldScale, float newScale) {
        if (this.userWebViewClient != null) {
            this.userWebViewClient.onScaleChanged(view, oldScale, newScale);
        }
    }

    public void onReceivedLoginRequest(@NonNull WebView view, @NonNull String realm, @NonNull String account, @NonNull String args) {
        if (this.userWebViewClient != null && Build.VERSION.SDK_INT >= 26) {
            this.userWebViewClient.onReceivedLoginRequest(view, realm, account, args);
        }
    }

    public boolean onRenderProcessGone(@NonNull WebView view, @NonNull RenderProcessGoneDetail detail) {
        if (this.userWebViewClient != null && Build.VERSION.SDK_INT >= 26) {
            return this.userWebViewClient.onRenderProcessGone(view, detail);
        }
        return super.onRenderProcessGone(view, detail);
    }

    public void onSafeBrowsingHit(@NonNull WebView view, @NonNull WebResourceRequest request, int threatType, @NonNull SafeBrowsingResponse callback) {
        if (this.userWebViewClient != null && Build.VERSION.SDK_INT >= 27) {
            this.userWebViewClient.onSafeBrowsingHit(view, request, threatType, callback);
        }
    }

    @NonNull
    public Set<View> redactedViews() {
        return this.customWebViewClient.redactedViews();
    }

    public void destroy() {
        this.customWebViewClient.destroy();
    }
}

