/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.WebViewRedactionManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

final class WebViewCustomClient
extends WebViewClient {
    @Nullable
    private ViewTreeObserver.OnDrawListener mDrawListener;
    @Nullable
    private ViewTreeObserver mRootViewTreeObserver;
    @NonNull
    private WeakReference<ViewGroup> mParentViewGroup;
    @NonNull
    private final WeakReference<WebView> mWebViewRef;
    private final AtomicInteger frameCounter = new AtomicInteger(0);
    private final AtomicInteger resolvedFrameCounter = new AtomicInteger(-1);
    private final AtomicInteger resolvedScrollX = new AtomicInteger(0);
    private final AtomicInteger scrollVelocityX = new AtomicInteger(0);
    private final AtomicInteger resolvedScrollY = new AtomicInteger(0);
    private final AtomicInteger scrollVelocityY = new AtomicInteger(0);
    @NonNull
    private final WebViewRedactionManager webViewRedactionManager;
    @NonNull
    private final String mSelectorsString;
    private final int originalLayerType;
    private final int overScrollModeType;

    WebViewCustomClient(@NonNull WebView webView, @NonNull String[] selectors) {
        this.webViewRedactionManager = new WebViewRedactionManager(webView);
        this.mSelectorsString = String.join((CharSequence)", ", selectors);
        this.mWebViewRef = new WeakReference<WebView>(webView);
        this.mParentViewGroup = new WeakReference<ViewGroup>((ViewGroup)webView.getParent());
        if (webView.getUrl() != null && this.isEnabled()) {
            this.injectJavaScript(webView, webView.getContext());
        }
        this.originalLayerType = webView.getLayerType();
        webView.setLayerType(0, null);
        this.overScrollModeType = webView.getOverScrollMode();
        if (this.isEnabled()) {
            webView.setOverScrollMode(2);
        }
    }

    private boolean isEnabled() {
        return !this.mSelectorsString.isEmpty();
    }

    private static boolean isJavaScriptEnabled(@NonNull WebView webView) {
        return webView.getSettings().getJavaScriptEnabled();
    }

    public void onPageStarted(@NonNull WebView view, @NonNull String url, @NonNull Bitmap favicon) {
        this.reset();
        super.onPageStarted(view, url, favicon);
    }

    public void onPageFinished(@NonNull WebView view, String url) {
        super.onPageFinished(view, url);
        view.post(() -> this.injectJavaScript(view, view.getContext()));
    }

    public boolean isSettled() {
        if (this.mWebViewRef.get() == null) {
            Log.w((String)"CobrowseIO", (String)"isSettled() was called on a client with null webview");
            return true;
        }
        if (!((WebView)this.mWebViewRef.get()).isShown()) {
            return true;
        }
        if (!this.isEnabled()) {
            return true;
        }
        if (!WebViewCustomClient.isJavaScriptEnabled((WebView)this.mWebViewRef.get())) {
            return true;
        }
        if (this.webViewRedactionManager.getRedactedViews() == null) {
            return false;
        }
        return this.frameCounter.get() == this.resolvedFrameCounter.get() && this.resolvedScrollX.get() == ((WebView)this.mWebViewRef.get()).getScrollX() && this.resolvedScrollY.get() == ((WebView)this.mWebViewRef.get()).getScrollY();
    }

    @NonNull
    Set<View> getFullRedaction() {
        return new HashSet<View>(){
            {
                this.add((View)WebViewCustomClient.this.mWebViewRef.get());
            }
        };
    }

    @NonNull
    Set<View> redactedViews() {
        if (!this.isEnabled()) {
            return new HashSet<View>();
        }
        if (!WebViewCustomClient.isJavaScriptEnabled((WebView)this.mWebViewRef.get())) {
            Log.d((String)"CobrowseIO", (String)"WebView doesn't have JavaScript enabled. Redacting entire WebView to ensure no sensitive data is exposed.");
            return this.getFullRedaction();
        }
        this.trackParentChanges();
        if (this.mWebViewRef.get() == null) {
            return new HashSet<View>();
        }
        Set<View> redactedViews = this.webViewRedactionManager.getRedactedViews();
        if (redactedViews == null) {
            return this.getFullRedaction();
        }
        return redactedViews;
    }

    void destroy() {
        this.reset();
        WebView originalWebView = (WebView)this.mWebViewRef.get();
        if (originalWebView != null) {
            originalWebView.setLayerType(this.originalLayerType, null);
            if (this.isEnabled()) {
                originalWebView.setOverScrollMode(this.overScrollModeType);
            }
        }
    }

    void reset() {
        Log.v((String)"CobrowseIO", (String)"WebViewCustomClient: Resetting state");
        this.frameCounter.set(0);
        this.resolvedFrameCounter.set(-1);
        if (this.mRootViewTreeObserver != null && this.mDrawListener != null) {
            try {
                this.mRootViewTreeObserver.removeOnDrawListener(this.mDrawListener);
                this.mDrawListener = null;
                this.mRootViewTreeObserver = null;
            }
            catch (Exception e) {
                Log.w((String)"CobrowseIO", (String)"WebViewCustomClient: Failed to remove draw listener", (Throwable)e);
            }
        }
        this.webViewRedactionManager.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String loadJavaScriptFromFile(@NonNull Context context) {
        InputStream inputStream = null;
        try {
            int bytesRead;
            inputStream = context.getAssets().open("webViewRedaction.js");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            String string2 = outputStream.toString(StandardCharsets.UTF_8.name());
            return string2;
        }
        catch (IOException e) {
            Log.w((String)"CobrowseIO", (String)"Failed to load JavaScript from file", (Throwable)e);
            String string3 = null;
            return string3;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    Log.w((String)"CobrowseIO", (String)"Failed to close input stream", (Throwable)e);
                }
            }
        }
    }

    private void injectJavaScript(@NonNull WebView webView, @NonNull Context context) {
        if (!this.isEnabled() || !WebViewCustomClient.isJavaScriptEnabled(webView)) {
            return;
        }
        String jsCode = this.loadJavaScriptFromFile(context);
        if (jsCode != null) {
            webView.evaluateJavascript(jsCode, value -> {
                if (value != null) {
                    Log.v((String)"CobrowseIO", (String)"WebViewCustomClient: JavaScript injected successfully");
                    this.registerViewTreeObserverListeners(webView);
                } else {
                    Log.v((String)"CobrowseIO", (String)"WebViewCustomClient: JavaScript injection failed");
                }
            });
        }
    }

    private void registerViewTreeObserverListeners(@NonNull WebView webView) {
        if (this.mDrawListener != null || !this.isEnabled()) {
            return;
        }
        this.mRootViewTreeObserver = webView.getViewTreeObserver();
        this.mDrawListener = () -> {
            int currentEvent = this.frameCounter.incrementAndGet();
            int scrollX = webView.getScrollX();
            int scrollY = webView.getScrollY();
            double deltaX = scrollX - this.resolvedScrollX.get();
            double deltaY = scrollY - this.resolvedScrollY.get();
            double factor = 0.2;
            double avgX = (double)this.scrollVelocityX.get() * factor + deltaX * (1.0 - factor);
            double avgY = (double)this.scrollVelocityY.get() * factor + deltaY * (1.0 - factor);
            this.scrollVelocityX.set((int)avgX);
            this.scrollVelocityY.set((int)avgY);
            this.resolvedScrollX.set(scrollX);
            this.resolvedScrollY.set(scrollY);
            this.queryDOM(webView, currentEvent);
        };
        Objects.requireNonNull(this.mRootViewTreeObserver).addOnDrawListener(this.mDrawListener);
    }

    private void queryDOM(@NonNull WebView webView, int eventVersion) {
        if (!this.isEnabled() || !WebViewCustomClient.isJavaScriptEnabled(webView)) {
            return;
        }
        webView.evaluateJavascript("window.cobrowseIOgetRedactedElementsBounds('" + this.mSelectorsString + "', " + eventVersion + ");", value -> {
            try {
                if (value.equals("null")) {
                    return;
                }
                JSONObject jsonResponse = new JSONObject(value);
                int counter = jsonResponse.getInt("counter");
                String error = jsonResponse.optString("error", "");
                if (!error.isEmpty()) {
                    Log.w((String)"CobrowseIO", (String)("Error occurred while querying the DOM: " + error));
                    return;
                }
                if (counter == this.frameCounter.get()) {
                    this.resolvedFrameCounter.set(counter);
                    this.webViewRedactionManager.updateOverlay(jsonResponse.getJSONArray("positions"), this.scrollVelocityX.get(), this.scrollVelocityY.get());
                }
            }
            catch (JSONException e) {
                Log.w((String)"CobrowseIO", (String)("WebViewCustomClient: Failed to parse JSON response: " + value), (Throwable)e);
            }
            catch (Exception e) {
                Log.v((String)"CobrowseIO", (String)"Error occurred while updating overlay. Likely webview has gone");
            }
        });
    }

    private void trackParentChanges() {
        WebView wv = (WebView)this.mWebViewRef.get();
        if (wv == null) {
            this.reset();
            return;
        }
        if (this.mParentViewGroup.get() != wv.getParent()) {
            this.reset();
            Log.v((String)"CobrowseIO", (String)"WebViewCustomClient: Parent view has changed");
            this.mParentViewGroup = new WeakReference<ViewGroup>((ViewGroup)wv.getParent());
            this.registerViewTreeObserverListeners(wv);
        }
    }
}

