/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.graphics.Rect;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class WebViewRedactionManager {
    @NonNull
    private final HashSet<View> mOverlayViews;
    @NonNull
    private final Map<String, View> mRectViewMap = new HashMap<String, View>();
    @NonNull
    private final WeakReference<WebView> mWebViewRef;
    @NonNull
    private WeakReference<ViewGroup> mRedactedViewsHolder = new WeakReference<Object>(null);
    private final float mDensity;

    WebViewRedactionManager(@NonNull WebView webView) {
        this.mWebViewRef = new WeakReference<WebView>(webView);
        this.mOverlayViews = new HashSet();
        this.mDensity = webView.getContext().getResources().getDisplayMetrics().density;
    }

    void updateOverlay(@NonNull JSONArray redactedPositions, int scrollVelocityX, int scrollVelocityY) throws JSONException {
        String key;
        WebView webView = (WebView)this.mWebViewRef.get();
        ViewGroup parentViewGroup = WebViewRedactionManager.findParentViewGroup((View)webView);
        if (parentViewGroup == null) {
            Log.e((String)"CobrowseIO", (String)"Cannot find a parent ViewGroup of WebView!");
            this.mRedactedViewsHolder = new WeakReference<Object>(null);
            return;
        }
        Rect webViewRect = this.getRelativeRect(webView, parentViewGroup);
        HashSet<View> skipRemoval = new HashSet<View>();
        HashMap<String, Pair> viewsToAdd = new HashMap<String, Pair>();
        for (int i = 0; i < redactedPositions.length(); ++i) {
            JSONObject position = redactedPositions.getJSONObject(i);
            Rect rect = this.getRectForPosition(position, webViewRect, scrollVelocityX, scrollVelocityY);
            key = rect.left + "-" + rect.top + "-" + rect.right + "-" + rect.bottom;
            if (!this.mRectViewMap.containsKey(key)) {
                View overlayView = WebViewRedactionManager.createOverlayView(parentViewGroup);
                overlayView.setLayoutParams(WebViewRedactionManager.getLayoutParamsForRect(parentViewGroup, rect));
                overlayView.bringToFront();
                viewsToAdd.put(key, new Pair((Object)overlayView, (Object)rect));
                continue;
            }
            skipRemoval.add(this.mRectViewMap.get(key));
        }
        Iterator<Map.Entry<String, View>> iterator = this.mRectViewMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, View> entry = iterator.next();
            View view = entry.getValue();
            if (skipRemoval.contains(view)) continue;
            iterator.remove();
            this.mOverlayViews.remove(view);
            parentViewGroup.removeView(view);
        }
        for (Map.Entry entry : viewsToAdd.entrySet()) {
            key = (String)entry.getKey();
            Pair pair = (Pair)entry.getValue();
            View view = (View)pair.first;
            this.mOverlayViews.add(view);
            parentViewGroup.addView(view);
            WebViewRedactionManager.layoutViewForReactNative(view, parentViewGroup, (Rect)pair.second);
            this.mRectViewMap.put(key, view);
        }
        this.mRedactedViewsHolder = new WeakReference<ViewGroup>(parentViewGroup);
    }

    private static void layoutViewForReactNative(@NonNull View view, @NonNull ViewGroup parentViewGroup, @NonNull Rect rect) {
        if (parentViewGroup.getClass().getName().equals("com.facebook.react.views.view.ReactViewGroup")) {
            view.layout(rect.left, rect.top, rect.right, rect.bottom);
        }
    }

    void reset() {
        this.clearRedactedViews();
        this.mOverlayViews.clear();
        this.mRectViewMap.clear();
    }

    @Nullable
    Set<View> getRedactedViews() {
        if (this.mRedactedViewsHolder.get() == null) {
            return null;
        }
        for (View view : this.mOverlayViews) {
            if (view.isLaidOut()) continue;
            return null;
        }
        return this.mOverlayViews;
    }

    @NonNull
    private Rect getRelativeRect(@NonNull WebView webView, @NonNull ViewGroup parentViewGroup) {
        Rect rect = new Rect();
        int[] locationInParent = new int[2];
        webView.getLocationInWindow(locationInParent);
        int[] parentLocation = new int[2];
        parentViewGroup.getLocationInWindow(parentLocation);
        rect.left = locationInParent[0] - parentLocation[0];
        rect.top = locationInParent[1] - parentLocation[1];
        rect.right = rect.left + webView.getWidth();
        rect.bottom = rect.top + webView.getHeight();
        return rect;
    }

    private void clearRedactedViews() {
        ViewGroup redactionHolder = (ViewGroup)this.mRedactedViewsHolder.get();
        if (redactionHolder != null) {
            for (View view : this.mOverlayViews) {
                redactionHolder.removeView(view);
            }
        }
        this.mOverlayViews.clear();
    }

    @NonNull
    private static View createOverlayView(@NonNull ViewGroup parentViewGroup) {
        View overlayView = new View(parentViewGroup.getContext());
        overlayView.setDrawingCacheEnabled(false);
        overlayView.setClickable(false);
        overlayView.setFocusable(false);
        overlayView.setFocusableInTouchMode(false);
        overlayView.setOnTouchListener(null);
        overlayView.setLongClickable(false);
        overlayView.setHapticFeedbackEnabled(false);
        return overlayView;
    }

    private int mapPropertyToInt(@NonNull JSONObject position, @NonNull String key) throws JSONException {
        return (int)Math.ceil(position.getDouble(key) * (double)this.mDensity);
    }

    @NonNull
    private Rect getRectForPosition(@NonNull JSONObject position, @NonNull Rect webviewRect, int scrollVelocityX, int scrollVelocityY) throws JSONException {
        int left = this.mapPropertyToInt(position, "left") + webviewRect.left - Math.abs(Math.max(0, scrollVelocityX)) * 3;
        int top = this.mapPropertyToInt(position, "top") + webviewRect.top - Math.abs(Math.max(0, scrollVelocityY)) * 3;
        int right = this.mapPropertyToInt(position, "right") + webviewRect.left + Math.abs(Math.min(0, scrollVelocityX)) * 3;
        int bottom = this.mapPropertyToInt(position, "bottom") + webviewRect.top + Math.abs(Math.min(0, scrollVelocityY)) * 3;
        return new Rect(left, top, right, bottom);
    }

    @Nullable
    private static ViewGroup findParentViewGroup(@NonNull View view) {
        ViewParent parent = view.getParent();
        if (!(parent instanceof View)) {
            return null;
        }
        if (parent.getClass().getName().startsWith("androidx.compose")) {
            return WebViewRedactionManager.findParentViewGroup((View)parent);
        }
        if (!(parent instanceof ViewGroup)) {
            return null;
        }
        return (ViewGroup)view.getParent();
    }

    @NonNull
    private static ViewGroup.LayoutParams getLayoutParamsForRect(@NonNull ViewGroup parentViewGroup, @NonNull Rect rect) {
        FrameLayout.LayoutParams layoutParams;
        if (parentViewGroup instanceof FrameLayout) {
            layoutParams = new FrameLayout.LayoutParams(rect.width(), rect.height());
            layoutParams.leftMargin = rect.left;
            layoutParams.topMargin = rect.top;
        } else if (parentViewGroup instanceof RelativeLayout) {
            layoutParams = new RelativeLayout.LayoutParams(rect.width(), rect.height());
            layoutParams.leftMargin = rect.left;
            layoutParams.topMargin = rect.top;
        } else if (parentViewGroup instanceof LinearLayout) {
            layoutParams = new LinearLayout.LayoutParams(rect.width(), rect.height());
            layoutParams.leftMargin = rect.left;
            layoutParams.topMargin = rect.top;
        } else if (parentViewGroup instanceof ConstraintLayout) {
            ConstraintLayout.LayoutParams constraintLayoutParams = new ConstraintLayout.LayoutParams(rect.width(), rect.height());
            constraintLayoutParams.leftToLeft = 0;
            constraintLayoutParams.topToTop = 0;
            constraintLayoutParams.leftMargin = rect.left;
            constraintLayoutParams.topMargin = rect.top;
            layoutParams = constraintLayoutParams;
        } else {
            layoutParams = new ViewGroup.MarginLayoutParams(rect.width(), rect.height());
            layoutParams.leftMargin = rect.left;
            layoutParams.topMargin = rect.top;
        }
        return layoutParams;
    }
}

