/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.app.Activity;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.webkit.WebViewCompat;
import androidx.webkit.WebViewFeature;
import io.cobrowse.CobrowseIO;
import io.cobrowse.WebViewClientProxy;
import io.cobrowse.WebViewCustomClient;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;

final class WebViewTrackerManager {
    @NonNull
    private final HashMap<Activity, Set<WebView>> activityWebViewMap = new HashMap();
    @NonNull
    private final WeakHashMap<WebView, WebViewCustomClient> customClients = new WeakHashMap();
    private final boolean isWebViewRedactionEnabled = WebViewFeature.isFeatureSupported((String)"GET_WEB_VIEW_CLIENT");

    WebViewTrackerManager() {
        if (!this.isWebViewRedactionEnabled) {
            Log.w((String)"CobrowseIO", (String)"WebView Redaction is not supported on this device. All webviews will be fully redacted.");
        }
    }

    @NonNull
    Set<View> getRedactedViewsForActivity(@NonNull Activity activity) {
        HashSet<View> redactedViews = new HashSet<View>();
        this.trackActivity(activity);
        if (this.activityWebViewMap.containsKey(activity)) {
            for (WebView webView : Objects.requireNonNull(this.activityWebViewMap.get(activity))) {
                if (this.isWebViewRedactionEnabled) {
                    Set<View> redacted = this.processViewsForWebView(webView, false);
                    redactedViews.addAll(redacted);
                    continue;
                }
                redactedViews.add((View)webView);
            }
        }
        return redactedViews;
    }

    boolean isSettled() {
        if (this.customClients.isEmpty()) {
            return true;
        }
        for (WebViewCustomClient client : this.customClients.values()) {
            if (client.isSettled()) continue;
            return false;
        }
        return true;
    }

    void destroy() {
        for (Activity activity : this.activityWebViewMap.keySet()) {
            this.resetWebViewsForActivity(activity);
        }
        this.activityWebViewMap.clear();
    }

    void untrackActivity(@NonNull Activity activity) {
        this.resetWebViewsForActivity(activity);
        this.activityWebViewMap.remove(activity);
    }

    @NonNull
    private Set<View> processViewsForWebView(@NonNull WebView webView, boolean isRecursive) {
        WebViewClient wvClient = this.getWebViewClient(webView);
        if (wvClient instanceof WebViewClientProxy) {
            return ((WebViewClientProxy)wvClient).redactedViews();
        }
        this.ensureWebViewClient(webView);
        if (isRecursive) {
            Log.w((String)"CobrowseIO", (String)"Could not set webview client after recursion.");
            return new HashSet<View>();
        }
        return this.processViewsForWebView(webView, true);
    }

    private void trackActivity(@NonNull Activity activity) {
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        HashSet<WebView> webViews = new HashSet<WebView>();
        this.findWebViewsRecursively(decorView, webViews);
        for (WebView webView : webViews) {
            this.ensureWebViewClient(webView);
        }
        if (this.activityWebViewMap.containsKey(activity)) {
            for (WebView webView : Objects.requireNonNull(this.activityWebViewMap.get(activity))) {
                if (webViews.contains(webView)) continue;
                if (webView.isShown()) {
                    Log.i((String)"CobrowseIO", (String)"WebView removed from view hierarchy but still shown. Tracking.");
                    webViews.add(webView);
                    continue;
                }
                this.untrackWebView(webView);
            }
            this.activityWebViewMap.remove(activity);
        }
        this.activityWebViewMap.put(activity, webViews);
    }

    private void resetWebViewsForActivity(@NonNull Activity activity) {
        HashSet<WebView> webviews = new HashSet<WebView>();
        this.findWebViewsRecursively((ViewGroup)activity.getWindow().getDecorView(), webviews);
        if (this.activityWebViewMap.containsKey(activity)) {
            webviews.addAll((Collection<WebView>)Objects.requireNonNull(this.activityWebViewMap.get(activity)));
        }
        for (WebView webView : webviews) {
            this.untrackWebView(webView);
        }
    }

    private void untrackWebView(@NonNull WebView webView) {
        WebViewClient wvClient = this.getWebViewClient(webView);
        if (wvClient instanceof WebViewClientProxy) {
            ((WebViewClientProxy)wvClient).destroy();
            webView.setWebViewClient(((WebViewClientProxy)wvClient).userWebViewClient);
        }
        this.customClients.remove(webView);
    }

    private void findWebViewsRecursively(@NonNull ViewGroup parent, @NonNull HashSet<WebView> webViewList) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View child = parent.getChildAt(i);
            if (child instanceof WebView) {
                webViewList.add((WebView)child);
                continue;
            }
            if (!(child instanceof ViewGroup)) continue;
            this.findWebViewsRecursively((ViewGroup)child, webViewList);
        }
    }

    @Nullable
    private WebViewClient getWebViewClient(@NonNull WebView webView) {
        if (WebViewFeature.isFeatureSupported((String)"GET_WEB_VIEW_CLIENT")) {
            return WebViewCompat.getWebViewClient((WebView)webView);
        }
        return null;
    }

    private void ensureWebViewClient(@NonNull WebView webView) {
        WebViewClient userWebViewClient = this.getWebViewClient(webView);
        if (!(userWebViewClient instanceof WebViewClientProxy)) {
            WebViewClient decoratedWebViewClient = this.wrapWebViewClient(webView, userWebViewClient);
            webView.setWebViewClient(decoratedWebViewClient);
        }
    }

    @NonNull
    private WebViewClient wrapWebViewClient(@NonNull WebView wv, WebViewClient webViewClient) {
        WebViewCustomClient customWebViewClient = new WebViewCustomClient(wv, CobrowseIO.instance().webviewRedactedViews());
        this.customClients.put(wv, customWebViewClient);
        return new WebViewClientProxy(customWebViewClient, webViewClient);
    }
}

