/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.inspector.WindowInspector;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class Windows {
    Windows() {
    }

    @NonNull
    static List<View> getAll() {
        return Build.VERSION.SDK_INT >= 29 ? Windows.getAllV29() : Windows.getAllV19();
    }

    @RequiresApi(api=29)
    @NonNull
    private static List<View> getAllV29() {
        return WindowInspector.getGlobalWindowViews();
    }

    @NonNull
    private static List<View> getAllV19() {
        try {
            Class<?> wmgClass = Class.forName("android.view.WindowManagerGlobal");
            Object wmgInstance = wmgClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            return Windows.viewsFromWM(wmgClass, wmgInstance);
        }
        catch (Exception e) {
            Log.e((String)"CobrowseIO", (String)"Failed to obtain the list of app windows", (Throwable)e);
            return new ArrayList<View>();
        }
    }

    @NonNull
    static List<View> getAll(@Nullable Display display) {
        if (display == null) {
            return Windows.getAll();
        }
        ArrayList<View> views = new ArrayList<View>();
        for (View view : Windows.getAll()) {
            Display attachedTo = view.getDisplay();
            if (attachedTo == null || attachedTo.getDisplayId() != display.getDisplayId()) continue;
            views.add(view);
        }
        return views;
    }

    @Nullable
    static View getFocused(@Nullable Display display) {
        for (View v : Windows.getAll(display)) {
            if (!v.hasWindowFocus()) continue;
            return v;
        }
        return null;
    }

    @NonNull
    private static List<View> viewsFromWM(@NonNull Class wmClass, @NonNull Object wmInstance) throws Exception {
        Field viewsField = wmClass.getDeclaredField("mViews");
        viewsField.setAccessible(true);
        Object views = viewsField.get(wmInstance);
        if (views instanceof List) {
            return (List)viewsField.get(wmInstance);
        }
        if (views instanceof View[]) {
            return Arrays.asList((View[])viewsField.get(wmInstance));
        }
        return new ArrayList<View>();
    }
}

