/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse.ui;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.Callback;
import io.cobrowse.CobrowseIO;
import io.cobrowse.R;
import io.cobrowse.Session;
import io.cobrowse.ui.CodeDisplay;
import io.cobrowse.ui.ErrorView;
import io.cobrowse.ui.ManageSession;

public class CobrowseActivity
extends Activity {
    @NonNull
    static final String TAG = "CobrowseActivity";
    @NonNull
    private final CodeDisplay codeDisplay = new CodeDisplay();
    @NonNull
    private final ManageSession manageView = new ManageSession();
    @NonNull
    private final ErrorView errorView = new ErrorView();
    private boolean wasActive = false;

    protected void showFragment(@NonNull Fragment fragment) {
        if (this.isFinishing()) {
            return;
        }
        if (this.isDestroyed()) {
            return;
        }
        if (this.isChangingConfigurations()) {
            return;
        }
        FragmentTransaction transaction = this.getFragmentManager().beginTransaction();
        transaction.replace(R.id.cobrowse_fragment_container, fragment);
        transaction.commitAllowingStateLoss();
    }

    protected void createSession(final @Nullable Callback<Error, Session> callback) {
        CobrowseIO.instance().createSession(new Callback<Error, Session>(){

            @Override
            public void call(@Nullable Error err, @Nullable Session session) {
                if (err != null) {
                    CobrowseActivity.this.showError(err);
                } else {
                    CobrowseActivity.this.render(session);
                }
                if (callback != null) {
                    callback.call(err, session);
                }
            }
        });
    }

    protected void showError(@NonNull Error err) {
        Log.e((String)TAG, (String)("Cobrowse error: " + err.getMessage()));
        this.showFragment(this.errorView);
    }

    protected void render(@Nullable Session session) {
        if (session == null || session.isPending()) {
            this.showFragment(this.codeDisplay);
            if (session != null) {
                this.codeDisplay.setCode(session.code());
            }
        } else if (session.isActive()) {
            this.showFragment(this.manageView);
        }
    }

    protected void listenTo(@NonNull Session session) {
        this.wasActive = session.isActive();
        session.registerSessionListener(new Session.Listener(){

            @Override
            public void sessionDidUpdate(@NonNull Session session) {
                if (session.isActive() && !CobrowseActivity.this.wasActive) {
                    CobrowseActivity.this.finish();
                } else {
                    CobrowseActivity.this.render(session);
                }
                CobrowseActivity.this.wasActive = session.isActive();
            }

            @Override
            public void sessionDidEnd(@NonNull Session session) {
                CobrowseActivity.this.render(session);
                CobrowseActivity.this.finish();
            }
        });
    }

    protected void onCreate(Bundle instanceSavedState) {
        super.onCreate(instanceSavedState);
        this.setContentView(R.layout.activity_cobrowse);
    }

    protected void onResume() {
        super.onResume();
        Session current = CobrowseIO.instance().currentSession();
        if (current != null) {
            this.listenTo(current);
        }
        if (current == null || current.isEnded()) {
            this.createSession(new Callback<Error, Session>(){

                @Override
                public void call(@Nullable Error err, @Nullable Session session) {
                    if (err != null) {
                        CobrowseActivity.this.showError(err);
                    }
                    if (session != null) {
                        CobrowseActivity.this.listenTo(session);
                    }
                }
            });
        }
        this.render(current);
    }

    public void endSessionClicked(View view) {
        Session session = CobrowseIO.instance().currentSession();
        if (session != null) {
            session.end(new Callback<Error, Session>(){

                @Override
                public void call(@Nullable Error err, @Nullable Session session) {
                    if (err != null) {
                        CobrowseActivity.this.showError(err);
                    } else {
                        CobrowseActivity.this.finish();
                    }
                }
            });
        }
    }
}

