/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import androidx.annotation.NonNull;
import io.cobrowse.CobrowseIO;
import io.cobrowse.R;
import io.cobrowse.Session;

public class RemoteControlConsentDialogFragment
extends DialogFragment {
    public void onCreate(@NonNull Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
    }

    public void onDestroyView() {
        if (this.getDialog() != null && this.getRetainInstance()) {
            this.getDialog().setDismissMessage(null);
        }
        super.onDestroyView();
    }

    @NonNull
    public Dialog onCreateDialog(@NonNull Bundle savedInstanceState) {
        this.setCancelable(false);
        return new AlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.cobrowse_remote_control_request_title).setMessage(R.string.cobrowse_approve_remote_control_description).setPositiveButton(R.string.cobrowse_approve_remote_control_button_yes, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int w) {
                Session session = CobrowseIO.instance().currentSession();
                if (session != null) {
                    session.setRemoteControl(Session.RemoteControlState.On, null);
                }
            }
        }).setNegativeButton(R.string.cobrowse_approve_remote_control_button_no, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int w) {
                Session session = CobrowseIO.instance().currentSession();
                if (session != null) {
                    session.setRemoteControl(Session.RemoteControlState.Rejected, null);
                }
            }
        }).create();
    }

    public void show(@NonNull Activity activity) {
        String tag = "cobrowse-remote-control-consent-prompt";
        FragmentManager fragments = activity.getFragmentManager();
        FragmentTransaction transaction = fragments.beginTransaction();
        Fragment previous = fragments.findFragmentByTag(tag);
        if (previous != null) {
            transaction.remove(previous);
        }
        this.show(transaction, tag);
    }
}

