/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.props2yaml.maven;

import io.codearte.props2yaml.Props2YAML;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="convert", requiresProject=false)
public class ConvertMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}")
    private File output;
    @Parameter(property="properties", required=false)
    private String properties;
    @Parameter(property="useNumericKeysAsArrayIndexes", required=false, defaultValue="true")
    private boolean useNumericKeysAsArrayIndexes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.properties == null || this.properties.isEmpty()) {
            throw new MojoExecutionException("Param 'properties' is required");
        }
        Path propertiesPath = this.propertiesPath();
        try {
            this.getLog().info((CharSequence)("Properties to convert: " + propertiesPath));
            String content = new String(Files.readAllBytes(propertiesPath));
            String yaml = Props2YAML.fromContent((String)content).convert(this.useNumericKeysAsArrayIndexes);
            Path destinationPath = propertiesPath.getParent().resolve(this.getFileName());
            this.getLog().info((CharSequence)("Write YAML to: " + destinationPath));
            try (BufferedWriter writer = Files.newBufferedWriter(destinationPath, new OpenOption[0]);){
                writer.write(yaml);
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Failed to convert properties", (Throwable)e);
        }
    }

    private Path propertiesPath() {
        File file = new File(this.properties);
        if (!file.isAbsolute()) {
            file = new File(this.output, this.properties);
        }
        return file.toPath();
    }

    private String getFileName() {
        if (this.properties.contains(".")) {
            return this.properties.substring(0, this.properties.lastIndexOf(46)) + ".yml";
        }
        return this.properties + ".yml";
    }
}

