/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.diffpatch.util;

import io.codechicken.diffpatch.util.IOValidationException;
import io.codechicken.diffpatch.util.Input;
import io.codechicken.diffpatch.util.archiver.ArchiveFormat;
import io.codechicken.diffpatch.util.archiver.ArchiveWriter;
import io.codechicken.repack.net.covers1624.quack.io.IOUtils;
import io.codechicken.repack.net.covers1624.quack.util.SneakyUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public abstract class Output {
    public abstract void validate(String var1) throws IOValidationException;

    public boolean isSamePath(Input input) {
        return false;
    }

    public static class FolderMultiOutput
    extends MultiOutput {
        public final Path folder;

        public FolderMultiOutput(Path folder) {
            this.folder = folder;
        }

        @Override
        public void validate(String kind) throws IOValidationException {
            if (Files.exists(this.folder, new LinkOption[0]) && !Files.isDirectory(this.folder, new LinkOption[0])) {
                throw new IOValidationException("Output '" + kind + "' already exists and is not a file.");
            }
        }

        @Override
        public void open(boolean clearOutput) throws IOException {
            if (clearOutput && Files.exists(this.folder, new LinkOption[0])) {
                try (Stream<Path> stream = Files.walk(this.folder, new FileVisitOption[0]);){
                    stream.sorted(Comparator.reverseOrder()).forEach(SneakyUtils.sneak(Files::delete));
                }
            }
        }

        @Override
        public void write(String path, byte[] data) throws IOException {
            Files.write(IOUtils.makeParents(this.folder.resolve(path)), data, new OpenOption[0]);
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isSamePath(Input input) {
            if (!(input instanceof Input.FolderMultiInput)) {
                return false;
            }
            return this.folder.equals(((Input.FolderMultiInput)input).folder);
        }
    }

    public static class PipeArchiveMultiOutput
    extends ArchiveMultiOutput {
        private final OutputStream os;

        public PipeArchiveMultiOutput(ArchiveFormat format, OutputStream os) {
            super(format);
            this.os = os;
        }

        @Override
        public void validate(String kind) {
        }

        @Override
        protected OutputStream openStream() {
            return IOUtils.protectClose(this.os);
        }
    }

    public static class PathArchiveMultiOutput
    extends ArchiveMultiOutput {
        private final Path path;

        public PathArchiveMultiOutput(ArchiveFormat format, Path path) {
            super(format);
            this.path = path;
        }

        @Override
        public void validate(String kind) throws IOValidationException {
            if (Files.exists(this.path, new LinkOption[0]) && !Files.isRegularFile(this.path, new LinkOption[0])) {
                throw new IOValidationException("Output '" + kind + "' already exists and is not a file.");
            }
        }

        @Override
        protected OutputStream openStream() throws IOException {
            return Files.newOutputStream(this.path, new OpenOption[0]);
        }
    }

    public static abstract class ArchiveMultiOutput
    extends MultiOutput {
        private final ArchiveFormat format;
        @Nullable
        private ArchiveWriter aw;

        public ArchiveMultiOutput(ArchiveFormat format) {
            this.format = format;
        }

        protected abstract OutputStream openStream() throws IOException;

        @Override
        public void open(boolean clearOutput) throws IOException {
            if (this.aw != null) {
                throw new IllegalStateException("Already opened.");
            }
            this.aw = this.format.createWriter(this.openStream());
        }

        @Override
        public void write(String path, byte[] data) throws IOException {
            if (this.aw == null) {
                throw new IllegalStateException("Not opened.");
            }
            this.aw.writeEntry(path, data);
        }

        @Override
        public void close() throws IOException {
            if (this.aw == null) {
                throw new IllegalStateException("Not opened.");
            }
            this.aw.close();
        }
    }

    public static abstract class MultiOutput
    extends Output
    implements AutoCloseable {
        public static MultiOutput archive(ArchiveFormat format, Path path) {
            return new PathArchiveMultiOutput(format, path);
        }

        public static MultiOutput detectedArchive(Path path) throws IllegalArgumentException {
            ArchiveFormat format = ArchiveFormat.findFormat(path);
            if (format == null) {
                throw new IllegalArgumentException("Unable to detect archive format for " + path.getFileName());
            }
            return MultiOutput.archive(format, path);
        }

        public static MultiOutput archive(ArchiveFormat format, OutputStream stream) {
            return new PipeArchiveMultiOutput(format, stream);
        }

        public static MultiOutput folder(Path output) {
            return new FolderMultiOutput(output);
        }

        public abstract void open(boolean var1) throws IOException;

        public abstract void write(String var1, byte[] var2) throws IOException;

        @Override
        public abstract void close() throws IOException;
    }

    public static abstract class SingleOutput
    extends Output {
        public static SingleOutput pipe(OutputStream out) {
            return new ToStream(out);
        }

        public static SingleOutput path(Path path, OpenOption ... opts) {
            return new ToPath(path, opts);
        }

        public abstract OutputStream open() throws IOException;

        public static class ToPath
        extends SingleOutput {
            private final Path path;
            private final OpenOption[] opts;

            public ToPath(Path path, OpenOption ... opts) {
                this.path = path;
                this.opts = opts;
            }

            @Override
            public void validate(String kind) throws IOValidationException {
                if (Files.exists(this.path, new LinkOption[0]) && !Files.isRegularFile(this.path, new LinkOption[0])) {
                    throw new IOValidationException("Output '" + kind + "' already exists and is not a file.");
                }
            }

            @Override
            public OutputStream open() throws IOException {
                return Files.newOutputStream(IOUtils.makeParents(this.path), this.opts);
            }
        }

        public static class ToStream
        extends SingleOutput {
            private final OutputStream out;

            public ToStream(OutputStream out) {
                this.out = out;
            }

            @Override
            public void validate(String kind) {
            }

            @Override
            public OutputStream open() {
                return IOUtils.protectClose(this.out);
            }
        }
    }
}

