/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.net.covers1624.quack.asm;

import io.codechicken.repack.net.covers1624.quack.annotation.Requires;
import io.codechicken.repack.net.covers1624.quack.asm.ClassBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.FieldNode;

@Requires(value="org.ow2.asm:asm")
public final class MethodBuilder {
    private final int access;
    private final Type owner;
    private final String name;
    private final Type desc;
    @Nullable
    private String signature;
    private final List<String> exceptions = new LinkedList<String>();
    @Nullable
    private ClassBuilder ownerBuilder;
    @Nullable
    private Consumer<BodyGenerator> bodyGenerator;

    MethodBuilder(int access, ClassBuilder owner, String name, Type desc) {
        this.access = access;
        this.owner = owner.name();
        this.name = name;
        this.desc = desc;
        this.ownerBuilder = owner;
    }

    private MethodBuilder(int access, Type owner, String name, Type desc) {
        this.access = access;
        this.owner = owner;
        this.name = name;
        this.desc = desc;
    }

    public static MethodBuilder of(int access, Type owner, String name, Type desc) {
        return new MethodBuilder(access, owner, name, desc);
    }

    public MethodBuilder withSignature(String signature) {
        this.signature = signature;
        return this;
    }

    public MethodBuilder withException(String exception) {
        this.exceptions.add(exception);
        return this;
    }

    public MethodBuilder withBody(Consumer<BodyGenerator> func) {
        if (this.bodyGenerator != null) {
            throw new RuntimeException("Unable to add more than one body generator.");
        }
        this.bodyGenerator = func;
        return this;
    }

    public MethodVisitor build(ClassVisitor cv) {
        if ((this.access & 0x400) == 0 && this.bodyGenerator == null) {
            throw new IllegalStateException("Attempted to generate a non-abstract method without a body.");
        }
        MethodVisitor mv = cv.visitMethod(this.access, this.name, this.desc.getDescriptor(), this.signature, this.exceptions.toArray(new String[0]));
        if (this.bodyGenerator != null) {
            BodyGenerator bodyGen = new BodyGenerator(mv, this.access, this.owner, this.desc);
            mv.visitCode();
            this.bodyGenerator.accept(bodyGen);
            mv.visitMaxs(-1, -1);
        }
        mv.visitEnd();
        return mv;
    }

    public int access() {
        return this.access;
    }

    public Type owner() {
        return this.owner;
    }

    public String name() {
        return this.name;
    }

    public Type desc() {
        return this.desc;
    }

    @Nullable
    public String signature() {
        return this.signature;
    }

    public List<String> exceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public static class BodyGenerator {
        private final MethodVisitor mv;
        private final Type desc;
        @Nullable
        private final Var thisVar;
        private final Var[] params;
        private final BitSet usedVars = new BitSet();

        public BodyGenerator(MethodVisitor mv, int access, Type owner, Type desc) {
            this.mv = mv;
            this.desc = desc;
            this.thisVar = (access & 8) == 0 ? this.pushVar(owner, false) : null;
            Type[] types = desc.getArgumentTypes();
            this.params = new Var[types.length];
            for (int i = 0; i < types.length; ++i) {
                this.params[i] = this.pushVar(types[i], false);
            }
        }

        private Var pushVar(Type type, boolean canFree) {
            int index = 0;
            do {
                index = this.usedVars.nextClearBit(index);
            } while (type.getSize() == 2 && this.usedVars.nextClearBit(index + 1) - 1 != index);
            this.usedVars.set(index, index + type.getSize());
            return new Var(this, index, type, canFree);
        }

        private void popVar(Var var) {
            this.usedVars.clear(var.index, var.index + var.type.getSize());
        }

        public Var getThis() {
            if (this.thisVar == null) {
                throw new UnsupportedOperationException("Static methods don't have 'this'.");
            }
            return this.thisVar;
        }

        public int numParams() {
            return this.params.length;
        }

        public Var param(int index) {
            return this.params[index];
        }

        public Var newVar(Type type) {
            return this.pushVar(type, true);
        }

        public void ret() {
            this.insn(this.desc.getReturnType().getOpcode(172));
        }

        public void insn(int opcode) {
            this.mv.visitInsn(opcode);
        }

        public void intInsn(int opcode, int operand) {
            this.mv.visitIntInsn(opcode, operand);
        }

        public void loadThis() {
            this.load(this.getThis());
        }

        public void loadParam(int index) {
            this.load(this.param(index));
        }

        public void load(Var var) {
            this.varInsn(var.type.getOpcode(21), var.getIndex());
        }

        public void storeParam(int index) {
            this.store(this.param(index));
        }

        public void store(Var var) {
            this.varInsn(var.type.getOpcode(54), var.getIndex());
        }

        public void varInsn(int opcode, int var) {
            this.mv.visitVarInsn(opcode, var);
        }

        public void typeInsn(int opcode, Type type) {
            assert (type.getSort() == 10);
            this.mv.visitTypeInsn(opcode, type.getInternalName());
        }

        public void getField(ClassBuilder.FieldBuilder field) {
            this.fieldInsn((field.access() & 8) != 0 ? 178 : 180, field);
        }

        public void putField(ClassBuilder.FieldBuilder field) {
            this.fieldInsn((field.access() & 8) != 0 ? 179 : 181, field);
        }

        public void fieldInsn(int opcode, ClassBuilder.FieldBuilder field) {
            this.fieldInsn(opcode, field.owner().name(), field.name(), field.desc());
        }

        public void getField(Field field) {
            this.fieldInsn(Modifier.isStatic(field.getModifiers()) ? 178 : 180, field);
        }

        public void putField(Field field) {
            this.fieldInsn(Modifier.isStatic(field.getModifiers()) ? 179 : 181, field);
        }

        public void fieldInsn(int opcode, Field field) {
            this.fieldInsn(opcode, Type.getType(field.getDeclaringClass()), field.getName(), Type.getType(field.getType()));
        }

        @Requires(value="org.ow2.asm:asm-tree")
        public void getField(Type owner, FieldNode fDesc) {
            this.fieldInsn((fDesc.access & 8) != 0 ? 178 : 180, owner, fDesc);
        }

        @Requires(value="org.ow2.asm:asm-tree")
        public void putField(Type owner, FieldNode fDesc) {
            this.fieldInsn((fDesc.access & 8) != 0 ? 179 : 181, owner, fDesc);
        }

        @Requires(value="org.ow2.asm:asm-tree")
        public void fieldInsn(int opcode, Type owner, FieldNode fNode) {
            this.fieldInsn(opcode, owner, fNode.name, Type.getType((String)fNode.desc));
        }

        public void fieldInsn(int opcode, Type owner, String name, Type descriptor) {
            assert (owner.getSort() == 10);
            this.mv.visitFieldInsn(opcode, owner.getInternalName(), name, descriptor.getDescriptor());
        }

        public void methodInsn(Method method) {
            int opcode = Modifier.isStatic(method.getModifiers()) ? 184 : (Modifier.isInterface(method.getDeclaringClass().getModifiers()) ? 185 : 182);
            this.methodInsn(opcode, method);
        }

        public void methodInsn(int opcode, Method method) {
            this.methodInsn(opcode, Type.getType(method.getDeclaringClass()), method.getName(), Type.getType((Method)method), Modifier.isInterface(method.getDeclaringClass().getModifiers()));
        }

        public void methodInsn(int opcode, MethodBuilder method) {
            this.methodInsn(opcode, method, method.ownerBuilder != null && (method.ownerBuilder.access() & 0x200) != 0);
        }

        public void methodInsn(int opcode, MethodBuilder method, boolean isInterface) {
            this.methodInsn(opcode, method.owner, method.name, method.desc, isInterface);
        }

        public void methodInsn(int opcode, Type owner, String name, Type descriptor, boolean isInterface) {
            assert (owner.getSort() == 10);
            this.mv.visitMethodInsn(opcode, owner.getInternalName(), name, descriptor.getDescriptor(), isInterface);
        }

        public void invokeDynamic(String name, Type descriptor, Handle boostrapMethod, Object ... bsmArgs) {
            this.mv.visitInvokeDynamicInsn(name, descriptor.getDescriptor(), boostrapMethod, bsmArgs);
        }

        public void jump(int opcode, Label label) {
            this.mv.visitJumpInsn(opcode, label);
        }

        public void label(Label label) {
            this.mv.visitLabel(label);
        }

        public void ldcInt(int i) {
            this.ldc(i);
        }

        public void ldcFloat(float f) {
            this.ldc(Float.valueOf(f));
        }

        public void ldcLong(long l) {
            this.ldc(l);
        }

        public void ldcDouble(double d) {
            this.ldc(d);
        }

        public void ldcString(String str) {
            this.ldc(str);
        }

        public void ldcClass(Type type) {
            assert (type.getSort() == 10 || type.getSort() == 9);
            this.ldc(type);
        }

        public void ldc(Object obj) {
            this.mv.visitLdcInsn(obj);
        }

        public void iinc(int var, int increment) {
            this.mv.visitIincInsn(var, increment);
        }

        public void tableSwitch(int min, int max, Label default_, Label ... labels) {
            this.mv.visitTableSwitchInsn(min, max, default_, labels);
        }

        public void lookupSwitch(Label default_, int[] keys, Label[] labels) {
            this.mv.visitLookupSwitchInsn(default_, keys, labels);
        }

        public void multiNewArray(Type descriptor, int numDimensions) {
            this.mv.visitMultiANewArrayInsn(descriptor.getDescriptor(), numDimensions);
        }

        public void tryCatchBlock(Label start, Label end, Label handler, @Nullable Type type) {
            this.mv.visitTryCatchBlock(start, end, handler, type != null ? type.getDescriptor() : null);
        }

        public static class Var {
            private final BodyGenerator gen;
            private final int index;
            private final Type type;
            private final boolean canFree;
            private boolean freed;

            public Var(BodyGenerator gen, int index, Type type, boolean canFree) {
                this.gen = gen;
                this.index = index;
                this.type = type;
                this.canFree = canFree;
            }

            public int getIndex() {
                if (this.freed) {
                    throw new IllegalStateException("Use after free.");
                }
                return this.index;
            }

            public void free() {
                if (!this.canFree) {
                    throw new UnsupportedOperationException("Variable cannot be freed.");
                }
                this.gen.popVar(this);
                this.freed = true;
            }
        }
    }
}

