package io.codescan.sast.model;

import java.util.List;
import lombok.Data;

@Data
public class Vulnerability {

    /**
     * Unique identifier of the vulnerability. This is recommended to be a UUID.
     */
    private String id;

    /**
     * Describes where this vulnerability belongs (for example, SAST, Dependency Scanning, and so on).
     */
    private VulnerabilityCategory category;

    /**
     * The name of the vulnerability. This must not include the finding's specific information.
     */
    private String name;

    /**
     * A short text section that describes the vulnerability. This may include the finding's specific information.
     */
    private String message;

    /**
     * A long text section describing the vulnerability more fully.
     */
    private String description;

    /**
     * How much the vulnerability impacts the software. Possible values are Info, Unknown, Low, Medium, High,
     * or Critical. Note that some analyzers may not report all these possible values.
     */
    private Severity severity;

    /**
     * How reliable the vulnerability's assessment is. Possible values are Ignore, Unknown, Experimental, Low, Medium,
     * High, and Confirmed. Note that some analyzers may not report all these possible values.
     */
    private Confidence confidence;

    /**
     * Explanation of how to fix the vulnerability.
     */
    private String solution;

    /**
     * Describes the scanner used to find this vulnerability.
     */
    private Scanner scanner;

    /**
     * An ordered array of references that identify a vulnerability on internal or external databases.
     * The first identifier is the Primary Identifier, which has special meaning.
     */
    private List<Identifier> identifiers;

    /**
     * An array of references to external documentation or articles that describe the vulnerability.
     */
    private List<Link> links;

    /**
     * Identifies the vulnerability's location.
     */
    private Location location;
}
