/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.WorkerThread;
import coil.bitmap.BitmapPool;
import coil.decode.DecodeUtils;
import coil.size.OriginalSize;
import coil.size.PixelSize;
import coil.size.Scale;
import coil.size.Size;
import coil.util.-Bitmaps;
import coil.util.-Extensions;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcoil/decode/DrawableDecoderService;", "", "bitmapPool", "Lcoil/bitmap/BitmapPool;", "(Lcoil/bitmap/BitmapPool;)V", "convert", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "config", "Landroid/graphics/Bitmap$Config;", "size", "Lcoil/size/Size;", "scale", "Lcoil/size/Scale;", "allowInexactSize", "", "isConfigValid", "bitmap", "isSizeValid", "Companion", "coil-base_release"})
public final class DrawableDecoderService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BitmapPool bitmapPool;
    private static final int DEFAULT_SIZE = 512;

    public DrawableDecoderService(@NotNull BitmapPool bitmapPool) {
        Intrinsics.checkNotNullParameter((Object)bitmapPool, (String)"bitmapPool");
        this.bitmapPool = bitmapPool;
    }

    @WorkerThread
    @NotNull
    public final Bitmap convert(@NotNull Drawable drawable, @NotNull Bitmap.Config config, @NotNull Size size2, @NotNull Scale scale, boolean allowInexactSize) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        if (drawable instanceof BitmapDrawable) {
            Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
            if (this.isConfigValid(bitmap, config) && this.isSizeValid(allowInexactSize, size2, bitmap, scale)) {
                return bitmap;
            }
        }
        Drawable drawable2 = drawable.mutate();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"drawable.mutate()");
        Drawable safeDrawable = drawable2;
        int n = -Extensions.getWidth(safeDrawable);
        int n2 = 0;
        boolean bl = false;
        int it = n;
        boolean bl2 = false;
        int srcWidth = it > 0 ? it : 512;
        n2 = -Extensions.getHeight(safeDrawable);
        bl = false;
        it = 0;
        int it2 = n2;
        boolean bl3 = false;
        int srcHeight = it2 > 0 ? it2 : 512;
        PixelSize pixelSize = DecodeUtils.computePixelSize(srcWidth, srcHeight, size2, scale);
        int width = pixelSize.component1();
        int height = pixelSize.component2();
        Bitmap bitmap = this.bitmapPool.get(width, height, -Bitmaps.toSoftware(config));
        Drawable drawable3 = safeDrawable;
        boolean bl4 = false;
        boolean bl5 = false;
        Drawable $this$convert_u24lambda_u2d2 = drawable3;
        boolean bl6 = false;
        Rect rect = safeDrawable.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"bounds");
        Rect $this$component1$iv = rect;
        boolean $i$f$component1 = false;
        int oldLeft = $this$component1$iv.left;
        Rect $this$component2$iv = rect;
        boolean $i$f$component2 = false;
        int oldTop = $this$component2$iv.top;
        Rect $this$component3$iv = rect;
        boolean $i$f$component3 = false;
        int oldRight = $this$component3$iv.right;
        Rect $this$component4$iv = rect;
        boolean $i$f$component4 = false;
        int oldBottom = $this$component4$iv.bottom;
        $this$convert_u24lambda_u2d2.setBounds(0, 0, width, height);
        $this$convert_u24lambda_u2d2.draw(new Canvas(bitmap));
        $this$convert_u24lambda_u2d2.setBounds(oldLeft, oldTop, oldRight, oldBottom);
        return bitmap;
    }

    private final boolean isConfigValid(Bitmap bitmap, Bitmap.Config config) {
        return bitmap.getConfig() == -Bitmaps.toSoftware(config);
    }

    private final boolean isSizeValid(boolean allowInexactSize, Size size2, Bitmap bitmap, Scale scale) {
        return allowInexactSize || size2 instanceof OriginalSize || Intrinsics.areEqual((Object)size2, (Object)DecodeUtils.computePixelSize(bitmap.getWidth(), bitmap.getHeight(), size2, scale));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/decode/DrawableDecoderService$Companion;", "", "()V", "DEFAULT_SIZE", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

