/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import androidx.annotation.Px;
import coil.size.OriginalSize;
import coil.size.PixelSize;
import coil.size.Scale;
import coil.size.Size;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u000e2\b\b\u0001\u0010\u0011\u001a\u00020\u000e2\b\b\u0001\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J8\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u000f\u001a\u00020\u001a2\b\b\u0001\u0010\u0010\u001a\u00020\u001a2\b\b\u0001\u0010\u0011\u001a\u00020\u001a2\b\b\u0001\u0010\u0012\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J8\u0010\u0019\u001a\u00020\u001b2\b\b\u0001\u0010\u000f\u001a\u00020\u001b2\b\b\u0001\u0010\u0010\u001a\u00020\u001b2\b\b\u0001\u0010\u0011\u001a\u00020\u001b2\b\b\u0001\u0010\u0012\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J8\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u000e2\b\b\u0001\u0010\u0011\u001a\u00020\u000e2\b\b\u0001\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcoil/decode/DecodeUtils;", "", "()V", "GIF_HEADER_87A", "Lokio/ByteString;", "GIF_HEADER_89A", "HEIF_HEADER_FTYP", "HEIF_HEADER_HEVC", "HEIF_HEADER_HEVX", "HEIF_HEADER_MSF1", "WEBP_HEADER_RIFF", "WEBP_HEADER_VPX8", "WEBP_HEADER_WEBP", "calculateInSampleSize", "", "srcWidth", "srcHeight", "dstWidth", "dstHeight", "scale", "Lcoil/size/Scale;", "computePixelSize", "Lcoil/size/PixelSize;", "dstSize", "Lcoil/size/Size;", "computeSizeMultiplier", "", "", "isAnimatedHeif", "", "source", "Lokio/BufferedSource;", "isAnimatedWebP", "isGif", "isHeif", "isWebP", "coil-base_release"})
public final class DecodeUtils {
    @NotNull
    public static final DecodeUtils INSTANCE = new DecodeUtils();
    @NotNull
    private static final ByteString GIF_HEADER_87A = ByteString.Companion.encodeUtf8("GIF87a");
    @NotNull
    private static final ByteString GIF_HEADER_89A = ByteString.Companion.encodeUtf8("GIF89a");
    @NotNull
    private static final ByteString WEBP_HEADER_RIFF = ByteString.Companion.encodeUtf8("RIFF");
    @NotNull
    private static final ByteString WEBP_HEADER_WEBP = ByteString.Companion.encodeUtf8("WEBP");
    @NotNull
    private static final ByteString WEBP_HEADER_VPX8 = ByteString.Companion.encodeUtf8("VP8X");
    @NotNull
    private static final ByteString HEIF_HEADER_FTYP = ByteString.Companion.encodeUtf8("ftyp");
    @NotNull
    private static final ByteString HEIF_HEADER_MSF1 = ByteString.Companion.encodeUtf8("msf1");
    @NotNull
    private static final ByteString HEIF_HEADER_HEVC = ByteString.Companion.encodeUtf8("hevc");
    @NotNull
    private static final ByteString HEIF_HEADER_HEVX = ByteString.Companion.encodeUtf8("hevx");

    private DecodeUtils() {
    }

    @JvmStatic
    public static final boolean isGif(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.rangeEquals(0L, GIF_HEADER_89A) || source.rangeEquals(0L, GIF_HEADER_87A);
    }

    @JvmStatic
    public static final boolean isWebP(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.rangeEquals(0L, WEBP_HEADER_RIFF) && source.rangeEquals(8L, WEBP_HEADER_WEBP);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isAnimatedWebP(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!DecodeUtils.isWebP(source)) return false;
        if (!source.rangeEquals(12L, WEBP_HEADER_VPX8)) return false;
        if (!source.request(17L)) return false;
        byte by = source.getBuffer().getByte(16L);
        int n = 2;
        boolean bl = false;
        if ((byte)(by & n) <= 0) return false;
        return true;
    }

    @JvmStatic
    public static final boolean isHeif(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.rangeEquals(4L, HEIF_HEADER_FTYP);
    }

    @JvmStatic
    public static final boolean isAnimatedHeif(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return DecodeUtils.isHeif(source) && (source.rangeEquals(8L, HEIF_HEADER_MSF1) || source.rangeEquals(8L, HEIF_HEADER_HEVC) || source.rangeEquals(8L, HEIF_HEADER_HEVX));
    }

    @JvmStatic
    public static final int calculateInSampleSize(@Px int srcWidth, @Px int srcHeight, @Px int dstWidth, @Px int dstHeight, @NotNull Scale scale) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        int widthInSampleSize = RangesKt.coerceAtLeast((int)Integer.highestOneBit(srcWidth / dstWidth), (int)1);
        int heightInSampleSize = RangesKt.coerceAtLeast((int)Integer.highestOneBit(srcHeight / dstHeight), (int)1);
        Scale scale2 = scale;
        int n2 = WhenMappings.$EnumSwitchMapping$0[scale2.ordinal()];
        switch (n2) {
            case 1: {
                boolean bl = false;
                n = Math.min(widthInSampleSize, heightInSampleSize);
                break;
            }
            case 2: {
                boolean bl = false;
                n = Math.max(widthInSampleSize, heightInSampleSize);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @JvmStatic
    public static final double computeSizeMultiplier(@Px int srcWidth, @Px int srcHeight, @Px int dstWidth, @Px int dstHeight, @NotNull Scale scale) {
        double d;
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        double widthPercent = (double)dstWidth / (double)srcWidth;
        double heightPercent = (double)dstHeight / (double)srcHeight;
        Scale scale2 = scale;
        int n = WhenMappings.$EnumSwitchMapping$0[scale2.ordinal()];
        switch (n) {
            case 1: {
                boolean bl = false;
                d = Math.max(widthPercent, heightPercent);
                break;
            }
            case 2: {
                boolean bl = false;
                d = Math.min(widthPercent, heightPercent);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    @JvmStatic
    public static final float computeSizeMultiplier(@Px float srcWidth, @Px float srcHeight, @Px float dstWidth, @Px float dstHeight, @NotNull Scale scale) {
        float f;
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        float widthPercent = dstWidth / srcWidth;
        float heightPercent = dstHeight / srcHeight;
        Scale scale2 = scale;
        int n = WhenMappings.$EnumSwitchMapping$0[scale2.ordinal()];
        switch (n) {
            case 1: {
                boolean bl = false;
                f = Math.max(widthPercent, heightPercent);
                break;
            }
            case 2: {
                boolean bl = false;
                f = Math.min(widthPercent, heightPercent);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    @JvmStatic
    public static final double computeSizeMultiplier(@Px double srcWidth, @Px double srcHeight, @Px double dstWidth, @Px double dstHeight, @NotNull Scale scale) {
        double d;
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        double widthPercent = dstWidth / srcWidth;
        double heightPercent = dstHeight / srcHeight;
        Scale scale2 = scale;
        int n = WhenMappings.$EnumSwitchMapping$0[scale2.ordinal()];
        switch (n) {
            case 1: {
                boolean bl = false;
                d = Math.max(widthPercent, heightPercent);
                break;
            }
            case 2: {
                boolean bl = false;
                d = Math.min(widthPercent, heightPercent);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    @JvmStatic
    @NotNull
    public static final PixelSize computePixelSize(int srcWidth, int srcHeight, @NotNull Size dstSize, @NotNull Scale scale) {
        PixelSize pixelSize;
        Intrinsics.checkNotNullParameter((Object)dstSize, (String)"dstSize");
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        Size size2 = dstSize;
        if (size2 instanceof OriginalSize) {
            pixelSize = new PixelSize(srcWidth, srcHeight);
        } else if (size2 instanceof PixelSize) {
            double multiplier = DecodeUtils.computeSizeMultiplier(srcWidth, srcHeight, ((PixelSize)dstSize).getWidth(), ((PixelSize)dstSize).getHeight(), scale);
            pixelSize = new PixelSize(MathKt.roundToInt((double)(multiplier * (double)srcWidth)), MathKt.roundToInt((double)(multiplier * (double)srcHeight)));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pixelSize;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Scale.values().length];
            nArray[Scale.FILL.ordinal()] = 1;
            nArray[Scale.FIT.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

