/*
 * Decompiled with CFR 0.152.
 */
package coil.map;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import coil.map.Mapper;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcoil/map/ResourceUriMapper;", "Lcoil/map/Mapper;", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "handles", "", "data", "map", "coil-base_release"})
public final class ResourceUriMapper
implements Mapper<Uri, Uri> {
    @NotNull
    private final Context context;

    public ResourceUriMapper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handles(@NotNull Uri data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!Intrinsics.areEqual((Object)data.getScheme(), (Object)"android.resource")) return false;
        Object object = data.getAuthority();
        boolean bl = false;
        boolean bl2 = false;
        if (object == null) return false;
        if (StringsKt.isBlank((CharSequence)object)) {
            return false;
        }
        boolean bl3 = false;
        if (bl3) return false;
        object = data.getPathSegments();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"data.pathSegments");
        object = (Collection)object;
        bl = false;
        if (object.size() != 2) return false;
        return true;
    }

    @Override
    @NotNull
    public Uri map(@NotNull Uri data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data.getAuthority();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String packageName = string2;
        Object object = this.context.getPackageManager().getResourcesForApplication(packageName);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.packageManager.g\u2026rApplication(packageName)");
        Resources resources = object;
        object = data.getPathSegments();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pathSegments");
        Object object2 = object;
        boolean bl2 = false;
        String type = (String)object2.get(0);
        Object object3 = object;
        boolean bl3 = false;
        String name = (String)object3.get(1);
        int id = resources.getIdentifier(name, type, packageName);
        bl3 = id != 0;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!bl3) {
            boolean bl6 = false;
            String string3 = Intrinsics.stringPlus((String)"Invalid android.resource URI: ", (Object)data);
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        String $this$toUri$iv = "android.resource://" + packageName + '/' + id;
        boolean $i$f$toUri = false;
        Uri uri = Uri.parse((String)$this$toUri$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(this)");
        return uri;
    }
}

