/*
 * Decompiled with CFR 0.152.
 */
package coil.disk;

import androidx.annotation.VisibleForTesting;
import coil.disk.DiskLruCache;
import coil.disk.FaultHidingSink;
import coil.util.-FileSystems;
import java.io.Closeable;
import java.io.EOFException;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.ForwardingFileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000u\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0014*\u0001\u0014\b\u0000\u0018\u0000 C2\u00060\u0001j\u0002`\u00022\u00020\u0003:\u0004CDEFB5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0016J\u001c\u0010)\u001a\u00020'2\n\u0010*\u001a\u00060+R\u00020\u00002\u0006\u0010,\u001a\u00020\u0013H\u0002J\b\u0010-\u001a\u00020'H\u0002J\u0014\u0010.\u001a\b\u0018\u00010+R\u00020\u00002\u0006\u0010/\u001a\u00020\u001fJ\u0006\u00100\u001a\u00020'J\b\u00101\u001a\u00020'H\u0016J\u0017\u00102\u001a\b\u0018\u000103R\u00020\u00002\u0006\u0010/\u001a\u00020\u001fH\u0086\u0002J\u0006\u00104\u001a\u00020'J\b\u00105\u001a\u00020\u0013H\u0002J\b\u00106\u001a\u00020'H\u0002J\b\u00107\u001a\u00020\u001cH\u0002J\b\u00108\u001a\u00020'H\u0002J\b\u00109\u001a\u00020'H\u0002J\u0010\u0010:\u001a\u00020'2\u0006\u0010;\u001a\u00020\u001fH\u0002J\u000e\u0010<\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u001fJ\u0014\u0010=\u001a\u00020\u00132\n\u0010>\u001a\u00060 R\u00020\u0000H\u0002J\b\u0010?\u001a\u00020\u0013H\u0002J\u0006\u0010%\u001a\u00020\u000bJ\b\u0010@\u001a\u00020'H\u0002J\u0010\u0010A\u001a\u00020'2\u0006\u0010/\u001a\u00020\u001fH\u0002J\b\u0010B\u001a\u00020'H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u001d\u001a&\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u00060 R\u00020\u00000\u001ej\u0012\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u00060 R\u00020\u0000`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcoil/disk/DiskLruCache;", "Ljava/io/Closeable;", "Lokio/Closeable;", "Ljava/io/Flushable;", "fileSystem", "Lokio/FileSystem;", "directory", "Lokio/Path;", "cleanupDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "maxSize", "", "appVersion", "", "valueCount", "(Lokio/FileSystem;Lokio/Path;Lkotlinx/coroutines/CoroutineDispatcher;JII)V", "cleanupScope", "Lkotlinx/coroutines/CoroutineScope;", "closed", "", "coil/disk/DiskLruCache$fileSystem$1", "Lcoil/disk/DiskLruCache$fileSystem$1;", "hasJournalErrors", "initialized", "journalFile", "journalFileBackup", "journalFileTmp", "journalWriter", "Lokio/BufferedSink;", "lruEntries", "Ljava/util/LinkedHashMap;", "", "Lcoil/disk/DiskLruCache$Entry;", "Lkotlin/collections/LinkedHashMap;", "mostRecentRebuildFailed", "mostRecentTrimFailed", "operationsSinceRewrite", "size", "checkNotClosed", "", "close", "completeEdit", "editor", "Lcoil/disk/DiskLruCache$Editor;", "success", "delete", "edit", "key", "evictAll", "flush", "get", "Lcoil/disk/DiskLruCache$Snapshot;", "initialize", "journalRewriteRequired", "launchCleanup", "newJournalWriter", "processJournal", "readJournal", "readJournalLine", "line", "remove", "removeEntry", "entry", "removeOldestEntry", "trimToSize", "validateKey", "writeJournal", "Companion", "Editor", "Entry", "Snapshot", "coil-base_release"})
public final class DiskLruCache
implements Closeable,
Flushable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path directory;
    private final long maxSize;
    private final int appVersion;
    private final int valueCount;
    @NotNull
    private final Path journalFile;
    @NotNull
    private final Path journalFileTmp;
    @NotNull
    private final Path journalFileBackup;
    @NotNull
    private final LinkedHashMap<String, Entry> lruEntries;
    @NotNull
    private final CoroutineScope cleanupScope;
    private long size;
    private int operationsSinceRewrite;
    @Nullable
    private BufferedSink journalWriter;
    private boolean hasJournalErrors;
    private boolean initialized;
    private boolean closed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    @NotNull
    private final fileSystem.1 fileSystem;
    @NotNull
    public static final String JOURNAL_FILE = "journal";
    @NotNull
    public static final String JOURNAL_FILE_TMP = "journal.tmp";
    @NotNull
    public static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    @NotNull
    public static final String MAGIC = "libcore.io.DiskLruCache";
    @NotNull
    public static final String VERSION = "1";
    @NotNull
    private static final String CLEAN = "CLEAN";
    @NotNull
    private static final String DIRTY = "DIRTY";
    @NotNull
    private static final String REMOVE = "REMOVE";
    @NotNull
    private static final String READ = "READ";
    @NotNull
    private static final Regex LEGAL_KEY_PATTERN = new Regex("[a-z0-9_-]{1,120}");

    public DiskLruCache(@NotNull FileSystem fileSystem2, @NotNull Path directory, @NotNull CoroutineDispatcher cleanupDispatcher, long maxSize, int appVersion, int valueCount) {
        this.directory = directory;
        this.maxSize = maxSize;
        this.appVersion = appVersion;
        this.valueCount = valueCount;
        if (!(this.maxSize > 0L)) {
            boolean $i$a$-require-DiskLruCache$32 = false;
            String $i$a$-require-DiskLruCache$32 = "maxSize <= 0";
            throw new IllegalArgumentException($i$a$-require-DiskLruCache$32.toString());
        }
        if (!(this.valueCount > 0)) {
            boolean bl = false;
            String string = "valueCount <= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.journalFile = this.directory.resolve(JOURNAL_FILE);
        this.journalFileTmp = this.directory.resolve(JOURNAL_FILE_TMP);
        this.journalFileBackup = this.directory.resolve(JOURNAL_FILE_BACKUP);
        this.lruEntries = new LinkedHashMap(0, 0.75f, true);
        this.cleanupScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)cleanupDispatcher.limitedParallelism(1)));
        this.fileSystem = new ForwardingFileSystem(fileSystem2){
            final /* synthetic */ FileSystem $fileSystem;
            {
                this.$fileSystem = $fileSystem;
                super($fileSystem);
            }

            @NotNull
            public Sink sink(@NotNull Path file, boolean mustCreate) {
                Path path = file.parent();
                if (path != null) {
                    Path p0 = path;
                    boolean bl = false;
                    this.createDirectories(p0);
                }
                return super.sink(file, mustCreate);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.fileSystem.delete(this.journalFileTmp);
        if (this.fileSystem.exists(this.journalFileBackup)) {
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.atomicMove(this.journalFileBackup, this.journalFile);
            }
        }
        if (this.fileSystem.exists(this.journalFile)) {
            try {
                this.readJournal();
                this.processJournal();
                this.initialized = true;
                return;
            }
            catch (IOException iOException) {
                try {
                    this.delete();
                }
                finally {
                    this.closed = false;
                }
            }
        }
        this.writeJournal();
        this.initialized = true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readJournal() {
        void this_$iv;
        FileSystem fileSystem2 = (FileSystem)this.fileSystem;
        Path file$iv = this.journalFile;
        boolean bl = false;
        Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
        boolean $i$f$use = false;
        Unit result$iv$iv = null;
        Throwable thrown$iv$iv = null;
        try {
            BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
            boolean bl2 = false;
            BufferedSource $this$readJournal_u24lambda_u2d2 = it$iv;
            boolean bl3 = false;
            String magic = $this$readJournal_u24lambda_u2d2.readUtf8LineStrict();
            String version = $this$readJournal_u24lambda_u2d2.readUtf8LineStrict();
            String appVersionString = $this$readJournal_u24lambda_u2d2.readUtf8LineStrict();
            String valueCountString = $this$readJournal_u24lambda_u2d2.readUtf8LineStrict();
            String blank = $this$readJournal_u24lambda_u2d2.readUtf8LineStrict();
            if (!(Intrinsics.areEqual((Object)MAGIC, (Object)magic) && Intrinsics.areEqual((Object)VERSION, (Object)version) && Intrinsics.areEqual((Object)String.valueOf(this.appVersion), (Object)appVersionString) && Intrinsics.areEqual((Object)String.valueOf(this.valueCount), (Object)valueCountString) && !(((CharSequence)blank).length() > 0))) {
                throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + ']');
            }
            int lineCount = 0;
            try {
                while (true) {
                    this.readJournalLine($this$readJournal_u24lambda_u2d2.readUtf8LineStrict());
                    int n = lineCount;
                    lineCount = n + 1;
                }
            }
            catch (EOFException _) {
                this.operationsSinceRewrite = lineCount - this.lruEntries.size();
                if (!$this$readJournal_u24lambda_u2d2.exhausted()) {
                    this.writeJournal();
                } else {
                    this.journalWriter = this.newJournalWriter();
                }
                result$iv$iv = Unit.INSTANCE;
            }
        }
        catch (Throwable t$iv$iv) {
            thrown$iv$iv = t$iv$iv;
        }
        try {
            Closeable closeable = $this$use$iv$iv;
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable t$iv$iv) {
            if (thrown$iv$iv == null) {
                thrown$iv$iv = t$iv$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
        }
        if (thrown$iv$iv != null) {
            throw thrown$iv$iv;
        }
        Intrinsics.checkNotNull(result$iv$iv);
    }

    private final BufferedSink newJournalWriter() {
        Sink fileSink = this.fileSystem.appendingSink(this.journalFile);
        FaultHidingSink faultHidingSink2 = new FaultHidingSink(fileSink, (Function1<? super IOException, Unit>)((Function1)new Function1<IOException, Unit>(this){
            final /* synthetic */ DiskLruCache this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull IOException it) {
                DiskLruCache.access$setHasJournalErrors$p(this.this$0, true);
            }
        }));
        return Okio.buffer((Sink)((Sink)faultHidingSink2));
    }

    private final void readJournalLine(String line) {
        Object object;
        String string;
        int firstSpace = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)0, (boolean)false, (int)6, null);
        if (firstSpace == -1) {
            throw new IOException(Intrinsics.stringPlus((String)"unexpected journal line: ", (Object)line));
        }
        int keyBegin = firstSpace + 1;
        int secondSpace = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)keyBegin, (boolean)false, (int)4, null);
        String key = null;
        if (secondSpace == -1) {
            string = line.substring(keyBegin);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            key = string;
            if (firstSpace == REMOVE.length() && StringsKt.startsWith$default((String)line, (String)REMOVE, (boolean)false, (int)2, null)) {
                this.lruEntries.remove(key);
                return;
            }
        } else {
            string = line.substring(keyBegin, secondSpace);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            key = string;
        }
        Map $this$getOrPut$iv = this.lruEntries;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            Entry answer$iv = new Entry(key);
            $this$getOrPut$iv.put(key, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Entry entry = (Entry)object;
        if (secondSpace != -1 && firstSpace == CLEAN.length() && StringsKt.startsWith$default((String)line, (String)CLEAN, (boolean)false, (int)2, null)) {
            Object object2 = line;
            int n = secondSpace + 1;
            String string2 = ((String)object2).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            object2 = new char[1];
            object2[0] = 32;
            List parts = StringsKt.split$default((CharSequence)string2, (char[])object2, (boolean)false, (int)0, (int)6, null);
            entry.setReadable(true);
            entry.setCurrentEditor(null);
            entry.setLengths(parts);
        } else if (secondSpace == -1 && firstSpace == DIRTY.length() && StringsKt.startsWith$default((String)line, (String)DIRTY, (boolean)false, (int)2, null)) {
            entry.setCurrentEditor(new Editor(entry));
        } else if (secondSpace != -1 || firstSpace != READ.length() || !StringsKt.startsWith$default((String)line, (String)READ, (boolean)false, (int)2, null)) {
            throw new IOException(Intrinsics.stringPlus((String)"unexpected journal line: ", (Object)line));
        }
    }

    private final void processJournal() {
        long size2 = 0L;
        Iterator<Entry> iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int i;
            int n;
            int n2;
            Entry entry = iterator.next();
            if (entry.getCurrentEditor() == null) {
                n2 = 0;
                n = this.valueCount;
                while (n2 < n) {
                    i = n2++;
                    size2 += entry.getLengths()[i];
                }
                continue;
            }
            entry.setCurrentEditor(null);
            n2 = 0;
            n = this.valueCount;
            while (n2 < n) {
                i = n2++;
                this.fileSystem.delete(entry.getCleanFiles().get(i));
                this.fileSystem.delete(entry.getDirtyFiles().get(i));
            }
            iterator.remove();
        }
        this.size = size2;
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void writeJournal() {
        void this_$iv;
        BufferedSink bufferedSink = this.journalWriter;
        if (bufferedSink != null) {
            bufferedSink.close();
        }
        FileSystem fileSystem2 = (FileSystem)this.fileSystem;
        Path file$iv = this.journalFileTmp;
        boolean mustCreate$iv = false;
        boolean bl = false;
        Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)this_$iv.sink(file$iv, mustCreate$iv));
        boolean $i$f$use = false;
        Unit result$iv$iv = null;
        Throwable thrown$iv$iv = null;
        try {
            BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
            boolean bl2 = false;
            BufferedSink $this$writeJournal_u24lambda_u2d4 = it$iv;
            boolean bl3 = false;
            $this$writeJournal_u24lambda_u2d4.writeUtf8(MAGIC).writeByte(10);
            $this$writeJournal_u24lambda_u2d4.writeUtf8(VERSION).writeByte(10);
            $this$writeJournal_u24lambda_u2d4.writeDecimalLong((long)this.appVersion).writeByte(10);
            $this$writeJournal_u24lambda_u2d4.writeDecimalLong((long)this.valueCount).writeByte(10);
            $this$writeJournal_u24lambda_u2d4.writeByte(10);
            for (Entry entry : this.lruEntries.values()) {
                if (entry.getCurrentEditor() != null) {
                    $this$writeJournal_u24lambda_u2d4.writeUtf8(DIRTY);
                    $this$writeJournal_u24lambda_u2d4.writeByte(32);
                    $this$writeJournal_u24lambda_u2d4.writeUtf8(entry.getKey());
                    $this$writeJournal_u24lambda_u2d4.writeByte(10);
                    continue;
                }
                $this$writeJournal_u24lambda_u2d4.writeUtf8(CLEAN);
                $this$writeJournal_u24lambda_u2d4.writeByte(32);
                $this$writeJournal_u24lambda_u2d4.writeUtf8(entry.getKey());
                entry.writeLengths($this$writeJournal_u24lambda_u2d4);
                $this$writeJournal_u24lambda_u2d4.writeByte(10);
            }
            result$iv$iv = Unit.INSTANCE;
        }
        catch (Throwable t$iv$iv) {
            thrown$iv$iv = t$iv$iv;
        }
        try {
            Closeable closeable = $this$use$iv$iv;
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable t$iv$iv) {
            if (thrown$iv$iv == null) {
                thrown$iv$iv = t$iv$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
        }
        if (thrown$iv$iv != null) {
            throw thrown$iv$iv;
        }
        Intrinsics.checkNotNull(result$iv$iv);
        if (this.fileSystem.exists(this.journalFile)) {
            this.fileSystem.atomicMove(this.journalFile, this.journalFileBackup);
            this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
            this.fileSystem.delete(this.journalFileBackup);
        } else {
            this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
        }
        this.journalWriter = this.newJournalWriter();
        this.operationsSinceRewrite = 0;
        this.hasJournalErrors = false;
        this.mostRecentRebuildFailed = false;
    }

    @Nullable
    public final synchronized Snapshot get(@NotNull String key) {
        BufferedSink bufferedSink;
        this.checkNotClosed();
        this.validateKey(key);
        this.initialize();
        Entry entry = this.lruEntries.get(key);
        Snapshot snapshot = entry == null ? null : entry.snapshot();
        if (snapshot == null) {
            return null;
        }
        Snapshot snapshot2 = snapshot;
        int n = this.operationsSinceRewrite;
        this.operationsSinceRewrite = n + 1;
        BufferedSink bufferedSink2 = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink2);
        BufferedSink $this$get_u24lambda_u2d5 = bufferedSink = bufferedSink2;
        boolean bl = false;
        $this$get_u24lambda_u2d5.writeUtf8(READ);
        $this$get_u24lambda_u2d5.writeByte(32);
        $this$get_u24lambda_u2d5.writeUtf8(key);
        $this$get_u24lambda_u2d5.writeByte(10);
        if (this.journalRewriteRequired()) {
            this.launchCleanup();
        }
        return snapshot2;
    }

    @Nullable
    public final synchronized Editor edit(@NotNull String key) {
        BufferedSink bufferedSink;
        Entry entry;
        this.checkNotClosed();
        this.validateKey(key);
        this.initialize();
        Entry entry2 = entry = this.lruEntries.get(key);
        if ((entry2 == null ? null : entry2.getCurrentEditor()) != null) {
            return null;
        }
        if (entry != null && entry.getLockingSnapshotCount() != 0) {
            return null;
        }
        if (this.mostRecentTrimFailed || this.mostRecentRebuildFailed) {
            this.launchCleanup();
            return null;
        }
        BufferedSink bufferedSink2 = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink2);
        BufferedSink $this$edit_u24lambda_u2d6 = bufferedSink = bufferedSink2;
        boolean bl = false;
        $this$edit_u24lambda_u2d6.writeUtf8(DIRTY);
        $this$edit_u24lambda_u2d6.writeByte(32);
        $this$edit_u24lambda_u2d6.writeUtf8(key);
        $this$edit_u24lambda_u2d6.writeByte(10);
        $this$edit_u24lambda_u2d6.flush();
        if (this.hasJournalErrors) {
            return null;
        }
        if (entry == null) {
            entry = new Entry(key);
            ((Map)this.lruEntries).put(key, entry);
        }
        Editor editor = new Editor(entry);
        entry.setCurrentEditor(editor);
        return editor;
    }

    public final synchronized long size() {
        this.initialize();
        return this.size;
    }

    private final synchronized void completeEdit(Editor editor, boolean success) {
        BufferedSink bufferedSink;
        int i;
        int n;
        int n2;
        Entry entry = editor.getEntry();
        if (!Intrinsics.areEqual((Object)entry.getCurrentEditor(), (Object)editor)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (success && !entry.getZombie()) {
            n2 = 0;
            n = this.valueCount;
            while (n2 < n) {
                i = n2++;
                if (!editor.getWritten()[i] || this.fileSystem.exists(entry.getDirtyFiles().get(i))) continue;
                editor.abort();
                return;
            }
            n2 = 0;
            n = this.valueCount;
            while (n2 < n) {
                long newLength;
                i = n2++;
                Path dirty = entry.getDirtyFiles().get(i);
                Path clean = entry.getCleanFiles().get(i);
                if (this.fileSystem.exists(dirty)) {
                    this.fileSystem.atomicMove(dirty, clean);
                } else {
                    -FileSystems.createFile((FileSystem)this.fileSystem, entry.getCleanFiles().get(i));
                }
                long oldLength = entry.getLengths()[i];
                Long l = this.fileSystem.metadata(clean).getSize();
                entry.getLengths()[i] = newLength = l == null ? 0L : l;
                this.size = this.size - oldLength + newLength;
            }
        } else {
            n2 = 0;
            n = this.valueCount;
            while (n2 < n) {
                i = n2++;
                this.fileSystem.delete(entry.getDirtyFiles().get(i));
            }
        }
        entry.setCurrentEditor(null);
        if (entry.getZombie()) {
            this.removeEntry(entry);
            return;
        }
        n2 = this.operationsSinceRewrite;
        this.operationsSinceRewrite = n2 + 1;
        BufferedSink bufferedSink2 = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink2);
        BufferedSink $this$completeEdit_u24lambda_u2d7 = bufferedSink = bufferedSink2;
        boolean bl = false;
        if (success || entry.getReadable()) {
            entry.setReadable(true);
            $this$completeEdit_u24lambda_u2d7.writeUtf8(CLEAN);
            $this$completeEdit_u24lambda_u2d7.writeByte(32);
            $this$completeEdit_u24lambda_u2d7.writeUtf8(entry.getKey());
            entry.writeLengths($this$completeEdit_u24lambda_u2d7);
            $this$completeEdit_u24lambda_u2d7.writeByte(10);
        } else {
            this.lruEntries.remove(entry.getKey());
            $this$completeEdit_u24lambda_u2d7.writeUtf8(REMOVE);
            $this$completeEdit_u24lambda_u2d7.writeByte(32);
            $this$completeEdit_u24lambda_u2d7.writeUtf8(entry.getKey());
            $this$completeEdit_u24lambda_u2d7.writeByte(10);
        }
        $this$completeEdit_u24lambda_u2d7.flush();
        if (this.size > this.maxSize || this.journalRewriteRequired()) {
            this.launchCleanup();
        }
    }

    private final boolean journalRewriteRequired() {
        return this.operationsSinceRewrite >= 2000;
    }

    public final synchronized boolean remove(@NotNull String key) {
        this.checkNotClosed();
        this.validateKey(key);
        this.initialize();
        Entry entry = this.lruEntries.get(key);
        if (entry == null) {
            return false;
        }
        Entry entry2 = entry;
        boolean removed = this.removeEntry(entry2);
        if (removed && this.size <= this.maxSize) {
            this.mostRecentTrimFailed = false;
        }
        return removed;
    }

    private final boolean removeEntry(Entry entry) {
        if (entry.getLockingSnapshotCount() > 0) {
            BufferedSink bufferedSink = this.journalWriter;
            if (bufferedSink != null) {
                BufferedSink bufferedSink2;
                BufferedSink $this$removeEntry_u24lambda_u2d8 = bufferedSink2 = bufferedSink;
                boolean bl = false;
                $this$removeEntry_u24lambda_u2d8.writeUtf8(DIRTY);
                $this$removeEntry_u24lambda_u2d8.writeByte(32);
                $this$removeEntry_u24lambda_u2d8.writeUtf8(entry.getKey());
                $this$removeEntry_u24lambda_u2d8.writeByte(10);
                $this$removeEntry_u24lambda_u2d8.flush();
            }
        }
        if (entry.getLockingSnapshotCount() > 0 || entry.getCurrentEditor() != null) {
            entry.setZombie(true);
            return true;
        }
        Editor editor = entry.getCurrentEditor();
        if (editor != null) {
            editor.detach();
        }
        int n = 0;
        int n2 = this.valueCount;
        while (n < n2) {
            int i = n++;
            this.fileSystem.delete(entry.getCleanFiles().get(i));
            this.size -= entry.getLengths()[i];
            entry.getLengths()[i] = 0L;
        }
        n = this.operationsSinceRewrite;
        this.operationsSinceRewrite = n + 1;
        BufferedSink bufferedSink = this.journalWriter;
        if (bufferedSink != null) {
            BufferedSink bufferedSink3;
            BufferedSink $this$removeEntry_u24lambda_u2d9 = bufferedSink3 = bufferedSink;
            boolean bl = false;
            $this$removeEntry_u24lambda_u2d9.writeUtf8(REMOVE);
            $this$removeEntry_u24lambda_u2d9.writeByte(32);
            $this$removeEntry_u24lambda_u2d9.writeUtf8(entry.getKey());
            $this$removeEntry_u24lambda_u2d9.writeByte(10);
        }
        this.lruEntries.remove(entry.getKey());
        if (this.journalRewriteRequired()) {
            this.launchCleanup();
        }
        return true;
    }

    private final void checkNotClosed() {
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "cache is closed";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public synchronized void close() {
        if (!this.initialized || this.closed) {
            this.closed = true;
            return;
        }
        Collection<Entry> $this$toTypedArray$iv = this.lruEntries.values();
        boolean $i$f$toTypedArray = false;
        Collection<Entry> thisCollection$iv = $this$toTypedArray$iv;
        Entry[] entryArray = thisCollection$iv.toArray(new Entry[0]);
        if (entryArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        for (Entry entry : entryArray) {
            if (entry.getCurrentEditor() == null) continue;
            Editor editor = entry.getCurrentEditor();
            if (editor == null) continue;
            editor.detach();
        }
        this.trimToSize();
        CoroutineScopeKt.cancel$default((CoroutineScope)this.cleanupScope, null, (int)1, null);
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.close();
        this.journalWriter = null;
        this.closed = true;
    }

    @Override
    public synchronized void flush() {
        if (!this.initialized) {
            return;
        }
        this.checkNotClosed();
        this.trimToSize();
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.flush();
    }

    private final void trimToSize() {
        while (this.size > this.maxSize) {
            if (this.removeOldestEntry()) continue;
            return;
        }
        this.mostRecentTrimFailed = false;
    }

    private final boolean removeOldestEntry() {
        for (Entry toEvict : this.lruEntries.values()) {
            if (toEvict.getZombie()) continue;
            this.removeEntry(toEvict);
            return true;
        }
        return false;
    }

    private final void delete() {
        this.close();
        -FileSystems.deleteContents((FileSystem)this.fileSystem, this.directory);
    }

    public final synchronized void evictAll() {
        this.initialize();
        Collection<Entry> $this$toTypedArray$iv = this.lruEntries.values();
        boolean $i$f$toTypedArray = false;
        Collection<Entry> thisCollection$iv = $this$toTypedArray$iv;
        Entry[] entryArray = thisCollection$iv.toArray(new Entry[0]);
        if (entryArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        for (Entry entry : entryArray) {
            this.removeEntry(entry);
        }
        this.mostRecentTrimFailed = false;
    }

    private final void launchCleanup() {
        BuildersKt.launch$default((CoroutineScope)this.cleanupScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DiskLruCache this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DiskLruCache diskLruCache = this.this$0;
                        DiskLruCache diskLruCache2 = this.this$0;
                        synchronized (diskLruCache) {
                            boolean bl = false;
                            if (!DiskLruCache.access$getInitialized$p(diskLruCache2)) return Unit.INSTANCE;
                            if (DiskLruCache.access$getClosed$p(diskLruCache2)) {
                                return Unit.INSTANCE;
                            }
                            try {
                                DiskLruCache.access$trimToSize(diskLruCache2);
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentTrimFailed$p(diskLruCache2, true);
                            }
                            try {
                                if (DiskLruCache.access$journalRewriteRequired(diskLruCache2)) {
                                    DiskLruCache.access$writeJournal(diskLruCache2);
                                }
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentRebuildFailed$p(diskLruCache2, true);
                                DiskLruCache.access$setJournalWriter$p(diskLruCache2, Okio.buffer((Sink)Okio.blackhole()));
                            }
                            Unit unit = Unit.INSTANCE;
                            return Unit.INSTANCE;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void validateKey(String key) {
        if (!LEGAL_KEY_PATTERN.matches((CharSequence)key)) {
            boolean bl = false;
            String string = "keys must match regex [a-z0-9_-]{1,120}: \"" + key + '\"';
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final /* synthetic */ void access$setHasJournalErrors$p(DiskLruCache $this, boolean bl) {
        $this.hasJournalErrors = bl;
    }

    public static final /* synthetic */ boolean access$getInitialized$p(DiskLruCache $this) {
        return $this.initialized;
    }

    public static final /* synthetic */ boolean access$getClosed$p(DiskLruCache $this) {
        return $this.closed;
    }

    public static final /* synthetic */ void access$trimToSize(DiskLruCache $this) {
        $this.trimToSize();
    }

    public static final /* synthetic */ void access$setMostRecentTrimFailed$p(DiskLruCache $this, boolean bl) {
        $this.mostRecentTrimFailed = bl;
    }

    public static final /* synthetic */ boolean access$journalRewriteRequired(DiskLruCache $this) {
        return $this.journalRewriteRequired();
    }

    public static final /* synthetic */ void access$writeJournal(DiskLruCache $this) {
        $this.writeJournal();
    }

    public static final /* synthetic */ void access$setMostRecentRebuildFailed$p(DiskLruCache $this, boolean bl) {
        $this.mostRecentRebuildFailed = bl;
    }

    public static final /* synthetic */ void access$setJournalWriter$p(DiskLruCache $this, BufferedSink bufferedSink) {
        $this.journalWriter = bufferedSink;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\b\u0018\u00010\u000eR\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcoil/disk/DiskLruCache$Snapshot;", "Ljava/io/Closeable;", "Lokio/Closeable;", "entry", "Lcoil/disk/DiskLruCache$Entry;", "Lcoil/disk/DiskLruCache;", "(Lcoil/disk/DiskLruCache;Lcoil/disk/DiskLruCache$Entry;)V", "closed", "", "getEntry", "()Lcoil/disk/DiskLruCache$Entry;", "close", "", "closeAndEdit", "Lcoil/disk/DiskLruCache$Editor;", "file", "Lokio/Path;", "index", "", "coil-base_release"})
    public final class Snapshot
    implements Closeable {
        @NotNull
        private final Entry entry;
        private boolean closed;

        public Snapshot(Entry entry) {
            this.entry = entry;
        }

        @NotNull
        public final Entry getEntry() {
            return this.entry;
        }

        @NotNull
        public final Path file(int index) {
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "snapshot is closed";
                throw new IllegalStateException(string.toString());
            }
            return this.entry.getCleanFiles().get(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                DiskLruCache diskLruCache = DiskLruCache.this;
                DiskLruCache diskLruCache2 = DiskLruCache.this;
                synchronized (diskLruCache) {
                    boolean bl = false;
                    Entry entry = this.getEntry();
                    int n = entry.getLockingSnapshotCount();
                    entry.setLockingSnapshotCount(n + -1);
                    if (this.getEntry().getLockingSnapshotCount() == 0 && this.getEntry().getZombie()) {
                        diskLruCache2.removeEntry(this.getEntry());
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Editor closeAndEdit() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            synchronized (diskLruCache) {
                boolean bl = false;
                this.close();
                Editor editor = diskLruCache2.edit(this.getEntry().getKey());
                return editor;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\f\u0010\u0011\u001a\b\u0018\u00010\u0012R\u00020\u0004J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcoil/disk/DiskLruCache$Editor;", "", "entry", "Lcoil/disk/DiskLruCache$Entry;", "Lcoil/disk/DiskLruCache;", "(Lcoil/disk/DiskLruCache;Lcoil/disk/DiskLruCache$Entry;)V", "closed", "", "getEntry", "()Lcoil/disk/DiskLruCache$Entry;", "written", "", "getWritten", "()[Z", "abort", "", "commit", "commitAndGet", "Lcoil/disk/DiskLruCache$Snapshot;", "complete", "success", "detach", "file", "Lokio/Path;", "index", "", "coil-base_release"})
    public final class Editor {
        @NotNull
        private final Entry entry;
        private boolean closed;
        @NotNull
        private final boolean[] written;

        public Editor(Entry entry) {
            this.entry = entry;
            this.written = new boolean[DiskLruCache.this.valueCount];
        }

        @NotNull
        public final Entry getEntry() {
            return this.entry;
        }

        @NotNull
        public final boolean[] getWritten() {
            return this.written;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Path file(int index) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            synchronized (diskLruCache) {
                boolean bl = false;
                if (!(!this.closed)) {
                    boolean bl2 = false;
                    String string = "editor is closed";
                    throw new IllegalStateException(string.toString());
                }
                this.getWritten()[index] = true;
                Path path = this.getEntry().getDirtyFiles().get(index);
                fileSystem.1 var6_8 = diskLruCache2.fileSystem;
                Path p0 = path;
                boolean bl3 = false;
                -FileSystems.createFile((FileSystem)var6_8, p0);
                Path path2 = path;
                return path2;
            }
        }

        public final void detach() {
            if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                this.entry.setZombie(true);
            }
        }

        public final void commit() {
            this.complete(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Snapshot commitAndGet() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            synchronized (diskLruCache) {
                boolean bl = false;
                this.commit();
                Snapshot snapshot = diskLruCache2.get(this.getEntry().getKey());
                return snapshot;
            }
        }

        public final void abort() {
            this.complete(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void complete(boolean success) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            synchronized (diskLruCache) {
                boolean bl = false;
                if (!(!this.closed)) {
                    boolean bl2 = false;
                    String string = "editor is closed";
                    throw new IllegalStateException(string.toString());
                }
                if (Intrinsics.areEqual((Object)this.getEntry().getCurrentEditor(), (Object)this)) {
                    diskLruCache2.completeEdit(this, success);
                }
                this.closed = true;
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030,J\f\u0010-\u001a\b\u0018\u00010.R\u00020\rJ\u000e\u0010/\u001a\u00020*2\u0006\u00100\u001a\u000201R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0018\u00010\fR\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%\u00a8\u00062"}, d2={"Lcoil/disk/DiskLruCache$Entry;", "", "key", "", "(Lcoil/disk/DiskLruCache;Ljava/lang/String;)V", "cleanFiles", "Ljava/util/ArrayList;", "Lokio/Path;", "Lkotlin/collections/ArrayList;", "getCleanFiles", "()Ljava/util/ArrayList;", "currentEditor", "Lcoil/disk/DiskLruCache$Editor;", "Lcoil/disk/DiskLruCache;", "getCurrentEditor", "()Lcoil/disk/DiskLruCache$Editor;", "setCurrentEditor", "(Lcoil/disk/DiskLruCache$Editor;)V", "dirtyFiles", "getDirtyFiles", "getKey", "()Ljava/lang/String;", "lengths", "", "getLengths", "()[J", "lockingSnapshotCount", "", "getLockingSnapshotCount", "()I", "setLockingSnapshotCount", "(I)V", "readable", "", "getReadable", "()Z", "setReadable", "(Z)V", "zombie", "getZombie", "setZombie", "setLengths", "", "strings", "", "snapshot", "Lcoil/disk/DiskLruCache$Snapshot;", "writeLengths", "writer", "Lokio/BufferedSink;", "coil-base_release"})
    public final class Entry {
        @NotNull
        private final String key;
        @NotNull
        private final long[] lengths;
        @NotNull
        private final ArrayList<Path> cleanFiles;
        @NotNull
        private final ArrayList<Path> dirtyFiles;
        private boolean readable;
        private boolean zombie;
        @Nullable
        private Editor currentEditor;
        private int lockingSnapshotCount;

        public Entry(String key) {
            this.key = key;
            this.lengths = new long[DiskLruCache.this.valueCount];
            this.cleanFiles = new ArrayList(DiskLruCache.this.valueCount);
            this.dirtyFiles = new ArrayList(DiskLruCache.this.valueCount);
            StringBuilder fileBuilder = new StringBuilder(this.key).append('.');
            int truncateTo = fileBuilder.length();
            int n = 0;
            int n2 = DiskLruCache.this.valueCount;
            while (n < n2) {
                int i = n++;
                fileBuilder.append(i);
                ((Collection)this.cleanFiles).add(DiskLruCache.this.directory.resolve(fileBuilder.toString()));
                fileBuilder.append(".tmp");
                ((Collection)this.dirtyFiles).add(DiskLruCache.this.directory.resolve(fileBuilder.toString()));
                fileBuilder.setLength(truncateTo);
            }
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final long[] getLengths() {
            return this.lengths;
        }

        @NotNull
        public final ArrayList<Path> getCleanFiles() {
            return this.cleanFiles;
        }

        @NotNull
        public final ArrayList<Path> getDirtyFiles() {
            return this.dirtyFiles;
        }

        public final boolean getReadable() {
            return this.readable;
        }

        public final void setReadable(boolean bl) {
            this.readable = bl;
        }

        public final boolean getZombie() {
            return this.zombie;
        }

        public final void setZombie(boolean bl) {
            this.zombie = bl;
        }

        @Nullable
        public final Editor getCurrentEditor() {
            return this.currentEditor;
        }

        public final void setCurrentEditor(@Nullable Editor editor) {
            this.currentEditor = editor;
        }

        public final int getLockingSnapshotCount() {
            return this.lockingSnapshotCount;
        }

        public final void setLockingSnapshotCount(int n) {
            this.lockingSnapshotCount = n;
        }

        public final void setLengths(@NotNull List<String> strings) {
            if (strings.size() != DiskLruCache.this.valueCount) {
                throw new IOException(Intrinsics.stringPlus((String)"unexpected journal line: ", strings));
            }
            try {
                int n = 0;
                int n2 = strings.size();
                while (n < n2) {
                    int i = n++;
                    this.lengths[i] = Long.parseLong(strings.get(i));
                }
            }
            catch (NumberFormatException _) {
                throw new IOException(Intrinsics.stringPlus((String)"unexpected journal line: ", strings));
            }
        }

        public final void writeLengths(@NotNull BufferedSink writer) {
            for (long length : this.lengths) {
                writer.writeByte(32).writeDecimalLong(length);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Snapshot snapshot() {
            void $this$forEachIndices$iv;
            if (!this.readable) {
                return null;
            }
            if (this.currentEditor != null || this.zombie) {
                return null;
            }
            List list = this.cleanFiles;
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean $i$f$forEachIndices = false;
            int n = 0;
            int n2 = $this$forEachIndices$iv.size();
            while (n < n2) {
                int i$iv = n++;
                Path file = (Path)$this$forEachIndices$iv.get(i$iv);
                boolean bl = false;
                if (diskLruCache.fileSystem.exists(file)) continue;
                try {
                    diskLruCache.removeEntry(this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            int n3 = this.lockingSnapshotCount;
            this.lockingSnapshotCount = n3 + 1;
            return new Snapshot(this);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0016\u0010\b\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u0016\u0010\n\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0002R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0002\u00a8\u0006\u0014"}, d2={"Lcoil/disk/DiskLruCache$Companion;", "", "()V", "CLEAN", "", "DIRTY", "JOURNAL_FILE", "getJOURNAL_FILE$coil_base_release$annotations", "JOURNAL_FILE_BACKUP", "getJOURNAL_FILE_BACKUP$coil_base_release$annotations", "JOURNAL_FILE_TMP", "getJOURNAL_FILE_TMP$coil_base_release$annotations", "LEGAL_KEY_PATTERN", "Lkotlin/text/Regex;", "MAGIC", "getMAGIC$coil_base_release$annotations", "READ", "REMOVE", "VERSION", "getVERSION$coil_base_release$annotations", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getJOURNAL_FILE$coil_base_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getJOURNAL_FILE_TMP$coil_base_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getJOURNAL_FILE_BACKUP$coil_base_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getMAGIC$coil_base_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getVERSION$coil_base_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

