/*
 * Decompiled with CFR 0.152.
 */
package coil.disk;

import android.os.StatFs;
import androidx.annotation.FloatRange;
import coil.annotation.ExperimentalCoilApi;
import coil.disk.RealDiskCache;
import java.io.Closeable;
import java.io.File;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0003\u001f !J\b\u0010\u0015\u001a\u00020\u0016H'J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH'J\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u00a7\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH'R\u001a\u0010\u0002\u001a\u00020\u00038&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\t8&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0005\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000e8&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0005\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u000e8&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0005\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\""}, d2={"Lcoil/disk/DiskCache;", "", "directory", "Lokio/Path;", "getDirectory$annotations", "()V", "getDirectory", "()Lokio/Path;", "fileSystem", "Lokio/FileSystem;", "getFileSystem$annotations", "getFileSystem", "()Lokio/FileSystem;", "maxSize", "", "getMaxSize$annotations", "getMaxSize", "()J", "size", "getSize$annotations", "getSize", "clear", "", "edit", "Lcoil/disk/DiskCache$Editor;", "key", "", "get", "Lcoil/disk/DiskCache$Snapshot;", "remove", "", "Builder", "Editor", "Snapshot", "coil-base_release"})
public interface DiskCache {
    public long getSize();

    public long getMaxSize();

    @NotNull
    public Path getDirectory();

    @NotNull
    public FileSystem getFileSystem();

    @ExperimentalCoilApi
    @Nullable
    public Snapshot get(@NotNull String var1);

    @ExperimentalCoilApi
    @Nullable
    public Editor edit(@NotNull String var1);

    @ExperimentalCoilApi
    public boolean remove(@NotNull String var1);

    @ExperimentalCoilApi
    public void clear();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00060\u0001j\u0002`\u0002J\b\u0010\t\u001a\u00020\nH&J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\r"}, d2={"Lcoil/disk/DiskCache$Snapshot;", "Ljava/io/Closeable;", "Lokio/Closeable;", "data", "Lokio/Path;", "getData", "()Lokio/Path;", "metadata", "getMetadata", "close", "", "closeAndEdit", "Lcoil/disk/DiskCache$Editor;", "coil-base_release"})
    @ExperimentalCoilApi
    public static interface Snapshot
    extends Closeable {
        @NotNull
        public Path getMetadata();

        @NotNull
        public Path getData();

        @Override
        public void close();

        @Nullable
        public Editor closeAndEdit();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\b\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\tH&J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\r"}, d2={"Lcoil/disk/DiskCache$Editor;", "", "data", "Lokio/Path;", "getData", "()Lokio/Path;", "metadata", "getMetadata", "abort", "", "commit", "commitAndGet", "Lcoil/disk/DiskCache$Snapshot;", "coil-base_release"})
    @ExperimentalCoilApi
    public static interface Editor {
        @NotNull
        public Path getMetadata();

        @NotNull
        public Path getData();

        public void commit();

        @Nullable
        public Snapshot commitAndGet();

        public void abort();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0012J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00002\b\b\u0001\u0010\u0014\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcoil/disk/DiskCache$Builder;", "", "()V", "cleanupDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "directory", "Lokio/Path;", "fileSystem", "Lokio/FileSystem;", "maxSizeBytes", "", "maxSizePercent", "", "maximumMaxSizeBytes", "minimumMaxSizeBytes", "build", "Lcoil/disk/DiskCache;", "dispatcher", "Ljava/io/File;", "size", "percent", "coil-base_release"})
    public static final class Builder {
        @Nullable
        private Path directory;
        @NotNull
        private FileSystem fileSystem = FileSystem.SYSTEM;
        private double maxSizePercent = 0.02;
        private long minimumMaxSizeBytes = 0xA00000L;
        private long maximumMaxSizeBytes = 0xFA00000L;
        private long maxSizeBytes;
        @NotNull
        private CoroutineDispatcher cleanupDispatcher = Dispatchers.getIO();

        @NotNull
        public final Builder directory(@NotNull File directory) {
            return this.directory(Path.Companion.get$default((Path.Companion)Path.Companion, (File)directory, (boolean)false, (int)1, null));
        }

        @NotNull
        public final Builder directory(@NotNull Path directory) {
            Builder builder;
            Builder $this$directory_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$directory_u24lambda_u2d0.directory = directory;
            return builder;
        }

        @NotNull
        public final Builder fileSystem(@NotNull FileSystem fileSystem2) {
            Builder builder;
            Builder $this$fileSystem_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$fileSystem_u24lambda_u2d1.fileSystem = fileSystem2;
            return builder;
        }

        @NotNull
        public final Builder maxSizePercent(@FloatRange(from=0.0, to=1.0) double percent) {
            Builder builder;
            Builder $this$maxSizePercent_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            if (!(0.0 <= percent ? percent <= 1.0 : false)) {
                boolean bl2 = false;
                String string = "size must be in the range [0.0, 1.0].";
                throw new IllegalArgumentException(string.toString());
            }
            $this$maxSizePercent_u24lambda_u2d3.maxSizeBytes = 0L;
            $this$maxSizePercent_u24lambda_u2d3.maxSizePercent = percent;
            return builder;
        }

        @NotNull
        public final Builder minimumMaxSizeBytes(long size2) {
            Builder builder;
            Builder $this$minimumMaxSizeBytes_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            if (!(size2 > 0L)) {
                boolean bl2 = false;
                String string = "size must be > 0.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$minimumMaxSizeBytes_u24lambda_u2d5.minimumMaxSizeBytes = size2;
            return builder;
        }

        @NotNull
        public final Builder maximumMaxSizeBytes(long size2) {
            Builder builder;
            Builder $this$maximumMaxSizeBytes_u24lambda_u2d7 = builder = this;
            boolean bl = false;
            if (!(size2 > 0L)) {
                boolean bl2 = false;
                String string = "size must be > 0.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$maximumMaxSizeBytes_u24lambda_u2d7.maximumMaxSizeBytes = size2;
            return builder;
        }

        @NotNull
        public final Builder maxSizeBytes(long size2) {
            Builder builder;
            Builder $this$maxSizeBytes_u24lambda_u2d9 = builder = this;
            boolean bl = false;
            if (!(size2 > 0L)) {
                boolean bl2 = false;
                String string = "size must be > 0.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$maxSizeBytes_u24lambda_u2d9.maxSizePercent = 0.0;
            $this$maxSizeBytes_u24lambda_u2d9.maxSizeBytes = size2;
            return builder;
        }

        @NotNull
        public final Builder cleanupDispatcher(@NotNull CoroutineDispatcher dispatcher) {
            Builder builder;
            Builder $this$cleanupDispatcher_u24lambda_u2d10 = builder = this;
            boolean bl = false;
            $this$cleanupDispatcher_u24lambda_u2d10.cleanupDispatcher = dispatcher;
            return builder;
        }

        @NotNull
        public final DiskCache build() {
            long l;
            Path path = this.directory;
            if (path == null) {
                boolean bl = false;
                String string = "directory == null";
                throw new IllegalStateException(string.toString());
            }
            Path directory = path;
            if (this.maxSizePercent > 0.0) {
                long l2;
                try {
                    StatFs stats = new StatFs(directory.toFile().getAbsolutePath());
                    double size2 = this.maxSizePercent * (double)stats.getBlockCountLong() * (double)stats.getBlockSizeLong();
                    l2 = RangesKt.coerceIn((long)((long)size2), (long)this.minimumMaxSizeBytes, (long)this.maximumMaxSizeBytes);
                }
                catch (Exception _) {
                    l2 = this.minimumMaxSizeBytes;
                }
                l = l2;
            } else {
                l = this.maxSizeBytes;
            }
            long maxSize = l;
            return new RealDiskCache(maxSize, directory, this.fileSystem, this.cleanupDispatcher);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @ExperimentalCoilApi
        public static /* synthetic */ void getSize$annotations() {
        }

        @ExperimentalCoilApi
        public static /* synthetic */ void getMaxSize$annotations() {
        }

        @ExperimentalCoilApi
        public static /* synthetic */ void getDirectory$annotations() {
        }

        @ExperimentalCoilApi
        public static /* synthetic */ void getFileSystem$annotations() {
        }
    }
}

