/*
 * Decompiled with CFR 0.152.
 */
package coil.util;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Xml;
import androidx.annotation.DrawableRes;
import androidx.annotation.XmlRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0000\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00052\b\b\u0001\u0010\u0003\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0018\u00010\u0007R\u00020\u0005H\u0000\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t*\u0004\u0018\u00010\u0002H\u0000\u001a\u001e\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u001e\u0010\u0010\u001a\u0002H\u0011\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u0012*\u00020\u0002H\u0080\b\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"getDrawableCompat", "Landroid/graphics/drawable/Drawable;", "Landroid/content/Context;", "resId", "", "Landroid/content/res/Resources;", "theme", "Landroid/content/res/Resources$Theme;", "getLifecycle", "Landroidx/lifecycle/Lifecycle;", "getXmlDrawableCompat", "resources", "isPermissionGranted", "", "permission", "", "requireSystemService", "T", "", "(Landroid/content/Context;)Ljava/lang/Object;", "coil-base_release"})
@JvmName(name="-Contexts")
public final class -Contexts {
    @NotNull
    public static final Drawable getDrawableCompat(@NotNull Context $this$getDrawableCompat, @DrawableRes int resId) {
        Drawable drawable = AppCompatResources.getDrawable((Context)$this$getDrawableCompat, (int)resId);
        if (drawable == null) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Invalid resource ID: ", (Object)resId);
            throw new IllegalStateException(string.toString());
        }
        return drawable;
    }

    @NotNull
    public static final Drawable getDrawableCompat(@NotNull Resources $this$getDrawableCompat, @DrawableRes int resId, @Nullable Resources.Theme theme) {
        Drawable drawable = ResourcesCompat.getDrawable((Resources)$this$getDrawableCompat, (int)resId, (Resources.Theme)theme);
        if (drawable == null) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Invalid resource ID: ", (Object)resId);
            throw new IllegalStateException(string.toString());
        }
        return drawable;
    }

    @NotNull
    public static final Drawable getXmlDrawableCompat(@NotNull Context $this$getXmlDrawableCompat, @NotNull Resources resources, @XmlRes int resId) {
        XmlResourceParser parser = resources.getXml(resId);
        int type = parser.next();
        while (type != 2 && type != 1) {
            type = parser.next();
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found.");
        }
        if (Build.VERSION.SDK_INT < 24) {
            String string = parser.getName();
            if (Intrinsics.areEqual((Object)string, (Object)"vector")) {
                return (Drawable)VectorDrawableCompat.createFromXmlInner((Resources)resources, (XmlPullParser)((XmlPullParser)parser), (AttributeSet)Xml.asAttributeSet((XmlPullParser)((XmlPullParser)parser)), (Resources.Theme)$this$getXmlDrawableCompat.getTheme());
            }
            if (Intrinsics.areEqual((Object)string, (Object)"animated-vector")) {
                return (Drawable)AnimatedVectorDrawableCompat.createFromXmlInner((Context)$this$getXmlDrawableCompat, (Resources)resources, (XmlPullParser)((XmlPullParser)parser), (AttributeSet)Xml.asAttributeSet((XmlPullParser)((XmlPullParser)parser)), (Resources.Theme)$this$getXmlDrawableCompat.getTheme());
            }
        }
        return -Contexts.getDrawableCompat(resources, resId, $this$getXmlDrawableCompat.getTheme());
    }

    @Nullable
    public static final Lifecycle getLifecycle(@Nullable Context $this$getLifecycle) {
        Context context = $this$getLifecycle;
        Context context2;
        while (!((context2 = context) instanceof LifecycleOwner)) {
            if (!(context2 instanceof ContextWrapper)) {
                return null;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return ((LifecycleOwner)context).getLifecycle();
    }

    public static final /* synthetic */ <T> T requireSystemService(Context $this$requireSystemService) {
        boolean $i$f$requireSystemService = false;
        Context $this$getSystemService$iv = $this$requireSystemService;
        boolean $i$f$getSystemService = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Object object = ContextCompat.getSystemService((Context)$this$getSystemService$iv, Object.class);
        Intrinsics.checkNotNull((Object)object);
        return (T)object;
    }

    public static final boolean isPermissionGranted(@NotNull Context $this$isPermissionGranted, @NotNull String permission) {
        return ContextCompat.checkSelfPermission((Context)$this$isPermissionGranted, (String)permission) == 0;
    }
}

