/*
 * Decompiled with CFR 0.152.
 */
package coil.transform;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.Shader;
import androidx.annotation.Px;
import coil.decode.DecodeUtils;
import coil.size.-Sizes;
import coil.size.Dimension;
import coil.size.Scale;
import coil.size.Size;
import coil.transform.Transformation;
import coil.util.-Bitmaps;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B-\u0012\b\b\u0003\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0003\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ$\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\u001e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcoil/transform/RoundedCornersTransformation;", "Lcoil/transform/Transformation;", "radius", "", "(F)V", "topLeft", "topRight", "bottomLeft", "bottomRight", "(FFFF)V", "cacheKey", "", "getCacheKey", "()Ljava/lang/String;", "calculateOutputSize", "Lkotlin/Pair;", "", "input", "Landroid/graphics/Bitmap;", "size", "Lcoil/size/Size;", "equals", "", "other", "", "hashCode", "transform", "(Landroid/graphics/Bitmap;Lcoil/size/Size;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "coil-base_release"})
@SourceDebugExtension(value={"SMAP\nRoundedCornersTransformation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoundedCornersTransformation.kt\ncoil/transform/RoundedCornersTransformation\n+ 2 Bitmap.kt\nandroidx/core/graphics/BitmapKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Dimension.kt\ncoil/size/-Dimensions\n*L\n1#1,132:1\n95#2:133\n43#2,2:134\n45#2:137\n1#3:136\n57#4:138\n57#4:139\n*S KotlinDebug\n*F\n+ 1 RoundedCornersTransformation.kt\ncoil/transform/RoundedCornersTransformation\n*L\n58#1:133\n59#1:134,2\n59#1:137\n106#1:138\n107#1:139\n*E\n"})
public final class RoundedCornersTransformation
implements Transformation {
    private final float topLeft;
    private final float topRight;
    private final float bottomLeft;
    private final float bottomRight;
    @NotNull
    private final String cacheKey;

    public RoundedCornersTransformation(@Px float topLeft, @Px float topRight, @Px float bottomLeft, @Px float bottomRight) {
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
        if (!(this.topLeft >= 0.0f && this.topRight >= 0.0f && this.bottomLeft >= 0.0f && this.bottomRight >= 0.0f)) {
            boolean bl = false;
            String string = "All radii must be >= 0.";
            throw new IllegalArgumentException(string.toString());
        }
        this.cacheKey = this.getClass().getName() + '-' + this.topLeft + ',' + this.topRight + ',' + this.bottomLeft + ',' + this.bottomRight;
    }

    public /* synthetic */ RoundedCornersTransformation(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        if ((n & 8) != 0) {
            f4 = 0.0f;
        }
        this(f, f2, f3, f4);
    }

    public RoundedCornersTransformation(@Px float radius) {
        this(radius, radius, radius, radius);
    }

    @Override
    @NotNull
    public String getCacheKey() {
        return this.cacheKey;
    }

    @Override
    @Nullable
    public Object transform(@NotNull Bitmap input, @NotNull Size size2, @NotNull Continuation<? super Bitmap> $completion) {
        Path path;
        Canvas c$iv;
        Bitmap output;
        Paint paint = new Paint(3);
        Pair<Integer, Integer> pair = this.calculateOutputSize(input, size2);
        int outputWidth = ((Number)pair.component1()).intValue();
        int outputHeight = ((Number)pair.component2()).intValue();
        Bitmap.Config config$iv = -Bitmaps.getSafeConfig(input);
        boolean $i$f$createBitmap = false;
        Bitmap $this$applyCanvas$iv = output = Bitmap.createBitmap((int)outputWidth, (int)outputHeight, (Bitmap.Config)config$iv);
        boolean $i$f$applyCanvas = false;
        Canvas $this$transform_u24lambda_u242 = c$iv = new Canvas($this$applyCanvas$iv);
        boolean bl = false;
        $this$transform_u24lambda_u242.drawColor(0, PorterDuff.Mode.CLEAR);
        Matrix matrix = new Matrix();
        float multiplier = (float)DecodeUtils.computeSizeMultiplier(input.getWidth(), input.getHeight(), outputWidth, outputHeight, Scale.FILL);
        float dx = ((float)outputWidth - multiplier * (float)input.getWidth()) / (float)2;
        float dy = ((float)outputHeight - multiplier * (float)input.getHeight()) / (float)2;
        matrix.setTranslate(dx, dy);
        matrix.preScale(multiplier, multiplier);
        BitmapShader shader = new BitmapShader(input, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        shader.setLocalMatrix(matrix);
        paint.setShader((Shader)shader);
        float[] fArray = new float[]{this.topLeft, this.topLeft, this.topRight, this.topRight, this.bottomRight, this.bottomRight, this.bottomLeft, this.bottomLeft};
        float[] radii = fArray;
        RectF rect = new RectF(0.0f, 0.0f, (float)$this$transform_u24lambda_u242.getWidth(), (float)$this$transform_u24lambda_u242.getHeight());
        Path $this$transform_u24lambda_u242_u24lambda_u241 = path = new Path();
        boolean bl2 = false;
        $this$transform_u24lambda_u242_u24lambda_u241.addRoundRect(rect, radii, Path.Direction.CW);
        Path path2 = path;
        $this$transform_u24lambda_u242.drawPath(path2, paint);
        return output;
    }

    private final Pair<Integer, Integer> calculateOutputSize(Bitmap input, Size size2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (-Sizes.isOriginal(size2)) {
            return TuplesKt.to((Object)input.getWidth(), (Object)input.getHeight());
        }
        Dimension dstWidth = size2.component1();
        Dimension dstHeight = size2.component2();
        if (dstWidth instanceof Dimension.Pixels && dstHeight instanceof Dimension.Pixels) {
            return TuplesKt.to((Object)((Dimension.Pixels)dstWidth).px, (Object)((Dimension.Pixels)dstHeight).px);
        }
        int n6 = input.getWidth();
        int n7 = input.getHeight();
        Dimension $this$pxOrElse$iv = size2.getWidth();
        boolean $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n5 = ((Dimension.Pixels)$this$pxOrElse$iv).px;
        } else {
            n4 = n7;
            n3 = n6;
            boolean bl = false;
            n2 = Integer.MIN_VALUE;
            n6 = n3;
            n7 = n4;
            n5 = n2;
        }
        $this$pxOrElse$iv = size2.getHeight();
        $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n = ((Dimension.Pixels)$this$pxOrElse$iv).px;
        } else {
            n2 = n5;
            n4 = n7;
            n3 = n6;
            boolean bl = false;
            int n8 = Integer.MIN_VALUE;
            n6 = n3;
            n7 = n4;
            n5 = n2;
            n = n8;
        }
        double multiplier = DecodeUtils.computeSizeMultiplier(n6, n7, n5, n, Scale.FILL);
        int outputWidth = MathKt.roundToInt((double)(multiplier * (double)input.getWidth()));
        int outputHeight = MathKt.roundToInt((double)(multiplier * (double)input.getHeight()));
        return TuplesKt.to((Object)outputWidth, (Object)outputHeight);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RoundedCornersTransformation && this.topLeft == ((RoundedCornersTransformation)other).topLeft && this.topRight == ((RoundedCornersTransformation)other).topRight && this.bottomLeft == ((RoundedCornersTransformation)other).bottomLeft && this.bottomRight == ((RoundedCornersTransformation)other).bottomRight;
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.topLeft);
        result2 = 31 * result2 + Float.hashCode(this.topRight);
        result2 = 31 * result2 + Float.hashCode(this.bottomLeft);
        result2 = 31 * result2 + Float.hashCode(this.bottomRight);
        return result2;
    }

    public RoundedCornersTransformation() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
    }
}

