/*
 * Decompiled with CFR 0.152.
 */
package coil.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.view.View;
import android.webkit.MimeTypeMap;
import android.widget.ImageView;
import androidx.core.content.ContextCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import coil.ComponentRegistry;
import coil.EventListener;
import coil.base.R;
import coil.decode.DataSource;
import coil.decode.Decoder;
import coil.disk.DiskCache;
import coil.fetch.Fetcher;
import coil.intercept.Interceptor;
import coil.intercept.RealInterceptorChain;
import coil.memory.MemoryCache;
import coil.request.Parameters;
import coil.request.Tags;
import coil.request.ViewTargetRequestManager;
import coil.size.-Sizes;
import coil.size.Dimension;
import coil.size.Scale;
import coil.size.Size;
import java.io.Closeable;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.Deferred;
import okhttp3.Headers;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u009c\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010K\u001a\u00020\u00072\u0006\u0010L\u001a\u00020A2\u0006\u0010M\u001a\u00020\rH\u0000\u001a\u0010\u0010N\u001a\u00020\r2\u0006\u0010L\u001a\u00020AH\u0000\u001a\u0010\u0010O\u001a\u0002022\u0006\u0010P\u001a\u00020&H\u0000\u001a\b\u0010Q\u001a\u000202H\u0000\u001a\b\u0010R\u001a\u00020SH\u0000\u001a\f\u0010T\u001a\u00020U*\u00020VH\u0000\u001a\u0017\u0010W\u001a\u00020X*\u00020X2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0080\b\u001a+\u0010W\u001a\u00020X*\u00020X2\u001c\u0010[\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030]\u0012\b\u0012\u0006\u0012\u0002\b\u00030^\u0018\u00010\\H\u0080\b\u001a\u0014\u0010_\u001a\u00020`*\u00020`2\u0006\u0010a\u001a\u00020\u0001H\u0000\u001a\f\u0010b\u001a\u00020U*\u00020cH\u0000\u001a\u0019\u0010d\u001a\u0004\u0018\u00010e*\u00020f2\b\u0010g\u001a\u0004\u0018\u00010hH\u0080\n\u001a\u001f\u0010i\u001a\u0004\u0018\u0001Hj\"\u0004\b\u0000\u0010j*\b\u0012\u0004\u0012\u0002Hj0kH\u0000\u00a2\u0006\u0002\u0010l\u001a\u0018\u0010m\u001a\u0004\u0018\u00010\u0001*\u00020n2\b\u0010o\u001a\u0004\u0018\u00010\u0001H\u0000\u001a#\u0010p\u001a\u00020\u0007*\u00020q2\u0006\u0010D\u001a\u00020E2\f\u0010r\u001a\b\u0012\u0004\u0012\u00020\u00070sH\u0080\b\u001a\f\u0010t\u001a\u000202*\u00020\u0007H\u0000\u001a\u000e\u0010u\u001a\u00020v*\u0004\u0018\u00010vH\u0000\u001a\u000e\u0010u\u001a\u00020w*\u0004\u0018\u00010wH\u0000\u001a\u000e\u0010u\u001a\u00020\t*\u0004\u0018\u00010\tH\u0000\u001a\f\u0010x\u001a\u00020y*\u00020zH\u0000\u001a\u0014\u0010{\u001a\u00020\u0007*\u00020\u00012\u0006\u0010|\u001a\u00020\u0007H\u0000\u001a\u0014\u0010}\u001a\u00020\u0007*\u00020~2\u0006\u0010D\u001a\u00020EH\u0000\u001a#\u0010\u007f\u001a\u00020\u0007*\u00020q2\u0006\u0010D\u001a\u00020E2\f\u0010r\u001a\b\u0012\u0004\u0012\u00020\u00070sH\u0080\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u000e\u0010\u0016\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001a\"\u0018\u0010\u001c\u001a\u00020\u0001*\u00020\u001d8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\"\u0018\u0010 \u001a\u00020!*\u00020\"8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\"\u001a\u0010%\u001a\u0004\u0018\u00010\u0001*\u00020&8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\"\u0018\u0010)\u001a\u00020\u0007*\u00020*8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\"\u0019\u0010-\u001a\u00020\u0007*\u00020.8\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\"\u0018\u00101\u001a\u000202*\u00020\"8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00103\"\u0018\u00104\u001a\u000202*\u00020*8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\"\u0018\u00106\u001a\u00020\u0007*\u0002078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109\"\u0018\u0010:\u001a\u00020;*\u00020<8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\"\u0018\u0010?\u001a\u00020@*\u00020A8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\"\u0018\u0010D\u001a\u00020E*\u00020F8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010H\"\u0018\u0010I\u001a\u00020\u0007*\u00020*8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010,\u00a8\u0006\u0080\u0001"}, d2={"ASSET_FILE_PATH_ROOT", "", "DEFAULT_BITMAP_CONFIG", "Landroid/graphics/Bitmap$Config;", "getDEFAULT_BITMAP_CONFIG", "()Landroid/graphics/Bitmap$Config;", "DEFAULT_MEMORY_CLASS_MEGABYTES", "", "EMPTY_HEADERS", "Lokhttp3/Headers;", "getEMPTY_HEADERS", "()Lokhttp3/Headers;", "LOW_MEMORY_MULTIPLIER", "", "MIME_TYPE_HEIC", "MIME_TYPE_HEIF", "MIME_TYPE_JPEG", "MIME_TYPE_WEBP", "NULL_COLOR_SPACE", "Landroid/graphics/ColorSpace;", "getNULL_COLOR_SPACE", "()Landroid/graphics/ColorSpace;", "STANDARD_MEMORY_MULTIPLIER", "VALID_TRANSFORMATION_CONFIGS", "", "getVALID_TRANSFORMATION_CONFIGS", "()[Landroid/graphics/Bitmap$Config;", "[Landroid/graphics/Bitmap$Config;", "emoji", "Lcoil/decode/DataSource;", "getEmoji", "(Lcoil/decode/DataSource;)Ljava/lang/String;", "eventListener", "Lcoil/EventListener;", "Lcoil/intercept/Interceptor$Chain;", "getEventListener", "(Lcoil/intercept/Interceptor$Chain;)Lcoil/EventListener;", "firstPathSegment", "Landroid/net/Uri;", "getFirstPathSegment", "(Landroid/net/Uri;)Ljava/lang/String;", "height", "Landroid/graphics/drawable/Drawable;", "getHeight", "(Landroid/graphics/drawable/Drawable;)I", "identityHashCode", "", "getIdentityHashCode", "(Ljava/lang/Object;)I", "isPlaceholderCached", "", "(Lcoil/intercept/Interceptor$Chain;)Z", "isVector", "(Landroid/graphics/drawable/Drawable;)Z", "nightMode", "Landroid/content/res/Configuration;", "getNightMode", "(Landroid/content/res/Configuration;)I", "requestManager", "Lcoil/request/ViewTargetRequestManager;", "Landroid/view/View;", "getRequestManager", "(Landroid/view/View;)Lcoil/request/ViewTargetRequestManager;", "safeCacheDir", "Ljava/io/File;", "Landroid/content/Context;", "getSafeCacheDir", "(Landroid/content/Context;)Ljava/io/File;", "scale", "Lcoil/size/Scale;", "Landroid/widget/ImageView;", "getScale", "(Landroid/widget/ImageView;)Lcoil/size/Scale;", "width", "getWidth", "calculateMemoryCacheSize", "context", "percent", "defaultMemoryCacheSizePercent", "isAssetUri", "uri", "isMainThread", "unsupported", "", "abortQuietly", "", "Lcoil/disk/DiskCache$Editor;", "addFirst", "Lcoil/ComponentRegistry$Builder;", "factory", "Lcoil/decode/Decoder$Factory;", "pair", "Lkotlin/Pair;", "Lcoil/fetch/Fetcher$Factory;", "Ljava/lang/Class;", "addUnsafeNonAscii", "Lokhttp3/Headers$Builder;", "line", "closeQuietly", "Ljava/io/Closeable;", "get", "Lcoil/memory/MemoryCache$Value;", "Lcoil/memory/MemoryCache;", "key", "Lcoil/memory/MemoryCache$Key;", "getCompletedOrNull", "T", "Lkotlinx/coroutines/Deferred;", "(Lkotlinx/coroutines/Deferred;)Ljava/lang/Object;", "getMimeTypeFromUrl", "Landroid/webkit/MimeTypeMap;", "url", "heightPx", "Lcoil/size/Size;", "original", "Lkotlin/Function0;", "isMinOrMax", "orEmpty", "Lcoil/request/Parameters;", "Lcoil/request/Tags;", "requireBody", "Lokhttp3/ResponseBody;", "Lokhttp3/Response;", "toNonNegativeInt", "defaultValue", "toPx", "Lcoil/size/Dimension;", "widthPx", "coil-base_release"})
@JvmName(name="-Utils")
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncoil/util/-Utils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Dimension.kt\ncoil/size/-Dimensions\n+ 4 Contexts.kt\ncoil/util/-Contexts\n+ 5 Context.kt\nandroidx/core/content/ContextKt\n*L\n1#1,302:1\n1#2:303\n57#3:304\n78#4:305\n78#4:307\n31#5:306\n31#5:308\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncoil/util/-Utils\n*L\n226#1:304\n258#1:305\n270#1:307\n258#1:306\n270#1:308\n*E\n"})
public final class -Utils {
    @NotNull
    private static final Bitmap.Config[] VALID_TRANSFORMATION_CONFIGS;
    @NotNull
    private static final Bitmap.Config DEFAULT_BITMAP_CONFIG;
    @Nullable
    private static final ColorSpace NULL_COLOR_SPACE;
    @NotNull
    private static final Headers EMPTY_HEADERS;
    @NotNull
    public static final String MIME_TYPE_JPEG = "image/jpeg";
    @NotNull
    public static final String MIME_TYPE_WEBP = "image/webp";
    @NotNull
    public static final String MIME_TYPE_HEIC = "image/heic";
    @NotNull
    public static final String MIME_TYPE_HEIF = "image/heif";
    @NotNull
    public static final String ASSET_FILE_PATH_ROOT = "android_asset";
    private static final double STANDARD_MEMORY_MULTIPLIER = 0.2;
    private static final double LOW_MEMORY_MULTIPLIER = 0.15;
    private static final int DEFAULT_MEMORY_CLASS_MEGABYTES = 256;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ViewTargetRequestManager getRequestManager(@NotNull View $this$requestManager) {
        ViewTargetRequestManager manager;
        Object object = $this$requestManager.getTag(R.id.coil_request_manager);
        ViewTargetRequestManager viewTargetRequestManager = manager = object instanceof ViewTargetRequestManager ? (ViewTargetRequestManager)object : null;
        if (manager == null) {
            ViewTargetRequestManager viewTargetRequestManager2;
            object = $this$requestManager;
            synchronized (object) {
                ViewTargetRequestManager viewTargetRequestManager3;
                ViewTargetRequestManager viewTargetRequestManager4;
                boolean bl = false;
                Object object2 = $this$requestManager.getTag(R.id.coil_request_manager);
                ViewTargetRequestManager viewTargetRequestManager5 = viewTargetRequestManager4 = object2 instanceof ViewTargetRequestManager ? (ViewTargetRequestManager)object2 : null;
                if (viewTargetRequestManager4 != null) {
                    ViewTargetRequestManager it = viewTargetRequestManager4;
                    boolean bl2 = false;
                    viewTargetRequestManager3 = it;
                } else {
                    ViewTargetRequestManager $this$_get_requestManager__u24lambda_u242_u24lambda_u241 = viewTargetRequestManager4 = new ViewTargetRequestManager($this$requestManager);
                    boolean bl3 = false;
                    $this$requestManager.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)$this$_get_requestManager__u24lambda_u242_u24lambda_u241);
                    $this$requestManager.setTag(R.id.coil_request_manager, (Object)$this$_get_requestManager__u24lambda_u242_u24lambda_u241);
                    viewTargetRequestManager3 = viewTargetRequestManager4;
                }
                viewTargetRequestManager2 = viewTargetRequestManager3;
            }
            manager = viewTargetRequestManager2;
        }
        return manager;
    }

    @NotNull
    public static final String getEmoji(@NotNull DataSource $this$emoji) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$emoji.ordinal()]) {
            case 1: 
            case 2: {
                string = "\ud83e\udde0";
                break;
            }
            case 3: {
                string = "\ud83d\udcbe";
                break;
            }
            case 4: {
                string = "\u2601\ufe0f ";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public static final int getWidth(@NotNull Drawable $this$width) {
        BitmapDrawable bitmapDrawable = $this$width instanceof BitmapDrawable ? (BitmapDrawable)$this$width : null;
        return bitmapDrawable != null && (bitmapDrawable = bitmapDrawable.getBitmap()) != null ? bitmapDrawable.getWidth() : $this$width.getIntrinsicWidth();
    }

    public static final int getHeight(@NotNull Drawable $this$height) {
        BitmapDrawable bitmapDrawable = $this$height instanceof BitmapDrawable ? (BitmapDrawable)$this$height : null;
        return bitmapDrawable != null && (bitmapDrawable = bitmapDrawable.getBitmap()) != null ? bitmapDrawable.getHeight() : $this$height.getIntrinsicHeight();
    }

    public static final boolean isVector(@NotNull Drawable $this$isVector) {
        return $this$isVector instanceof VectorDrawable || $this$isVector instanceof VectorDrawableCompat;
    }

    public static final void closeQuietly(@NotNull Closeable $this$closeQuietly) {
        try {
            $this$closeQuietly.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static final Scale getScale(@NotNull ImageView $this$scale) {
        Scale scale;
        ImageView.ScaleType scaleType = $this$scale.getScaleType();
        switch (scaleType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[scaleType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                scale = Scale.FIT;
                break;
            }
            default: {
                scale = Scale.FILL;
            }
        }
        return scale;
    }

    @Nullable
    public static final String getMimeTypeFromUrl(@NotNull MimeTypeMap $this$getMimeTypeFromUrl, @Nullable String url) {
        CharSequence charSequence = url;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        String extension = StringsKt.substringAfterLast((String)StringsKt.substringAfterLast$default((String)StringsKt.substringBeforeLast$default((String)StringsKt.substringBeforeLast$default((String)url, (char)'#', null, (int)2, null), (char)'?', null, (int)2, null), (char)'/', null, (int)2, null), (char)'.', (String)"");
        return $this$getMimeTypeFromUrl.getMimeTypeFromExtension(extension);
    }

    @Nullable
    public static final String getFirstPathSegment(@NotNull Uri $this$firstPathSegment) {
        return (String)CollectionsKt.firstOrNull((List)$this$firstPathSegment.getPathSegments());
    }

    public static final int getNightMode(@NotNull Configuration $this$nightMode) {
        return $this$nightMode.uiMode & 0x30;
    }

    @NotNull
    public static final Bitmap.Config[] getVALID_TRANSFORMATION_CONFIGS() {
        return VALID_TRANSFORMATION_CONFIGS;
    }

    @NotNull
    public static final Bitmap.Config getDEFAULT_BITMAP_CONFIG() {
        return DEFAULT_BITMAP_CONFIG;
    }

    @Nullable
    public static final ColorSpace getNULL_COLOR_SPACE() {
        return NULL_COLOR_SPACE;
    }

    @NotNull
    public static final Headers getEMPTY_HEADERS() {
        return EMPTY_HEADERS;
    }

    @NotNull
    public static final Headers orEmpty(@Nullable Headers $this$orEmpty) {
        Headers headers = $this$orEmpty;
        if (headers == null) {
            headers = EMPTY_HEADERS;
        }
        return headers;
    }

    @NotNull
    public static final Tags orEmpty(@Nullable Tags $this$orEmpty) {
        Tags tags = $this$orEmpty;
        if (tags == null) {
            tags = Tags.EMPTY;
        }
        return tags;
    }

    @NotNull
    public static final Parameters orEmpty(@Nullable Parameters $this$orEmpty) {
        Parameters parameters = $this$orEmpty;
        if (parameters == null) {
            parameters = Parameters.EMPTY;
        }
        return parameters;
    }

    public static final boolean isMainThread() {
        return Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper());
    }

    public static final int getIdentityHashCode(@NotNull Object $this$identityHashCode) {
        boolean $i$f$getIdentityHashCode = false;
        return System.identityHashCode($this$identityHashCode);
    }

    @Nullable
    public static final <T> T getCompletedOrNull(@NotNull Deferred<? extends T> $this$getCompletedOrNull) {
        Object object;
        try {
            object = $this$getCompletedOrNull.getCompleted();
        }
        catch (Throwable _) {
            object = null;
        }
        return (T)object;
    }

    @Nullable
    public static final MemoryCache.Value get(@NotNull MemoryCache $this$get, @Nullable MemoryCache.Key key) {
        MemoryCache.Value value;
        boolean $i$f$get = false;
        MemoryCache.Key key2 = key;
        if (key2 != null) {
            MemoryCache.Key p0 = key2;
            boolean bl = false;
            value = $this$get.get(p0);
        } else {
            value = null;
        }
        return value;
    }

    @NotNull
    public static final File getSafeCacheDir(@NotNull Context $this$safeCacheDir) {
        File cacheDir;
        File file;
        File file2 = $this$safeCacheDir.getCacheDir();
        if (file2 == null) {
            boolean $i$a$-checkNotNull--Utils$safeCacheDir$cacheDir$22 = false;
            String $i$a$-checkNotNull--Utils$safeCacheDir$cacheDir$22 = "cacheDir == null";
            throw new IllegalStateException($i$a$-checkNotNull--Utils$safeCacheDir$cacheDir$22.toString());
        }
        File $this$_get_safeCacheDir__u24lambda_u244 = file = (cacheDir = file2);
        boolean bl = false;
        $this$_get_safeCacheDir__u24lambda_u244.mkdirs();
        return file;
    }

    @NotNull
    public static final ComponentRegistry.Builder addFirst(@NotNull ComponentRegistry.Builder $this$addFirst, @Nullable Pair<? extends Fetcher.Factory<?>, ? extends Class<?>> pair) {
        ComponentRegistry.Builder builder;
        boolean $i$f$addFirst = false;
        ComponentRegistry.Builder $this$addFirst_u24lambda_u245 = builder = $this$addFirst;
        boolean bl = false;
        if (pair != null) {
            $this$addFirst_u24lambda_u245.getFetcherFactories$coil_base_release().add(0, pair);
        }
        return builder;
    }

    @NotNull
    public static final ComponentRegistry.Builder addFirst(@NotNull ComponentRegistry.Builder $this$addFirst, @Nullable Decoder.Factory factory) {
        ComponentRegistry.Builder builder;
        boolean $i$f$addFirst = false;
        ComponentRegistry.Builder $this$addFirst_u24lambda_u246 = builder = $this$addFirst;
        boolean bl = false;
        if (factory != null) {
            $this$addFirst_u24lambda_u246.getDecoderFactories$coil_base_release().add(0, factory);
        }
        return builder;
    }

    public static final int toNonNegativeInt(@NotNull String $this$toNonNegativeInt, int defaultValue) {
        Long l = StringsKt.toLongOrNull((String)$this$toNonNegativeInt);
        if (l == null) {
            return defaultValue;
        }
        long value = l;
        return value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (value < 0L ? 0 : (int)value);
    }

    public static final void abortQuietly(@NotNull DiskCache.Editor $this$abortQuietly) {
        try {
            $this$abortQuietly.abort();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final boolean isPlaceholderCached(@NotNull Interceptor.Chain $this$isPlaceholderCached) {
        return $this$isPlaceholderCached instanceof RealInterceptorChain && ((RealInterceptorChain)$this$isPlaceholderCached).isPlaceholderCached();
    }

    @NotNull
    public static final EventListener getEventListener(@NotNull Interceptor.Chain $this$eventListener) {
        return $this$eventListener instanceof RealInterceptorChain ? ((RealInterceptorChain)$this$eventListener).getEventListener() : EventListener.NONE;
    }

    public static final boolean isMinOrMax(int $this$isMinOrMax) {
        return $this$isMinOrMax == Integer.MIN_VALUE || $this$isMinOrMax == Integer.MAX_VALUE;
    }

    public static final int widthPx(@NotNull Size $this$widthPx, @NotNull Scale scale, @NotNull Function0<Integer> original) {
        boolean $i$f$widthPx = false;
        return -Sizes.isOriginal($this$widthPx) ? ((Number)original.invoke()).intValue() : -Utils.toPx($this$widthPx.getWidth(), scale);
    }

    public static final int heightPx(@NotNull Size $this$heightPx, @NotNull Scale scale, @NotNull Function0<Integer> original) {
        boolean $i$f$heightPx = false;
        return -Sizes.isOriginal($this$heightPx) ? ((Number)original.invoke()).intValue() : -Utils.toPx($this$heightPx.getHeight(), scale);
    }

    public static final int toPx(@NotNull Dimension $this$toPx, @NotNull Scale scale) {
        int n;
        Dimension $this$pxOrElse$iv = $this$toPx;
        boolean $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n = ((Dimension.Pixels)$this$pxOrElse$iv).px;
        } else {
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$2[scale.ordinal()]) {
                case 1: {
                    n = Integer.MIN_VALUE;
                    break;
                }
                case 2: {
                    n = Integer.MAX_VALUE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return n;
    }

    @NotNull
    public static final Void unsupported() {
        throw new IllegalStateException("Unsupported".toString());
    }

    public static final boolean isAssetUri(@NotNull Uri uri) {
        return Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file") && Intrinsics.areEqual((Object)-Utils.getFirstPathSegment(uri), (Object)ASSET_FILE_PATH_ROOT);
    }

    @NotNull
    public static final Headers.Builder addUnsafeNonAscii(@NotNull Headers.Builder $this$addUnsafeNonAscii, @NotNull String line) {
        Headers.Builder builder;
        Headers.Builder $this$addUnsafeNonAscii_u24lambda_u249 = builder = $this$addUnsafeNonAscii;
        boolean bl = false;
        int index = StringsKt.indexOf$default((CharSequence)line, (char)':', (int)0, (boolean)false, (int)6, null);
        if (!(index != -1)) {
            boolean bl2 = false;
            String string = "Unexpected header: " + line;
            throw new IllegalArgumentException(string.toString());
        }
        String string = line.substring(0, index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String string3 = line.substring(index + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        $this$addUnsafeNonAscii_u24lambda_u249.addUnsafeNonAscii(string2, string3);
        return builder;
    }

    @NotNull
    public static final ResponseBody requireBody(@NotNull Response $this$requireBody) {
        ResponseBody responseBody = $this$requireBody.body();
        if (responseBody == null) {
            boolean bl = false;
            String string = "response body == null";
            throw new IllegalStateException(string.toString());
        }
        return responseBody;
    }

    public static final double defaultMemoryCacheSizePercent(@NotNull Context context) {
        double d;
        try {
            Context $this$requireSystemService$iv = context;
            boolean $i$f$requireSystemService = false;
            Context $this$getSystemService$iv$iv = $this$requireSystemService$iv;
            boolean $i$f$getSystemService = false;
            Object object = ContextCompat.getSystemService((Context)$this$getSystemService$iv$iv, ActivityManager.class);
            Intrinsics.checkNotNull((Object)object);
            ActivityManager activityManager = (ActivityManager)object;
            d = activityManager.isLowRamDevice() ? 0.15 : 0.2;
        }
        catch (Exception _) {
            d = 0.2;
        }
        return d;
    }

    public static final int calculateMemoryCacheSize(@NotNull Context context, double percent) {
        int n;
        try {
            Context $this$requireSystemService$iv = context;
            boolean $i$f$requireSystemService = false;
            Context $this$getSystemService$iv$iv = $this$requireSystemService$iv;
            boolean $i$f$getSystemService = false;
            Object object = ContextCompat.getSystemService((Context)$this$getSystemService$iv$iv, ActivityManager.class);
            Intrinsics.checkNotNull((Object)object);
            ActivityManager activityManager = (ActivityManager)object;
            boolean isLargeHeap = (context.getApplicationInfo().flags & 0x100000) != 0;
            n = isLargeHeap ? activityManager.getLargeMemoryClass() : activityManager.getMemoryClass();
        }
        catch (Exception _) {
            n = 256;
        }
        int memoryClassMegabytes = n;
        return (int)(percent * (double)memoryClassMegabytes * (double)1024 * (double)1024);
    }

    static {
        Bitmap.Config[] configArray;
        if (Build.VERSION.SDK_INT >= 26) {
            Bitmap.Config[] configArray2 = new Bitmap.Config[]{Bitmap.Config.ARGB_8888, Bitmap.Config.RGBA_F16};
            configArray = configArray2;
        } else {
            Bitmap.Config[] configArray3 = new Bitmap.Config[]{Bitmap.Config.ARGB_8888};
            configArray = configArray3;
        }
        VALID_TRANSFORMATION_CONFIGS = configArray;
        DEFAULT_BITMAP_CONFIG = Build.VERSION.SDK_INT >= 26 ? Bitmap.Config.HARDWARE : Bitmap.Config.ARGB_8888;
        EMPTY_HEADERS = new Headers.Builder().build();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[DataSource.values().length];
            try {
                nArray[DataSource.MEMORY_CACHE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSource.MEMORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSource.DISK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSource.NETWORK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ImageView.ScaleType.values().length];
            try {
                nArray[ImageView.ScaleType.FIT_START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.FIT_CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.FIT_END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.CENTER_INSIDE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[Scale.values().length];
            try {
                nArray[Scale.FILL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scale.FIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

