/*
 * Decompiled with CFR 0.152.
 */
package coil.disk;

import android.os.StatFs;
import androidx.annotation.FloatRange;
import coil.annotation.ExperimentalCoilApi;
import coil.disk.RealDiskCache;
import java.io.Closeable;
import java.io.File;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0003!\"#J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H'J\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u00a7\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H'J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H'J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H'J\b\u0010\u001f\u001a\u00020 H'R\u001a\u0010\u0002\u001a\u00020\u00038&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u00038&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\u0005\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\u00020\f8&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u0005\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u00118&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0005\u001a\u0004\b\u0013\u0010\u0014\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006$\u00c0\u0006\u0001"}, d2={"Lcoil/disk/DiskCache;", "", "size", "", "getSize$annotations", "()V", "getSize", "()J", "maxSize", "getMaxSize$annotations", "getMaxSize", "directory", "Lokio/Path;", "getDirectory$annotations", "getDirectory", "()Lokio/Path;", "fileSystem", "Lokio/FileSystem;", "getFileSystem$annotations", "getFileSystem", "()Lokio/FileSystem;", "openSnapshot", "Lcoil/disk/DiskCache$Snapshot;", "key", "", "get", "openEditor", "Lcoil/disk/DiskCache$Editor;", "edit", "remove", "", "clear", "", "Snapshot", "Editor", "Builder", "coil-base_release"})
public interface DiskCache {
    public long getSize();

    @ExperimentalCoilApi
    public static /* synthetic */ void getSize$annotations() {
    }

    public long getMaxSize();

    @ExperimentalCoilApi
    public static /* synthetic */ void getMaxSize$annotations() {
    }

    @NotNull
    public Path getDirectory();

    @ExperimentalCoilApi
    public static /* synthetic */ void getDirectory$annotations() {
    }

    @NotNull
    public FileSystem getFileSystem();

    @ExperimentalCoilApi
    public static /* synthetic */ void getFileSystem$annotations() {
    }

    @ExperimentalCoilApi
    @Nullable
    public Snapshot openSnapshot(@NotNull String var1);

    @Deprecated(message="Renamed to 'openSnapshot'.", replaceWith=@ReplaceWith(expression="openSnapshot(key)", imports={}))
    @ExperimentalCoilApi
    @Nullable
    public Snapshot get(@NotNull String var1);

    @ExperimentalCoilApi
    @Nullable
    public Editor openEditor(@NotNull String var1);

    @Deprecated(message="Renamed to 'openEditor'.", replaceWith=@ReplaceWith(expression="openEditor(key)", imports={}))
    @ExperimentalCoilApi
    @Nullable
    public Editor edit(@NotNull String var1);

    @ExperimentalCoilApi
    public boolean remove(@NotNull String var1);

    @ExperimentalCoilApi
    public void clear();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0010J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00002\b\b\u0001\u0010\u0011\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u000fJ\u0006\u0010\u0014\u001a\u00020\u0015R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcoil/disk/DiskCache$Builder;", "", "<init>", "()V", "directory", "Lokio/Path;", "fileSystem", "Lokio/FileSystem;", "maxSizePercent", "", "minimumMaxSizeBytes", "", "maximumMaxSizeBytes", "maxSizeBytes", "cleanupDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "Ljava/io/File;", "percent", "size", "dispatcher", "build", "Lcoil/disk/DiskCache;", "coil-base_release"})
    @SourceDebugExtension(value={"SMAP\nDiskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskCache.kt\ncoil/disk/DiskCache$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n1#2:241\n*E\n"})
    public static final class Builder {
        @Nullable
        private Path directory;
        @NotNull
        private FileSystem fileSystem = FileSystem.SYSTEM;
        private double maxSizePercent = 0.02;
        private long minimumMaxSizeBytes = 0xA00000L;
        private long maximumMaxSizeBytes = 0xFA00000L;
        private long maxSizeBytes;
        @NotNull
        private CoroutineDispatcher cleanupDispatcher = Dispatchers.getIO();

        @NotNull
        public final Builder directory(@NotNull File directory) {
            return this.directory(Path.Companion.get$default((Path.Companion)Path.Companion, (File)directory, (boolean)false, (int)1, null));
        }

        @NotNull
        public final Builder directory(@NotNull Path directory) {
            Builder builder;
            Builder $this$directory_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$directory_u24lambda_u240.directory = directory;
            return builder;
        }

        @NotNull
        public final Builder fileSystem(@NotNull FileSystem fileSystem2) {
            Builder builder;
            Builder $this$fileSystem_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$fileSystem_u24lambda_u241.fileSystem = fileSystem2;
            return builder;
        }

        @NotNull
        public final Builder maxSizePercent(@FloatRange(from=0.0, to=1.0) double percent) {
            Builder builder;
            Builder $this$maxSizePercent_u24lambda_u243 = builder = this;
            boolean bl = false;
            if (!(0.0 <= percent ? percent <= 1.0 : false)) {
                boolean bl2 = false;
                String string = "size must be in the range [0.0, 1.0].";
                throw new IllegalArgumentException(string.toString());
            }
            $this$maxSizePercent_u24lambda_u243.maxSizeBytes = 0L;
            $this$maxSizePercent_u24lambda_u243.maxSizePercent = percent;
            return builder;
        }

        @NotNull
        public final Builder minimumMaxSizeBytes(long size2) {
            Builder builder;
            Builder $this$minimumMaxSizeBytes_u24lambda_u245 = builder = this;
            boolean bl = false;
            if (!(size2 > 0L)) {
                boolean bl2 = false;
                String string = "size must be > 0.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$minimumMaxSizeBytes_u24lambda_u245.minimumMaxSizeBytes = size2;
            return builder;
        }

        @NotNull
        public final Builder maximumMaxSizeBytes(long size2) {
            Builder builder;
            Builder $this$maximumMaxSizeBytes_u24lambda_u247 = builder = this;
            boolean bl = false;
            if (!(size2 > 0L)) {
                boolean bl2 = false;
                String string = "size must be > 0.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$maximumMaxSizeBytes_u24lambda_u247.maximumMaxSizeBytes = size2;
            return builder;
        }

        @NotNull
        public final Builder maxSizeBytes(long size2) {
            Builder builder;
            Builder $this$maxSizeBytes_u24lambda_u249 = builder = this;
            boolean bl = false;
            if (!(size2 > 0L)) {
                boolean bl2 = false;
                String string = "size must be > 0.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$maxSizeBytes_u24lambda_u249.maxSizePercent = 0.0;
            $this$maxSizeBytes_u24lambda_u249.maxSizeBytes = size2;
            return builder;
        }

        @NotNull
        public final Builder cleanupDispatcher(@NotNull CoroutineDispatcher dispatcher) {
            Builder builder;
            Builder $this$cleanupDispatcher_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$cleanupDispatcher_u24lambda_u2410.cleanupDispatcher = dispatcher;
            return builder;
        }

        @NotNull
        public final DiskCache build() {
            long l;
            Path path = this.directory;
            if (path == null) {
                boolean bl = false;
                String string = "directory == null";
                throw new IllegalStateException(string.toString());
            }
            Path directory = path;
            if (this.maxSizePercent > 0.0) {
                long l2;
                try {
                    File file;
                    File $this$build_u24lambda_u2412 = file = directory.toFile();
                    boolean bl = false;
                    $this$build_u24lambda_u2412.mkdir();
                    String string = file.getAbsolutePath();
                    StatFs stats = new StatFs(string);
                    double size2 = this.maxSizePercent * (double)stats.getBlockCountLong() * (double)stats.getBlockSizeLong();
                    l2 = RangesKt.coerceIn((long)((long)size2), (long)this.minimumMaxSizeBytes, (long)this.maximumMaxSizeBytes);
                }
                catch (Exception exception) {
                    l2 = this.minimumMaxSizeBytes;
                }
                l = l2;
            } else {
                l = this.maxSizeBytes;
            }
            long maxSize = l;
            return new RealDiskCache(maxSize, directory, this.fileSystem, this.cleanupDispatcher);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bg\u0018\u00002\u00020\u0001J\b\u0010\b\u001a\u00020\tH&J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH&J\n\u0010\f\u001a\u0004\u0018\u00010\u000bH'J\b\u0010\r\u001a\u00020\tH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcoil/disk/DiskCache$Editor;", "", "metadata", "Lokio/Path;", "getMetadata", "()Lokio/Path;", "data", "getData", "commit", "", "commitAndOpenSnapshot", "Lcoil/disk/DiskCache$Snapshot;", "commitAndGet", "abort", "coil-base_release"})
    @ExperimentalCoilApi
    public static interface Editor {
        @NotNull
        public Path getMetadata();

        @NotNull
        public Path getData();

        public void commit();

        @Nullable
        public Snapshot commitAndOpenSnapshot();

        @Deprecated(message="Renamed to 'commitAndOpenSnapshot'.", replaceWith=@ReplaceWith(expression="commitAndOpenSnapshot()", imports={}))
        @Nullable
        public Snapshot commitAndGet();

        public void abort();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u00002\u00060\u0002j\u0002`\u0001J\b\u0010\t\u001a\u00020\nH&J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH&J\n\u0010\r\u001a\u0004\u0018\u00010\fH'R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcoil/disk/DiskCache$Snapshot;", "Lokio/Closeable;", "Ljava/io/Closeable;", "metadata", "Lokio/Path;", "getMetadata", "()Lokio/Path;", "data", "getData", "close", "", "closeAndOpenEditor", "Lcoil/disk/DiskCache$Editor;", "closeAndEdit", "coil-base_release"})
    @ExperimentalCoilApi
    public static interface Snapshot
    extends Closeable {
        @NotNull
        public Path getMetadata();

        @NotNull
        public Path getData();

        @Override
        public void close();

        @Nullable
        public Editor closeAndOpenEditor();

        @Deprecated(message="Renamed to 'closeAndOpenEditor'.", replaceWith=@ReplaceWith(expression="closeAndOpenEditor()", imports={}))
        @Nullable
        public Editor closeAndEdit();
    }
}

