/*
 * Decompiled with CFR 0.152.
 */
package coil.drawable;

import android.content.res.ColorStateList;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import coil.decode.DecodeUtils;
import coil.size.Scale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 Y2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001YBE\b\u0007\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\tH\u0016J\u0010\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\tH\u0016J\b\u0010*\u001a\u00020\tH\u0017J\n\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u0012\u0010-\u001a\u00020$2\b\u0010.\u001a\u0004\u0018\u00010,H\u0016J\u0010\u0010/\u001a\u00020$2\u0006\u00100\u001a\u000201H\u0014J\u0010\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\tH\u0014J\u0010\u00104\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u000205H\u0014J\b\u00106\u001a\u00020\tH\u0016J\b\u00107\u001a\u00020\tH\u0016J\u0018\u00108\u001a\u00020$2\u0006\u00109\u001a\u00020\u00012\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020$2\u0006\u00109\u001a\u00020\u0001H\u0016J \u0010=\u001a\u00020$2\u0006\u00109\u001a\u00020\u00012\u0006\u0010:\u001a\u00020;2\u0006\u0010>\u001a\u00020\u001cH\u0016J\u0010\u0010?\u001a\u00020$2\u0006\u0010@\u001a\u00020\tH\u0016J\u0012\u0010A\u001a\u00020$2\b\u0010B\u001a\u0004\u0018\u00010CH\u0016J\u0012\u0010D\u001a\u00020$2\b\u0010E\u001a\u0004\u0018\u00010FH\u0016J\u0012\u0010G\u001a\u00020$2\b\u0010H\u001a\u0004\u0018\u00010IH\u0017J\b\u0010J\u001a\u00020\u000bH\u0016J\b\u0010\u0004\u001a\u00020$H\u0016J\b\u0010K\u001a\u00020$H\u0016J\u0010\u0010L\u001a\u00020$2\u0006\u0010M\u001a\u00020\u0018H\u0016J\u0010\u0010N\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u0018H\u0016J\b\u0010O\u001a\u00020$H\u0016J\u001d\u0010P\u001a\u00020$2\u0006\u0010Q\u001a\u00020\u00012\u0006\u0010R\u001a\u000201H\u0001\u00a2\u0006\u0002\bSJ!\u0010T\u001a\u00020\t2\b\u0010U\u001a\u0004\u0018\u00010\t2\b\u0010V\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010WJ\b\u0010X\u001a\u00020$H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!\u00a8\u0006Z"}, d2={"Lcoil/drawable/CrossfadeDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/Drawable$Callback;", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat;", "start", "end", "scale", "Lcoil/size/Scale;", "durationMillis", "", "fadeStart", "", "preferExactIntrinsicSize", "<init>", "(Landroid/graphics/drawable/Drawable;Landroid/graphics/drawable/Drawable;Lcoil/size/Scale;IZZ)V", "getScale", "()Lcoil/size/Scale;", "getDurationMillis", "()I", "getFadeStart", "()Z", "getPreferExactIntrinsicSize", "callbacks", "", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat$AnimationCallback;", "intrinsicWidth", "intrinsicHeight", "startTimeMillis", "", "maxAlpha", "state", "value", "getStart", "()Landroid/graphics/drawable/Drawable;", "getEnd", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getAlpha", "setAlpha", "alpha", "getOpacity", "getColorFilter", "Landroid/graphics/ColorFilter;", "setColorFilter", "colorFilter", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "onLevelChange", "level", "onStateChange", "", "getIntrinsicWidth", "getIntrinsicHeight", "unscheduleDrawable", "who", "what", "Ljava/lang/Runnable;", "invalidateDrawable", "scheduleDrawable", "when", "setTint", "tintColor", "setTintList", "tint", "Landroid/content/res/ColorStateList;", "setTintMode", "tintMode", "Landroid/graphics/PorterDuff$Mode;", "setTintBlendMode", "blendMode", "Landroid/graphics/BlendMode;", "isRunning", "stop", "registerAnimationCallback", "callback", "unregisterAnimationCallback", "clearAnimationCallbacks", "updateBounds", "drawable", "targetBounds", "updateBounds$coil_base_release", "computeIntrinsicDimension", "startSize", "endSize", "(Ljava/lang/Integer;Ljava/lang/Integer;)I", "markDone", "Companion", "coil-base_release"})
@SourceDebugExtension(value={"SMAP\nCrossfadeDrawable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrossfadeDrawable.kt\ncoil/drawable/CrossfadeDrawable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Canvas.kt\nandroidx/core/graphics/CanvasKt\n+ 4 Collections.kt\ncoil/util/-Collections\n*L\n1#1,277:1\n1#2:278\n30#3,7:279\n30#3,7:286\n30#3,7:293\n30#3,7:300\n12#4,4:307\n12#4,4:311\n*S KotlinDebug\n*F\n+ 1 CrossfadeDrawable.kt\ncoil/drawable/CrossfadeDrawable\n*L\n71#1:279,7\n79#1:286,7\n93#1:293,7\n100#1:300,7\n211#1:307,4\n266#1:311,4\n*E\n"})
public final class CrossfadeDrawable
extends Drawable
implements Drawable.Callback,
Animatable2Compat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Scale scale;
    private final int durationMillis;
    private final boolean fadeStart;
    private final boolean preferExactIntrinsicSize;
    @NotNull
    private final List<Animatable2Compat.AnimationCallback> callbacks;
    private final int intrinsicWidth;
    private final int intrinsicHeight;
    private long startTimeMillis;
    private int maxAlpha;
    private int state;
    @Nullable
    private Drawable start;
    @Nullable
    private final Drawable end;
    private static final int STATE_START = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_DONE = 2;
    public static final int DEFAULT_DURATION = 100;

    @JvmOverloads
    public CrossfadeDrawable(@Nullable Drawable start, @Nullable Drawable end, @NotNull Scale scale, int durationMillis, boolean fadeStart, boolean preferExactIntrinsicSize) {
        block2: {
            this.scale = scale;
            this.durationMillis = durationMillis;
            this.fadeStart = fadeStart;
            this.preferExactIntrinsicSize = preferExactIntrinsicSize;
            this.callbacks = new ArrayList();
            Drawable drawable = start;
            Drawable drawable2 = end;
            this.intrinsicWidth = this.computeIntrinsicDimension(drawable != null ? Integer.valueOf(drawable.getIntrinsicWidth()) : null, drawable2 != null ? Integer.valueOf(drawable2.getIntrinsicWidth()) : null);
            Drawable drawable3 = start;
            Drawable drawable4 = end;
            this.intrinsicHeight = this.computeIntrinsicDimension(drawable3 != null ? Integer.valueOf(drawable3.getIntrinsicHeight()) : null, drawable4 != null ? Integer.valueOf(drawable4.getIntrinsicHeight()) : null);
            this.maxAlpha = 255;
            Drawable drawable5 = start;
            this.start = drawable5 != null ? drawable5.mutate() : null;
            Drawable drawable6 = end;
            this.end = drawable6 != null ? drawable6.mutate() : null;
            if (!(this.durationMillis > 0)) {
                boolean bl = false;
                String string = "durationMillis must be > 0.";
                throw new IllegalArgumentException(string.toString());
            }
            Drawable drawable7 = this.start;
            if (drawable7 != null) {
                drawable7.setCallback((Drawable.Callback)this);
            }
            Drawable drawable8 = this.end;
            if (drawable8 == null) break block2;
            drawable8.setCallback((Drawable.Callback)this);
        }
    }

    public /* synthetic */ CrossfadeDrawable(Drawable drawable, Drawable drawable2, Scale scale, int n, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            scale = Scale.FIT;
        }
        if ((n2 & 8) != 0) {
            n = 100;
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        this(drawable, drawable2, scale, n, bl, bl2);
    }

    @NotNull
    public final Scale getScale() {
        return this.scale;
    }

    public final int getDurationMillis() {
        return this.durationMillis;
    }

    public final boolean getFadeStart() {
        return this.fadeStart;
    }

    public final boolean getPreferExactIntrinsicSize() {
        return this.preferExactIntrinsicSize;
    }

    @Nullable
    public final Drawable getStart() {
        return this.start;
    }

    @Nullable
    public final Drawable getEnd() {
        return this.end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NotNull Canvas canvas) {
        int checkpoint$iv;
        boolean $i$f$withSave;
        Canvas $this$withSave$iv;
        Drawable drawable;
        boolean isDone;
        if (this.state == 0) {
            Drawable drawable2 = this.start;
            if (drawable2 != null) {
                Drawable drawable3;
                Drawable $this$draw_u24lambda_u242 = drawable3 = drawable2;
                boolean bl = false;
                $this$draw_u24lambda_u242.setAlpha(this.maxAlpha);
                Canvas $this$withSave$iv2 = canvas;
                boolean $i$f$withSave2 = false;
                int checkpoint$iv2 = $this$withSave$iv2.save();
                try {
                    Canvas $this$draw_u24lambda_u242_u24lambda_u241 = $this$withSave$iv2;
                    boolean bl2 = false;
                    $this$draw_u24lambda_u242.draw(canvas);
                }
                finally {
                    $this$withSave$iv2.restoreToCount(checkpoint$iv2);
                }
            }
            return;
        }
        if (this.state == 2) {
            Drawable drawable4 = this.end;
            if (drawable4 != null) {
                Drawable drawable5;
                Drawable $this$draw_u24lambda_u244 = drawable5 = drawable4;
                boolean bl = false;
                $this$draw_u24lambda_u244.setAlpha(this.maxAlpha);
                Canvas $this$withSave$iv3 = canvas;
                boolean $i$f$withSave3 = false;
                int checkpoint$iv3 = $this$withSave$iv3.save();
                try {
                    Canvas $this$draw_u24lambda_u244_u24lambda_u243 = $this$withSave$iv3;
                    boolean bl3 = false;
                    $this$draw_u24lambda_u244.draw(canvas);
                }
                finally {
                    $this$withSave$iv3.restoreToCount(checkpoint$iv3);
                }
            }
            return;
        }
        double percent = (double)(SystemClock.uptimeMillis() - this.startTimeMillis) / (double)this.durationMillis;
        int endAlpha = (int)(RangesKt.coerceIn((double)percent, (double)0.0, (double)1.0) * (double)this.maxAlpha);
        int startAlpha = this.fadeStart ? this.maxAlpha - endAlpha : this.maxAlpha;
        boolean bl = isDone = percent >= 1.0;
        if (!isDone) {
            Drawable drawable6 = this.start;
            if (drawable6 != null) {
                Drawable $this$draw_u24lambda_u246 = drawable = drawable6;
                boolean bl4 = false;
                $this$draw_u24lambda_u246.setAlpha(startAlpha);
                $this$withSave$iv = canvas;
                $i$f$withSave = false;
                checkpoint$iv = $this$withSave$iv.save();
                try {
                    Canvas $this$draw_u24lambda_u246_u24lambda_u245 = $this$withSave$iv;
                    boolean bl5 = false;
                    $this$draw_u24lambda_u246.draw(canvas);
                }
                finally {
                    $this$withSave$iv.restoreToCount(checkpoint$iv);
                }
            }
        }
        Drawable drawable7 = this.end;
        if (drawable7 != null) {
            Drawable $this$draw_u24lambda_u248 = drawable = drawable7;
            boolean bl6 = false;
            $this$draw_u24lambda_u248.setAlpha(endAlpha);
            $this$withSave$iv = canvas;
            $i$f$withSave = false;
            checkpoint$iv = $this$withSave$iv.save();
            try {
                Canvas $this$draw_u24lambda_u248_u24lambda_u247 = $this$withSave$iv;
                boolean bl7 = false;
                $this$draw_u24lambda_u248.draw(canvas);
            }
            finally {
                $this$withSave$iv.restoreToCount(checkpoint$iv);
            }
        }
        if (isDone) {
            this.markDone();
        } else {
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.maxAlpha;
    }

    public void setAlpha(int alpha) {
        if (!(0 <= alpha ? alpha < 256 : false)) {
            boolean bl = false;
            String string = "Invalid alpha: " + alpha;
            throw new IllegalArgumentException(string.toString());
        }
        this.maxAlpha = alpha;
    }

    @Deprecated(message="Deprecated in Java")
    public int getOpacity() {
        int n;
        Drawable start = this.start;
        Drawable end = this.end;
        if (this.state == 0) {
            Drawable drawable = start;
            return drawable != null ? drawable.getOpacity() : -2;
        }
        if (this.state == 2) {
            Drawable drawable = end;
            return drawable != null ? drawable.getOpacity() : -2;
        }
        if (start != null && end != null) {
            n = Drawable.resolveOpacity((int)start.getOpacity(), (int)end.getOpacity());
        } else {
            Drawable drawable = start;
            if (drawable != null) {
                n = drawable.getOpacity();
            } else {
                Drawable drawable2 = end;
                n = drawable2 != null ? drawable2.getOpacity() : -2;
            }
        }
        return n;
    }

    @Nullable
    public ColorFilter getColorFilter() {
        Drawable drawable;
        switch (this.state) {
            case 0: {
                Drawable drawable2 = this.start;
                if (drawable2 != null) {
                    drawable = drawable2.getColorFilter();
                    break;
                }
                drawable = null;
                break;
            }
            case 1: {
                drawable = this.end;
                if (drawable != null && (drawable = drawable.getColorFilter()) != null) break;
                Drawable drawable3 = this.start;
                if (drawable3 != null) {
                    drawable = drawable3.getColorFilter();
                    break;
                }
                drawable = null;
                break;
            }
            case 2: {
                Drawable drawable4 = this.end;
                if (drawable4 != null) {
                    drawable = drawable4.getColorFilter();
                    break;
                }
                drawable = null;
                break;
            }
            default: {
                drawable = null;
            }
        }
        return drawable;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        block1: {
            Drawable drawable = this.start;
            if (drawable != null) {
                drawable.setColorFilter(colorFilter);
            }
            Drawable drawable2 = this.end;
            if (drawable2 == null) break block1;
            drawable2.setColorFilter(colorFilter);
        }
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        block1: {
            Drawable it;
            Drawable drawable = this.start;
            if (drawable != null) {
                it = drawable;
                boolean bl = false;
                this.updateBounds$coil_base_release(it, bounds);
            }
            Drawable drawable2 = this.end;
            if (drawable2 == null) break block1;
            it = drawable2;
            boolean bl = false;
            this.updateBounds$coil_base_release(it, bounds);
        }
    }

    protected boolean onLevelChange(int level) {
        Drawable drawable = this.start;
        boolean startChanged = drawable != null ? drawable.setLevel(level) : false;
        Drawable drawable2 = this.end;
        boolean endChanged = drawable2 != null ? drawable2.setLevel(level) : false;
        return startChanged || endChanged;
    }

    protected boolean onStateChange(@NotNull int[] state) {
        Drawable drawable = this.start;
        boolean startChanged = drawable != null ? drawable.setState(state) : false;
        Drawable drawable2 = this.end;
        boolean endChanged = drawable2 != null ? drawable2.setState(state) : false;
        return startChanged || endChanged;
    }

    public int getIntrinsicWidth() {
        return this.intrinsicWidth;
    }

    public int getIntrinsicHeight() {
        return this.intrinsicHeight;
    }

    public void unscheduleDrawable(@NotNull Drawable who, @NotNull Runnable what) {
        this.unscheduleSelf(what);
    }

    public void invalidateDrawable(@NotNull Drawable who) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(@NotNull Drawable who, @NotNull Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    public void setTint(int tintColor) {
        block1: {
            Drawable drawable = this.start;
            if (drawable != null) {
                drawable.setTint(tintColor);
            }
            Drawable drawable2 = this.end;
            if (drawable2 == null) break block1;
            drawable2.setTint(tintColor);
        }
    }

    public void setTintList(@Nullable ColorStateList tint) {
        block1: {
            Drawable drawable = this.start;
            if (drawable != null) {
                drawable.setTintList(tint);
            }
            Drawable drawable2 = this.end;
            if (drawable2 == null) break block1;
            drawable2.setTintList(tint);
        }
    }

    public void setTintMode(@Nullable PorterDuff.Mode tintMode) {
        block1: {
            Drawable drawable = this.start;
            if (drawable != null) {
                drawable.setTintMode(tintMode);
            }
            Drawable drawable2 = this.end;
            if (drawable2 == null) break block1;
            drawable2.setTintMode(tintMode);
        }
    }

    @RequiresApi(value=29)
    public void setTintBlendMode(@Nullable BlendMode blendMode) {
        block1: {
            Drawable drawable = this.start;
            if (drawable != null) {
                drawable.setTintBlendMode(blendMode);
            }
            Drawable drawable2 = this.end;
            if (drawable2 == null) break block1;
            drawable2.setTintBlendMode(blendMode);
        }
    }

    public boolean isRunning() {
        return this.state == 1;
    }

    public void start() {
        Drawable drawable = this.start;
        Animatable animatable = drawable instanceof Animatable ? (Animatable)drawable : null;
        if (animatable != null) {
            animatable.start();
        }
        drawable = this.end;
        Animatable animatable2 = drawable instanceof Animatable ? (Animatable)drawable : null;
        if (animatable2 != null) {
            animatable2.start();
        }
        if (this.state != 0) {
            return;
        }
        this.state = 1;
        this.startTimeMillis = SystemClock.uptimeMillis();
        List<Animatable2Compat.AnimationCallback> $this$forEachIndices$iv = this.callbacks;
        boolean $i$f$forEachIndices = false;
        int n = ((Collection)$this$forEachIndices$iv).size();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            Animatable2Compat.AnimationCallback it = $this$forEachIndices$iv.get(i$iv);
            boolean bl = false;
            it.onAnimationStart((Drawable)this);
        }
        this.invalidateSelf();
    }

    public void stop() {
        Drawable drawable = this.start;
        Animatable animatable = drawable instanceof Animatable ? (Animatable)drawable : null;
        if (animatable != null) {
            animatable.stop();
        }
        drawable = this.end;
        Animatable animatable2 = drawable instanceof Animatable ? (Animatable)drawable : null;
        if (animatable2 != null) {
            animatable2.stop();
        }
        if (this.state != 2) {
            this.markDone();
        }
    }

    public void registerAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        this.callbacks.add(callback);
    }

    public boolean unregisterAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        return this.callbacks.remove(callback);
    }

    public void clearAnimationCallbacks() {
        this.callbacks.clear();
    }

    @VisibleForTesting
    public final void updateBounds$coil_base_release(@NotNull Drawable drawable, @NotNull Rect targetBounds) {
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        if (width <= 0 || height <= 0) {
            drawable.setBounds(targetBounds);
            return;
        }
        int targetWidth = targetBounds.width();
        int targetHeight = targetBounds.height();
        double multiplier = DecodeUtils.computeSizeMultiplier(width, height, targetWidth, targetHeight, this.scale);
        int dx = MathKt.roundToInt((double)(((double)targetWidth - multiplier * (double)width) / (double)2));
        int dy = MathKt.roundToInt((double)(((double)targetHeight - multiplier * (double)height) / (double)2));
        int left = targetBounds.left + dx;
        int top = targetBounds.top + dy;
        int right = targetBounds.right - dx;
        int bottom = targetBounds.bottom - dy;
        drawable.setBounds(left, top, right, bottom);
    }

    private final int computeIntrinsicDimension(Integer startSize, Integer endSize) {
        block2: {
            block3: {
                if (this.preferExactIntrinsicSize) break block2;
                Integer n = startSize;
                int n2 = -1;
                if (n != null && n == n2) break block3;
                Integer n3 = endSize;
                n2 = -1;
                if (n3 == null || n3 != n2) break block2;
            }
            return -1;
        }
        Integer n = startSize;
        Integer n4 = endSize;
        return Math.max(n != null ? n : -1, n4 != null ? n4 : -1);
    }

    private final void markDone() {
        this.state = 2;
        this.start = null;
        List<Animatable2Compat.AnimationCallback> $this$forEachIndices$iv = this.callbacks;
        boolean $i$f$forEachIndices = false;
        int n = ((Collection)$this$forEachIndices$iv).size();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            Animatable2Compat.AnimationCallback it = $this$forEachIndices$iv.get(i$iv);
            boolean bl = false;
            it.onAnimationEnd((Drawable)this);
        }
    }

    @JvmOverloads
    public CrossfadeDrawable(@Nullable Drawable start, @Nullable Drawable end, @NotNull Scale scale, int durationMillis, boolean fadeStart) {
        this(start, end, scale, durationMillis, fadeStart, false, 32, null);
    }

    @JvmOverloads
    public CrossfadeDrawable(@Nullable Drawable start, @Nullable Drawable end, @NotNull Scale scale, int durationMillis) {
        this(start, end, scale, durationMillis, false, false, 48, null);
    }

    @JvmOverloads
    public CrossfadeDrawable(@Nullable Drawable start, @Nullable Drawable end, @NotNull Scale scale) {
        this(start, end, scale, 0, false, false, 56, null);
    }

    @JvmOverloads
    public CrossfadeDrawable(@Nullable Drawable start, @Nullable Drawable end) {
        this(start, end, null, 0, false, false, 60, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcoil/drawable/CrossfadeDrawable$Companion;", "", "<init>", "()V", "STATE_START", "", "STATE_RUNNING", "STATE_DONE", "DEFAULT_DURATION", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

