/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import coil.ImageLoader;
import coil.decode.DecodeResult;
import coil.decode.DecodeUtils;
import coil.decode.Decoder;
import coil.decode.ImageSource;
import coil.decode.SvgDecodeUtils;
import coil.fetch.SourceResult;
import coil.request.Options;
import coil.request.Svgs;
import coil.size.-Sizes;
import coil.size.Dimension;
import coil.size.Scale;
import coil.size.Size;
import coil.util.-SvgUtils;
import com.caverock.androidsvg.RenderOptions;
import com.caverock.androidsvg.SVG;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlinx.coroutines.InterruptibleKt;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ,\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lcoil/decode/SvgDecoder;", "Lcoil/decode/Decoder;", "source", "Lcoil/decode/ImageSource;", "options", "Lcoil/request/Options;", "useViewBoundsAsIntrinsicSize", "", "(Lcoil/decode/ImageSource;Lcoil/request/Options;Z)V", "getUseViewBoundsAsIntrinsicSize", "()Z", "decode", "Lcoil/decode/DecodeResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDstSize", "Lkotlin/Pair;", "", "srcWidth", "srcHeight", "scale", "Lcoil/size/Scale;", "Companion", "Factory", "coil-svg_release"})
public final class SvgDecoder
implements Decoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageSource source;
    @NotNull
    private final Options options;
    private final boolean useViewBoundsAsIntrinsicSize;
    @NotNull
    private static final String MIME_TYPE_SVG = "image/svg+xml";
    private static final float DEFAULT_SIZE = 512.0f;
    @NotNull
    public static final String CSS_KEY = "coil#css";

    @JvmOverloads
    public SvgDecoder(@NotNull ImageSource source, @NotNull Options options, boolean useViewBoundsAsIntrinsicSize) {
        this.source = source;
        this.options = options;
        this.useViewBoundsAsIntrinsicSize = useViewBoundsAsIntrinsicSize;
    }

    public /* synthetic */ SvgDecoder(ImageSource imageSource, Options options, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(imageSource, options, bl);
    }

    public final boolean getUseViewBoundsAsIntrinsicSize() {
        return this.useViewBoundsAsIntrinsicSize;
    }

    @Nullable
    public Object decode(@NotNull Continuation<? super DecodeResult> $completion) {
        return InterruptibleKt.runInterruptible$default(null, (Function0)((Function0)new Function0<DecodeResult>(this){
            final /* synthetic */ SvgDecoder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final DecodeResult invoke() {
                void $this$toDrawable$iv;
                RenderOptions renderOptions;
                Closeable closeable = (Closeable)SvgDecoder.access$getSource$p(this.this$0).source();
                Throwable throwable = null;
                try {
                    BufferedSource it = (BufferedSource)closeable;
                    boolean bl = false;
                    it = SVG.getFromInputStream((InputStream)it.inputStream());
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                BufferedSource svg = it;
                float svgWidth = 0.0f;
                float svgHeight = 0.0f;
                RectF viewBox = svg.getDocumentViewBox();
                if (this.this$0.getUseViewBoundsAsIntrinsicSize() && viewBox != null) {
                    svgWidth = viewBox.width();
                    svgHeight = viewBox.height();
                } else {
                    svgWidth = svg.getDocumentWidth();
                    svgHeight = svg.getDocumentHeight();
                }
                int bitmapWidth = 0;
                int bitmapHeight = 0;
                Pair pair = SvgDecoder.access$getDstSize(this.this$0, svgWidth, svgHeight, SvgDecoder.access$getOptions$p(this.this$0).getScale());
                float dstWidth = ((Number)pair.component1()).floatValue();
                float dstHeight = ((Number)pair.component2()).floatValue();
                if (svgWidth > 0.0f && svgHeight > 0.0f) {
                    float multiplier = DecodeUtils.computeSizeMultiplier((float)svgWidth, (float)svgHeight, (float)dstWidth, (float)dstHeight, (Scale)SvgDecoder.access$getOptions$p(this.this$0).getScale());
                    bitmapWidth = (int)(multiplier * svgWidth);
                    bitmapHeight = (int)(multiplier * svgHeight);
                } else {
                    bitmapWidth = MathKt.roundToInt((float)dstWidth);
                    bitmapHeight = MathKt.roundToInt((float)dstHeight);
                }
                if (viewBox == null && svgWidth > 0.0f && svgHeight > 0.0f) {
                    svg.setDocumentViewBox(0.0f, 0.0f, svgWidth, svgHeight);
                }
                svg.setDocumentWidth("100%");
                svg.setDocumentHeight("100%");
                Bitmap.Config config$iv = -SvgUtils.toSoftware(SvgDecoder.access$getOptions$p(this.this$0).getConfig());
                boolean $i$f$createBitmap22 = false;
                Bitmap bitmap = Bitmap.createBitmap((int)bitmapWidth, (int)bitmapHeight, (Bitmap.Config)config$iv);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(width, height, config)");
                Bitmap bitmap2 = bitmap;
                String string = Svgs.css(SvgDecoder.access$getOptions$p(this.this$0).getParameters());
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    renderOptions = new RenderOptions().css(it);
                } else {
                    renderOptions = null;
                }
                RenderOptions renderOptions2 = renderOptions;
                svg.renderToCanvas(new Canvas(bitmap2), renderOptions2);
                Bitmap $i$f$createBitmap22 = bitmap2;
                Resources resources$iv = SvgDecoder.access$getOptions$p(this.this$0).getContext().getResources();
                boolean $i$f$toDrawable = false;
                return new DecodeResult((Drawable)new BitmapDrawable(resources$iv, (Bitmap)$this$toDrawable$iv), true);
            }
        }), $completion, (int)1, null);
    }

    private final Pair<Float, Float> getDstSize(float srcWidth, float srcHeight, Scale scale) {
        if (-Sizes.isOriginal((Size)this.options.getSize())) {
            float dstWidth = srcWidth > 0.0f ? srcWidth : 512.0f;
            float dstHeight = srcHeight > 0.0f ? srcHeight : 512.0f;
            return TuplesKt.to((Object)Float.valueOf(dstWidth), (Object)Float.valueOf(dstHeight));
        }
        Size size = this.options.getSize();
        Dimension dstWidth = size.component1();
        Dimension dstHeight = size.component2();
        return TuplesKt.to((Object)Float.valueOf(-SvgUtils.toPx(dstWidth, scale)), (Object)Float.valueOf(-SvgUtils.toPx(dstHeight, scale)));
    }

    @JvmOverloads
    public SvgDecoder(@NotNull ImageSource source, @NotNull Options options) {
        this(source, options, false, 4, null);
    }

    public static final /* synthetic */ ImageSource access$getSource$p(SvgDecoder $this) {
        return $this.source;
    }

    public static final /* synthetic */ Pair access$getDstSize(SvgDecoder $this, float srcWidth, float srcHeight, Scale scale) {
        return $this.getDstSize(srcWidth, srcHeight, scale);
    }

    public static final /* synthetic */ Options access$getOptions$p(SvgDecoder $this) {
        return $this.options;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcoil/decode/SvgDecoder$Companion;", "", "()V", "CSS_KEY", "", "DEFAULT_SIZE", "", "MIME_TYPE_SVG", "coil-svg_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcoil/decode/SvgDecoder$Factory;", "Lcoil/decode/Decoder$Factory;", "useViewBoundsAsIntrinsicSize", "", "(Z)V", "getUseViewBoundsAsIntrinsicSize", "()Z", "create", "Lcoil/decode/Decoder;", "result", "Lcoil/fetch/SourceResult;", "options", "Lcoil/request/Options;", "imageLoader", "Lcoil/ImageLoader;", "equals", "other", "", "hashCode", "", "isApplicable", "coil-svg_release"})
    public static final class Factory
    implements Decoder.Factory {
        private final boolean useViewBoundsAsIntrinsicSize;

        @JvmOverloads
        public Factory(boolean useViewBoundsAsIntrinsicSize) {
            this.useViewBoundsAsIntrinsicSize = useViewBoundsAsIntrinsicSize;
        }

        public /* synthetic */ Factory(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            this(bl);
        }

        public final boolean getUseViewBoundsAsIntrinsicSize() {
            return this.useViewBoundsAsIntrinsicSize;
        }

        @Nullable
        public Decoder create(@NotNull SourceResult result, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            if (!this.isApplicable(result)) {
                return null;
            }
            return new SvgDecoder(result.getSource(), options, this.useViewBoundsAsIntrinsicSize);
        }

        private final boolean isApplicable(SourceResult result) {
            return Intrinsics.areEqual((Object)result.getMimeType(), (Object)SvgDecoder.MIME_TYPE_SVG) || SvgDecodeUtils.isSvg(DecodeUtils.INSTANCE, result.getSource().source());
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Factory && this.useViewBoundsAsIntrinsicSize == ((Factory)other).useViewBoundsAsIntrinsicSize;
        }

        public int hashCode() {
            return Boolean.hashCode(this.useViewBoundsAsIntrinsicSize);
        }

        @JvmOverloads
        public Factory() {
            this(false, 1, null);
        }
    }
}

