/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import coil.ImageLoader;
import coil.decode.DecodeResult;
import coil.decode.DecodeUtils;
import coil.decode.Decoder;
import coil.decode.ImageSource;
import coil.decode.SvgDecodeUtils;
import coil.fetch.SourceResult;
import coil.request.Options;
import coil.request.Svgs;
import coil.size.-Sizes;
import coil.size.Dimension;
import coil.size.Scale;
import coil.size.Size;
import coil.util.-SvgUtils;
import com.caverock.androidsvg.RenderOptions;
import com.caverock.androidsvg.SVG;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.InterruptibleKt;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ,\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcoil/decode/SvgDecoder;", "Lcoil/decode/Decoder;", "source", "Lcoil/decode/ImageSource;", "options", "Lcoil/request/Options;", "useViewBoundsAsIntrinsicSize", "", "<init>", "(Lcoil/decode/ImageSource;Lcoil/request/Options;Z)V", "getUseViewBoundsAsIntrinsicSize", "()Z", "decode", "Lcoil/decode/DecodeResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDstSize", "Lkotlin/Pair;", "", "srcWidth", "srcHeight", "scale", "Lcoil/size/Scale;", "Factory", "Companion", "coil-svg_release"})
@SourceDebugExtension(value={"SMAP\nSvgDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvgDecoder.kt\ncoil/decode/SvgDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Bitmap.kt\nandroidx/core/graphics/BitmapKt\n+ 4 BitmapDrawable.kt\nandroidx/core/graphics/drawable/BitmapDrawableKt\n*L\n1#1,122:1\n1#2:123\n95#3:124\n28#4:125\n*S KotlinDebug\n*F\n+ 1 SvgDecoder.kt\ncoil/decode/SvgDecoder\n*L\n73#1:124\n78#1:125\n*E\n"})
public final class SvgDecoder
implements Decoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageSource source;
    @NotNull
    private final Options options;
    private final boolean useViewBoundsAsIntrinsicSize;
    @NotNull
    private static final String MIME_TYPE_SVG = "image/svg+xml";
    private static final float DEFAULT_SIZE = 512.0f;
    @NotNull
    public static final String CSS_KEY = "coil#css";

    @JvmOverloads
    public SvgDecoder(@NotNull ImageSource source, @NotNull Options options, boolean useViewBoundsAsIntrinsicSize) {
        this.source = source;
        this.options = options;
        this.useViewBoundsAsIntrinsicSize = useViewBoundsAsIntrinsicSize;
    }

    public /* synthetic */ SvgDecoder(ImageSource imageSource, Options options, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(imageSource, options, bl);
    }

    public final boolean getUseViewBoundsAsIntrinsicSize() {
        return this.useViewBoundsAsIntrinsicSize;
    }

    @Nullable
    public Object decode(@NotNull Continuation<? super DecodeResult> $completion) {
        return InterruptibleKt.runInterruptible$default(null, () -> SvgDecoder.decode$lambda$2(this), $completion, (int)1, null);
    }

    private final Pair<Float, Float> getDstSize(float srcWidth, float srcHeight, Scale scale) {
        if (-Sizes.isOriginal((Size)this.options.getSize())) {
            float dstWidth = srcWidth > 0.0f ? srcWidth : 512.0f;
            float dstHeight = srcHeight > 0.0f ? srcHeight : 512.0f;
            return TuplesKt.to((Object)Float.valueOf(dstWidth), (Object)Float.valueOf(dstHeight));
        }
        Size size = this.options.getSize();
        Dimension dstWidth = size.component1();
        Dimension dstHeight = size.component2();
        return TuplesKt.to((Object)Float.valueOf(-SvgUtils.toPx(dstWidth, scale)), (Object)Float.valueOf(-SvgUtils.toPx(dstHeight, scale)));
    }

    @JvmOverloads
    public SvgDecoder(@NotNull ImageSource source, @NotNull Options options) {
        this(source, options, false, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final DecodeResult decode$lambda$2(SvgDecoder this$0) {
        void $this$toDrawable$iv;
        RenderOptions renderOptions;
        Closeable closeable = (Closeable)this$0.source.source();
        Throwable throwable = null;
        try {
            BufferedSource it = (BufferedSource)closeable;
            boolean bl = false;
            it = SVG.getFromInputStream((InputStream)it.inputStream());
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        BufferedSource svg = it;
        float svgWidth = 0.0f;
        float svgHeight = 0.0f;
        RectF viewBox = svg.getDocumentViewBox();
        if (this$0.useViewBoundsAsIntrinsicSize && viewBox != null) {
            svgWidth = viewBox.width();
            svgHeight = viewBox.height();
        } else {
            svgWidth = svg.getDocumentWidth();
            svgHeight = svg.getDocumentHeight();
        }
        int bitmapWidth = 0;
        int bitmapHeight = 0;
        Pair<Float, Float> pair = this$0.getDstSize(svgWidth, svgHeight, this$0.options.getScale());
        float dstWidth = ((Number)pair.component1()).floatValue();
        float dstHeight = ((Number)pair.component2()).floatValue();
        if (svgWidth > 0.0f && svgHeight > 0.0f) {
            float multiplier = DecodeUtils.computeSizeMultiplier((float)svgWidth, (float)svgHeight, (float)dstWidth, (float)dstHeight, (Scale)this$0.options.getScale());
            bitmapWidth = (int)(multiplier * svgWidth);
            bitmapHeight = (int)(multiplier * svgHeight);
        } else {
            bitmapWidth = MathKt.roundToInt((float)dstWidth);
            bitmapHeight = MathKt.roundToInt((float)dstHeight);
        }
        if (viewBox == null && svgWidth > 0.0f && svgHeight > 0.0f) {
            svg.setDocumentViewBox(0.0f, 0.0f, svgWidth, svgHeight);
        }
        svg.setDocumentWidth("100%");
        svg.setDocumentHeight("100%");
        Bitmap.Config config$iv = -SvgUtils.toSoftware(this$0.options.getConfig());
        boolean $i$f$createBitmap22 = false;
        Bitmap bitmap = Bitmap.createBitmap((int)bitmapWidth, (int)bitmapHeight, (Bitmap.Config)config$iv);
        String string = Svgs.css(this$0.options.getParameters());
        if (string != null) {
            String it = string;
            boolean bl = false;
            renderOptions = new RenderOptions().css(it);
        } else {
            renderOptions = null;
        }
        RenderOptions renderOptions2 = renderOptions;
        svg.renderToCanvas(new Canvas(bitmap), renderOptions2);
        Bitmap $i$f$createBitmap22 = bitmap;
        Resources resources$iv = this$0.options.getContext().getResources();
        boolean $i$f$toDrawable = false;
        return new DecodeResult((Drawable)new BitmapDrawable(resources$iv, (Bitmap)$this$toDrawable$iv), true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcoil/decode/SvgDecoder$Companion;", "", "<init>", "()V", "MIME_TYPE_SVG", "", "DEFAULT_SIZE", "", "CSS_KEY", "coil-svg_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0013\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcoil/decode/SvgDecoder$Factory;", "Lcoil/decode/Decoder$Factory;", "useViewBoundsAsIntrinsicSize", "", "<init>", "(Z)V", "getUseViewBoundsAsIntrinsicSize", "()Z", "create", "Lcoil/decode/Decoder;", "result", "Lcoil/fetch/SourceResult;", "options", "Lcoil/request/Options;", "imageLoader", "Lcoil/ImageLoader;", "isApplicable", "equals", "other", "", "hashCode", "", "coil-svg_release"})
    public static final class Factory
    implements Decoder.Factory {
        private final boolean useViewBoundsAsIntrinsicSize;

        @JvmOverloads
        public Factory(boolean useViewBoundsAsIntrinsicSize) {
            this.useViewBoundsAsIntrinsicSize = useViewBoundsAsIntrinsicSize;
        }

        public /* synthetic */ Factory(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            this(bl);
        }

        public final boolean getUseViewBoundsAsIntrinsicSize() {
            return this.useViewBoundsAsIntrinsicSize;
        }

        @Nullable
        public Decoder create(@NotNull SourceResult result, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            if (!this.isApplicable(result)) {
                return null;
            }
            return new SvgDecoder(result.getSource(), options, this.useViewBoundsAsIntrinsicSize);
        }

        private final boolean isApplicable(SourceResult result) {
            return Intrinsics.areEqual((Object)result.getMimeType(), (Object)SvgDecoder.MIME_TYPE_SVG) || SvgDecodeUtils.isSvg(DecodeUtils.INSTANCE, result.getSource().source());
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Factory && this.useViewBoundsAsIntrinsicSize == ((Factory)other).useViewBoundsAsIntrinsicSize;
        }

        public int hashCode() {
            return Boolean.hashCode(this.useViewBoundsAsIntrinsicSize);
        }

        @JvmOverloads
        public Factory() {
            this(false, 1, null);
        }
    }
}

