[coil-base](../../index.md) / [coil.collection](../index.md) / [SparseIntArraySet](./index.md)

# SparseIntArraySet

`class SparseIntArraySet`

A collection of unordered, unique [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)s.

This data structure is intended to be more memory efficient than using a [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html) to store [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)s, both
because it avoids auto-boxing elements and it doesn't allocate a hash table.

**See Also**

[SparseIntArray](https://developer.android.com/reference/android/util/SparseIntArray.html)

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | A collection of unordered, unique [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)s.`SparseIntArraySet(initialCapacity: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 10)` |

### Properties

| Name | Summary |
|---|---|
| [size](size.md) | Returns the number of elements that this set currently stores.`val size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |

### Functions

| Name | Summary |
|---|---|
| [add](add.md) | Adds the element to the set.`fun add(element: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [clear](clear.md) | Removes all elements from this set.`fun clear(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [contains](contains.md) | Return true if the set contains this element.`operator fun contains(element: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [elementAt](element-at.md) | Given an index in the range `[0, size)`, returns the element from the `index`th key-value mapping that this set stores.`fun elementAt(index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [indexOfElement](index-of-element.md) | Returns the index for which [elementAt](element-at.md) would return the specified element, or a negative number if the specified element is not mapped.`fun indexOfElement(element: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [remove](remove.md) | Removes the element from the set. Return true if it was present.`fun remove(element: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [removeAt](remove-at.md) | Removes the element at the given index.`fun removeAt(index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Extension Functions

| Name | Summary |
|---|---|
| [addAll](../../coil.extension/add-all.md) | Add all elements from [other](../../coil.extension/add-all.md#coil.extension$addAll(coil.collection.SparseIntArraySet, coil.collection.SparseIntArraySet)/other) to [this](../../coil.extension/add-all/-this-.md).`fun `[`SparseIntArraySet`](./index.md)`.addAll(other: `[`SparseIntArraySet`](./index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [count](../../coil.extension/count.md) | Returns the number of elements that this set currently stores.`fun `[`SparseIntArraySet`](./index.md)`.count(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [forEach](../../coil.extension/for-each.md) | Performs the given [action](../../coil.extension/for-each.md#coil.extension$forEach(coil.collection.SparseIntArraySet, kotlin.Function1((kotlin.Int, kotlin.Unit)))/action) for each element in the set.`fun `[`SparseIntArraySet`](./index.md)`.forEach(action: (element: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [isEmpty](../../coil.extension/is-empty.md) | Return true when the set contains no elements.`fun `[`SparseIntArraySet`](./index.md)`.isEmpty(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isNotEmpty](../../coil.extension/is-not-empty.md) | Return true when the set contains elements.`fun `[`SparseIntArraySet`](./index.md)`.isNotEmpty(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [iterator](../../coil.extension/iterator.md) | Return an iterator over the set's values.`operator fun `[`SparseIntArraySet`](./index.md)`.iterator(): `[`IntIterator`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-int-iterator/index.html) |
| [minusAssign](../../coil.extension/minus-assign.md) | Removes the element from the set.`operator fun `[`SparseIntArraySet`](./index.md)`.minusAssign(element: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [plus](../../coil.extension/plus.md) | Create and return a new set that contains the elements of [this](../../coil.extension/plus/-this-.md) plus the elements of [other](../../coil.extension/plus.md#coil.extension$plus(coil.collection.SparseIntArraySet, coil.collection.SparseIntArraySet)/other).`operator fun `[`SparseIntArraySet`](./index.md)`.plus(other: `[`SparseIntArraySet`](./index.md)`): `[`SparseIntArraySet`](./index.md) |
| [plusAssign](../../coil.extension/plus-assign.md) | Adds the element to the set.`operator fun `[`SparseIntArraySet`](./index.md)`.plusAssign(element: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
