[coil-base](../../index.md) / [coil.decode](../index.md) / [DataSource](./index.md)

# DataSource

`enum class DataSource`

Represents the source that an image was loaded from.

**See Also**

[SourceResult.dataSource](../../coil.fetch/-source-result/data-source.md)

[DrawableResult.dataSource](../../coil.fetch/-drawable-result/data-source.md)

### Enum Values

| Name | Summary |
|---|---|
| [MEMORY_CACHE](-m-e-m-o-r-y_-c-a-c-h-e.md) | Represents an [ImageLoader](../../coil/-image-loader/index.md)'s internal memory cache. |
| [MEMORY](-m-e-m-o-r-y.md) | Represents an in-memory data source (e.g. [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html), [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)). |
| [DISK](-d-i-s-k.md) | Represents a disk-based data source (e.g. [DrawableRes](https://developer.android.com/reference/androidx/androidx/annotation/DrawableRes.html), [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html)). |
| [NETWORK](-n-e-t-w-o-r-k.md) | Represents a network-based data source (e.g. [HttpUrl](https://square.github.io/okhttp/3.x/okhttp/okhttp3/HttpUrl.html)). |
