[coil-base](../../index.md) / [coil.decode](../index.md) / [DecodeUtils](./index.md)

# DecodeUtils

`object DecodeUtils`

A collection of useful utility methods for decoding images.

### Functions

| Name | Summary |
|---|---|
| [calculateInSampleSize](calculate-in-sample-size.md) | Calculate the [BitmapFactory.Options.inSampleSize](https://developer.android.com/reference/android/graphics/BitmapFactory/Options.html#inSampleSize) given the source dimensions of the image ([srcWidth](calculate-in-sample-size.md#coil.decode.DecodeUtils$calculateInSampleSize(kotlin.Int, kotlin.Int, kotlin.Int, kotlin.Int, coil.size.Scale)/srcWidth) and [srcHeight](calculate-in-sample-size.md#coil.decode.DecodeUtils$calculateInSampleSize(kotlin.Int, kotlin.Int, kotlin.Int, kotlin.Int, coil.size.Scale)/srcHeight)), the output dimensions ([dstWidth](calculate-in-sample-size.md#coil.decode.DecodeUtils$calculateInSampleSize(kotlin.Int, kotlin.Int, kotlin.Int, kotlin.Int, coil.size.Scale)/dstWidth), [dstHeight](calculate-in-sample-size.md#coil.decode.DecodeUtils$calculateInSampleSize(kotlin.Int, kotlin.Int, kotlin.Int, kotlin.Int, coil.size.Scale)/dstHeight)), and the [scale](calculate-in-sample-size.md#coil.decode.DecodeUtils$calculateInSampleSize(kotlin.Int, kotlin.Int, kotlin.Int, kotlin.Int, coil.size.Scale)/scale).`fun calculateInSampleSize(srcWidth: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, srcHeight: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, dstWidth: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, dstHeight: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, scale: `[`Scale`](../../coil.size/-scale/index.md)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [computePixelSize](compute-pixel-size.md) | Calculate the pixel size required to fit/fill the source dimensions inside the destination size while preserving aspect ratio.`fun computePixelSize(srcWidth: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, srcHeight: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, dstSize: `[`Size`](../../coil.size/-size.md)`, scale: `[`Scale`](../../coil.size/-scale/index.md)`): `[`PixelSize`](../../coil.size/-pixel-size/index.md) |
| [computeSizeMultiplier](compute-size-multiplier.md) | Calculate the percentage to multiply the source dimensions by to fit/fill the destination dimensions while preserving aspect ratio.`fun computeSizeMultiplier(srcWidth: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, srcHeight: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, dstWidth: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, dstHeight: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, scale: `[`Scale`](../../coil.size/-scale/index.md)`): `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`fun computeSizeMultiplier(srcWidth: `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)`, srcHeight: `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)`, dstWidth: `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)`, dstHeight: `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)`, scale: `[`Scale`](../../coil.size/-scale/index.md)`): `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)<br>`fun computeSizeMultiplier(srcWidth: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`, srcHeight: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`, dstWidth: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`, dstHeight: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`, scale: `[`Scale`](../../coil.size/-scale/index.md)`): `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html) |
| [isAnimatedHeif](is-animated-heif.md) | Return true if the [source](is-animated-heif.md#coil.decode.DecodeUtils$isAnimatedHeif(okio.BufferedSource)/source) contains an animated HEIF image sequence. The [source](is-animated-heif.md#coil.decode.DecodeUtils$isAnimatedHeif(okio.BufferedSource)/source) is not consumed.`fun isAnimatedHeif(source: `[`BufferedSource`](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isAnimatedWebP](is-animated-web-p.md) | Return true if the [source](is-animated-web-p.md#coil.decode.DecodeUtils$isAnimatedWebP(okio.BufferedSource)/source) contains an animated WebP image. The [source](is-animated-web-p.md#coil.decode.DecodeUtils$isAnimatedWebP(okio.BufferedSource)/source) is not consumed.`fun isAnimatedWebP(source: `[`BufferedSource`](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isGif](is-gif.md) | Return true if the [source](is-gif.md#coil.decode.DecodeUtils$isGif(okio.BufferedSource)/source) contains a GIF image. The [source](is-gif.md#coil.decode.DecodeUtils$isGif(okio.BufferedSource)/source) is not consumed.`fun isGif(source: `[`BufferedSource`](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isHeif](is-heif.md) | Return true if the [source](is-heif.md#coil.decode.DecodeUtils$isHeif(okio.BufferedSource)/source) contains an HEIF image. The [source](is-heif.md#coil.decode.DecodeUtils$isHeif(okio.BufferedSource)/source) is not consumed.`fun isHeif(source: `[`BufferedSource`](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isWebP](is-web-p.md) | Return true if the [source](is-web-p.md#coil.decode.DecodeUtils$isWebP(okio.BufferedSource)/source) contains a WebP image. The [source](is-web-p.md#coil.decode.DecodeUtils$isWebP(okio.BufferedSource)/source) is not consumed.`fun isWebP(source: `[`BufferedSource`](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
