[coil-base](../../index.md) / [coil.fetch](../index.md) / [Fetcher](./index.md)

# Fetcher

`interface Fetcher<T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`

A [Fetcher](./index.md) translates data into either a [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md) or a [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html).

To accomplish this, fetchers fit into one of two types:

* Uses the data as a key to fetch bytes from a remote source (e.g. network or disk)
and exposes it as a [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md). e.g. [HttpUrlFetcher](#)
* Reads the data directly and translates it into a [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html). e.g. [BitmapFetcher](#)

### Functions

| Name | Summary |
|---|---|
| [fetch](fetch.md) | Load the [data](fetch.md#coil.fetch.Fetcher$fetch(coil.bitmappool.BitmapPool, coil.fetch.Fetcher.T, coil.size.Size, coil.decode.Options)/data) into memory. Perform any necessary fetching operations.`abstract suspend fun fetch(pool: `[`BitmapPool`](../../coil.bitmappool/-bitmap-pool/index.md)`, data: T, size: `[`Size`](../../coil.size/-size.md)`, options: `[`Options`](../../coil.decode/-options/index.md)`): `[`FetchResult`](../-fetch-result.md) |
| [handles](handles.md) | Return true if this can load [data](handles.md#coil.fetch.Fetcher$handles(coil.fetch.Fetcher.T)/data).`open fun handles(data: T): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [key](key.md) | Compute the memory cache key for [data](key.md#coil.fetch.Fetcher$key(coil.fetch.Fetcher.T)/data).`abstract fun key(data: T): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
