[coil-base](../../index.md) / [coil.request](../index.md) / [LoadRequest](./index.md)

# LoadRequest

`class LoadRequest : `[`Request`](../-request/index.md)

[LoadRequest](./index.md)s asynchronously load an image into a [Target](../../coil.target/-target/index.md).

[Request.data](../-request/data.md) must be set to a non-null value or the request
will fail with [NullRequestDataException](../-null-request-data-exception/index.md) when executed.

* They are scoped to a [Lifecycle](https://developer.android.com/reference/androidx/androidx/lifecycle/Lifecycle.html). Requests aren't started until the lifecycle is at least
[Lifecycle.State.STARTED](https://developer.android.com/reference/androidx/androidx/lifecycle/Lifecycle/State.html#STARTED) and are automatically cancelled when the lifecycle is destroyed.
* When executed they return a [RequestDisposable](../-request-disposable/index.md).
* They support bitmap pooling (if [target](target.md) implements [PoolableViewTarget](../../coil.target/-poolable-view-target/index.md)).
* They support [Target](../../coil.target/-target/index.md)s, [Transition](../../coil.transition/-transition/index.md)s, and [placeholder](placeholder.md) drawables.

Example:

```
val request = LoadRequest.Builder(context)
    .data("https://www.example.com/image.jpg")
    .target(imageView)
    .build()
val disposable = imageLoader.execute(request)
```

**See Also**

[LoadRequestBuilder](../-load-request-builder/index.md)

[ImageLoader.execute](../../coil/-image-loader/execute.md)

### Properties

| Name | Summary |
|---|---|
| [aliasKeys](alias-keys.md) | `val aliasKeys: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>` |
| [allowHardware](allow-hardware.md) | `val allowHardware: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`?` |
| [allowRgb565](allow-rgb565.md) | `val allowRgb565: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`?` |
| [bitmapConfig](bitmap-config.md) | `val bitmapConfig: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html)`?` |
| [colorSpace](color-space.md) | `val colorSpace: `[`ColorSpace`](https://developer.android.com/reference/android/graphics/ColorSpace.html)`?` |
| [context](context.md) | `val context: `[`Context`](https://developer.android.com/reference/android/content/Context.html) |
| [data](data.md) | `val data: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?` |
| [decoder](decoder.md) | `val decoder: `[`Decoder`](../../coil.decode/-decoder/index.md)`?` |
| [diskCachePolicy](disk-cache-policy.md) | `val diskCachePolicy: `[`CachePolicy`](../-cache-policy/index.md)`?` |
| [dispatcher](dispatcher.md) | `val dispatcher: `[`CoroutineDispatcher`](https://kotlin.github.io/kotlinx.coroutines/kotlinx-coroutines-core/kotlinx.coroutines/-coroutine-dispatcher/index.html)`?` |
| [fetcher](fetcher.md) | `val fetcher: `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<`[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<*>, `[`Fetcher`](../../coil.fetch/-fetcher/index.md)`<*>>?` |
| [headers](headers.md) | `val headers: `[`Headers`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Headers.html) |
| [key](key.md) | `val key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [lifecycle](lifecycle.md) | `val lifecycle: `[`Lifecycle`](https://developer.android.com/reference/androidx/androidx/lifecycle/Lifecycle.html)`?` |
| [listener](listener.md) | `val listener: Listener?` |
| [memoryCachePolicy](memory-cache-policy.md) | `val memoryCachePolicy: `[`CachePolicy`](../-cache-policy/index.md)`?` |
| [networkCachePolicy](network-cache-policy.md) | `val networkCachePolicy: `[`CachePolicy`](../-cache-policy/index.md)`?` |
| [parameters](parameters.md) | `val parameters: `[`Parameters`](../-parameters/index.md) |
| [placeholder](placeholder.md) | `val placeholder: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?` |
| [precision](precision.md) | `val precision: `[`Precision`](../../coil.size/-precision/index.md)`?` |
| [scale](scale.md) | `val scale: `[`Scale`](../../coil.size/-scale/index.md)`?` |
| [sizeResolver](size-resolver.md) | `val sizeResolver: `[`SizeResolver`](../../coil.size/-size-resolver/index.md)`?` |
| [target](target.md) | `val target: `[`Target`](../../coil.target/-target/index.md)`?` |
| [transformations](transformations.md) | `val transformations: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Transformation`](../../coil.transform/-transformation/index.md)`>` |
| [transition](transition.md) | `val transition: `[`Transition`](../../coil.transition/-transition/index.md)`?` |

### Functions

| Name | Summary |
|---|---|
| [newBuilder](new-builder.md) | Create a new [LoadRequestBuilder](../-load-request-builder/index.md) instance using this as a base.`fun newBuilder(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)` = this.context): `[`LoadRequestBuilder`](../-load-request-builder/index.md) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [Builder](-builder.md) | Alias for [LoadRequestBuilder](../-load-request-builder/index.md).`fun Builder(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`): `[`LoadRequestBuilder`](../-load-request-builder/index.md)<br>`fun Builder(request: `[`LoadRequest`](./index.md)`, context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)` = request.context): `[`LoadRequestBuilder`](../-load-request-builder/index.md) |
