[coil-base](../../index.md) / [coil.request](../index.md) / [Parameters](./index.md)

# Parameters

`class Parameters : `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, Entry>>`

A map of generic values that can be used to pass custom data to [Fetcher](../../coil.fetch/-fetcher/index.md)s and [Decoder](../../coil.decode/-decoder/index.md)s.

### Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | `class Builder` |
| [Entry](-entry/index.md) | `data class Entry` |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `Parameters()` |

### Properties

| Name | Summary |
|---|---|
| [size](size.md) | Returns the number of parameters in this object.`val size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |

### Functions

| Name | Summary |
|---|---|
| [cacheKey](cache-key.md) | Returns the cache key associated with [key](cache-key.md#coil.request.Parameters$cacheKey(kotlin.String)/key) or null if [key](cache-key.md#coil.request.Parameters$cacheKey(kotlin.String)/key) has no mapping.`fun cacheKey(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [cacheKeys](cache-keys.md) | Returns a map of keys to non null cache keys. Parameters with a null cache key are filtered out.`fun cacheKeys(): `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>` |
| [entry](entry.md) | Returns the entry associated with [key](entry.md#coil.request.Parameters$entry(kotlin.String)/key) or null if [key](entry.md#coil.request.Parameters$entry(kotlin.String)/key) has no mapping.`fun entry(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): Entry?` |
| [equals](equals.md) | `fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | `fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [isEmpty](is-empty.md) | Returns true if this object has no parameters.`fun isEmpty(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [iterator](iterator.md) | Returns an [Iterator](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterator/index.html) over the entries in the [Parameters](./index.md).`operator fun iterator(): `[`Iterator`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterator/index.html)`<`[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, Entry>>` |
| [newBuilder](new-builder.md) | `fun newBuilder(): Builder` |
| [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [value](value.md) | Returns the value associated with [key](value.md#coil.request.Parameters$value(kotlin.String)/key) or null if [key](value.md#coil.request.Parameters$value(kotlin.String)/key) has no mapping.`fun value(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?` |
| [values](values.md) | Returns a map of keys to values.`fun values(): `[`Map`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?>` |

### Companion Object Properties

| Name | Summary |
|---|---|
| [EMPTY](-e-m-p-t-y.md) | `val EMPTY: `[`Parameters`](./index.md) |

### Extension Functions

| Name | Summary |
|---|---|
| [count](../../coil.extension/count.md) | Returns the number of parameters in this object.`fun `[`Parameters`](./index.md)`.count(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [get](../../coil.extension/get.md) | Returns the value associated with [key](../../coil.extension/get.md#coil.extension$get(coil.request.Parameters, kotlin.String)/key) or null if [key](../../coil.extension/get.md#coil.extension$get(coil.request.Parameters, kotlin.String)/key) has no mapping.`operator fun `[`Parameters`](./index.md)`.get(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?` |
| [isNotEmpty](../../coil.extension/is-not-empty.md) | Return true when the set contains elements.`fun `[`Parameters`](./index.md)`.isNotEmpty(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
