[coil-base](../../index.md) / [coil.request](../index.md) / [RequestBuilder](./index.md)

# RequestBuilder

`@BuilderMarker sealed class RequestBuilder<T : `[`RequestBuilder`](./index.md)`<T>>`

Base class for [LoadRequestBuilder](../-load-request-builder/index.md) and [GetRequestBuilder](../-get-request-builder/index.md).

### Properties

| Name | Summary |
|---|---|
| [aliasKeys](alias-keys.md) | `var aliasKeys: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>` |
| [allowHardware](allow-hardware.md) | `var allowHardware: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`?` |
| [allowRgb565](allow-rgb565.md) | `var allowRgb565: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`?` |
| [bitmapConfig](bitmap-config.md) | `var bitmapConfig: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html)`?` |
| [colorSpace](color-space.md) | `var colorSpace: `[`ColorSpace`](https://developer.android.com/reference/android/graphics/ColorSpace.html)`?` |
| [context](context.md) | `val context: `[`Context`](https://developer.android.com/reference/android/content/Context.html) |
| [data](data.md) | `var data: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?` |
| [decoder](decoder.md) | `var decoder: `[`Decoder`](../../coil.decode/-decoder/index.md)`?` |
| [diskCachePolicy](disk-cache-policy.md) | `var diskCachePolicy: `[`CachePolicy`](../-cache-policy/index.md)`?` |
| [dispatcher](dispatcher.md) | `var dispatcher: `[`CoroutineDispatcher`](https://kotlin.github.io/kotlinx.coroutines/kotlinx-coroutines-core/kotlinx.coroutines/-coroutine-dispatcher/index.html)`?` |
| [errorDrawable](error-drawable.md) | `var errorDrawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?` |
| [errorResId](error-res-id.md) | `var errorResId: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [fallbackDrawable](fallback-drawable.md) | `var fallbackDrawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?` |
| [fallbackResId](fallback-res-id.md) | `var fallbackResId: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [fetcher](fetcher.md) | `var fetcher: `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<`[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<*>, `[`Fetcher`](../../coil.fetch/-fetcher/index.md)`<*>>?` |
| [headers](headers.md) | `var headers: `[`Builder`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Headers/Builder.html)`?` |
| [key](key.md) | `var key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [listener](listener.md) | `var listener: Listener?` |
| [memoryCachePolicy](memory-cache-policy.md) | `var memoryCachePolicy: `[`CachePolicy`](../-cache-policy/index.md)`?` |
| [networkCachePolicy](network-cache-policy.md) | `var networkCachePolicy: `[`CachePolicy`](../-cache-policy/index.md)`?` |
| [parameters](parameters.md) | `var parameters: Builder?` |
| [precision](precision.md) | `var precision: `[`Precision`](../../coil.size/-precision/index.md)`?` |
| [scale](scale.md) | `var scale: `[`Scale`](../../coil.size/-scale/index.md)`?` |
| [sizeResolver](size-resolver.md) | `var sizeResolver: `[`SizeResolver`](../../coil.size/-size-resolver/index.md)`?` |
| [transformations](transformations.md) | `var transformations: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Transformation`](../../coil.transform/-transformation/index.md)`>` |

### Functions

| Name | Summary |
|---|---|
| [addHeader](add-header.md) | Add a header for any network operations performed by this request.`fun addHeader(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, value: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): T` |
| [aliasKeys](alias-keys.md) | Set a list of supplementary cache keys that are used to check if this request is cached in the memory cache.`fun aliasKeys(vararg aliasKeys: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): T`<br>`fun aliasKeys(aliasKeys: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>): T` |
| [allowHardware](allow-hardware.md) | Enable/disable the use of [Bitmap.Config.HARDWARE](https://developer.android.com/reference/android/graphics/Bitmap/Config.html#HARDWARE) for this request.`fun allowHardware(enable: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): T` |
| [allowRgb565](allow-rgb565.md) | `fun allowRgb565(enable: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): T` |
| [bitmapConfig](bitmap-config.md) | `fun bitmapConfig(bitmapConfig: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html)`): T` |
| [colorSpace](color-space.md) | Set the preferred [ColorSpace](https://developer.android.com/reference/android/graphics/ColorSpace.html).`fun colorSpace(colorSpace: `[`ColorSpace`](https://developer.android.com/reference/android/graphics/ColorSpace.html)`): T` |
| [data](data.md) | Set the data to load.`fun data(data: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): T` |
| [decoder](decoder.md) | Set the [Decoder](../../coil.decode/-decoder/index.md) to handle decoding any image data.`fun decoder(decoder: `[`Decoder`](../../coil.decode/-decoder/index.md)`): T` |
| [diskCachePolicy](disk-cache-policy.md) | Enable/disable reading/writing from/to the disk cache.`fun diskCachePolicy(policy: `[`CachePolicy`](../-cache-policy/index.md)`): T` |
| [dispatcher](dispatcher.md) | Set the [CoroutineDispatcher](https://kotlin.github.io/kotlinx.coroutines/kotlinx-coroutines-core/kotlinx.coroutines/-coroutine-dispatcher/index.html) to run the fetching, decoding, and transforming work on.`fun dispatcher(dispatcher: `[`CoroutineDispatcher`](https://kotlin.github.io/kotlinx.coroutines/kotlinx-coroutines-core/kotlinx.coroutines/-coroutine-dispatcher/index.html)`): T` |
| [error](error.md) | Set the error drawable to use if the request fails.`fun error(drawableResId: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): T`<br>`fun error(drawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?): T` |
| [fallback](fallback.md) | Set the fallback drawable to use if [data](data.md) is null.`fun fallback(drawableResId: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): T`<br>`fun fallback(drawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?): T` |
| [fetcher](fetcher.md) | Set the [Fetcher](../../coil.fetch/-fetcher/index.md) to handle fetching any image data.`fun <R : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> fetcher(fetcher: `[`Fetcher`](../../coil.fetch/-fetcher/index.md)`<R>): T` |
| [headers](headers.md) | Set the [Headers](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Headers.html) for any network operations performed by this request.`fun headers(headers: `[`Headers`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Headers.html)`): T` |
| [key](key.md) | Set the cache key for this request.`fun key(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): T` |
| [listener](listener.md) | Convenience function to create and set the [Request.Listener](../-request/-listener/index.md).`fun listener(onStart: (request: `[`Request`](../-request/index.md)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}, onCancel: (request: `[`Request`](../-request/index.md)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}, onError: (request: `[`Request`](../-request/index.md)`, throwable: `[`Throwable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = { _, _ -> }, onSuccess: (request: `[`Request`](../-request/index.md)`, source: `[`DataSource`](../../coil.decode/-data-source/index.md)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = { _, _ -> }): T`<br>Set the [Request.Listener](../-request/-listener/index.md).`fun listener(listener: Listener?): T` |
| [memoryCachePolicy](memory-cache-policy.md) | Enable/disable reading/writing from/to the memory cache.`fun memoryCachePolicy(policy: `[`CachePolicy`](../-cache-policy/index.md)`): T` |
| [networkCachePolicy](network-cache-policy.md) | Enable/disable reading from the network.`fun networkCachePolicy(policy: `[`CachePolicy`](../-cache-policy/index.md)`): T` |
| [parameters](parameters.md) | Set the parameters for this request.`fun parameters(parameters: `[`Parameters`](../-parameters/index.md)`): T` |
| [precision](precision.md) | Set the required precision for the size of the loaded image.`fun precision(precision: `[`Precision`](../../coil.size/-precision/index.md)`): T` |
| [removeHeader](remove-header.md) | Remove all network headers with the key [name](remove-header.md#coil.request.RequestBuilder$removeHeader(kotlin.String)/name).`fun removeHeader(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): T` |
| [removeParameter](remove-parameter.md) | Remove a parameter from this request.`fun removeParameter(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): T` |
| [scale](scale.md) | Set the scaling algorithm that will be used to fit/fill the image into the dimensions provided by [sizeResolver](size-resolver.md).`fun scale(scale: `[`Scale`](../../coil.size/-scale/index.md)`): T` |
| [setHeader](set-header.md) | Set a header for any network operations performed by this request.`fun setHeader(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, value: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): T` |
| [setParameter](set-parameter.md) | Set a parameter for this request.`fun setParameter(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, value: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, cacheKey: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = value?.toString()): T` |
| [size](size.md) | Set the requested width/height.`fun size(size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): T`<br>`fun size(width: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, height: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): T`<br>`fun size(size: `[`Size`](../../coil.size/-size.md)`): T`<br>Set the [SizeResolver](../../coil.size/-size-resolver/index.md) for this request. It will be used to determine the requested width/height for this request.`fun size(resolver: `[`SizeResolver`](../../coil.size/-size-resolver/index.md)`): T` |
| [transformations](transformations.md) | Set the list of [Transformation](../../coil.transform/-transformation/index.md)s to be applied to this request.`fun transformations(vararg transformations: `[`Transformation`](../../coil.transform/-transformation/index.md)`): T`<br>`fun transformations(transformations: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Transformation`](../../coil.transform/-transformation/index.md)`>): T` |

### Inheritors

| Name | Summary |
|---|---|
| [GetRequestBuilder](../-get-request-builder/index.md) | Builder for a [GetRequest](../-get-request/index.md).`class GetRequestBuilder : `[`RequestBuilder`](./index.md)`<`[`GetRequestBuilder`](../-get-request-builder/index.md)`>` |
| [LoadRequestBuilder](../-load-request-builder/index.md) | Builder for a [LoadRequest](../-load-request/index.md).`class LoadRequestBuilder : `[`RequestBuilder`](./index.md)`<`[`LoadRequestBuilder`](../-load-request-builder/index.md)`>` |
