[coil-base](../index.md) / [coil.request](./index.md)

## Package coil.request

### Types

| Name | Summary |
|---|---|
| [CachePolicy](-cache-policy/index.md) | Represents the read/write policy for a cache source.`enum class CachePolicy` |
| [ErrorResult](-error-result/index.md) | Indicates that an error occurred while executing the request.`data class ErrorResult : `[`RequestResult`](-request-result/index.md) |
| [GetRequest](-get-request/index.md) | [GetRequest](-get-request/index.md)s suspend the current coroutine and return the drawable directly to the caller.`class GetRequest : `[`Request`](-request/index.md) |
| [GetRequestBuilder](-get-request-builder/index.md) | Builder for a [GetRequest](-get-request/index.md).`class GetRequestBuilder : `[`RequestBuilder`](-request-builder/index.md)`<`[`GetRequestBuilder`](-get-request-builder/index.md)`>` |
| [LoadRequest](-load-request/index.md) | [LoadRequest](-load-request/index.md)s asynchronously load an image into a [Target](../coil.target/-target/index.md).`class LoadRequest : `[`Request`](-request/index.md) |
| [LoadRequestBuilder](-load-request-builder/index.md) | Builder for a [LoadRequest](-load-request/index.md).`class LoadRequestBuilder : `[`RequestBuilder`](-request-builder/index.md)`<`[`LoadRequestBuilder`](-load-request-builder/index.md)`>` |
| [Parameters](-parameters/index.md) | A map of generic values that can be used to pass custom data to [Fetcher](../coil.fetch/-fetcher/index.md)s and [Decoder](../coil.decode/-decoder/index.md)s.`class Parameters : `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, Entry>>` |
| [Request](-request/index.md) | The base class for an image request.`sealed class Request` |
| [RequestBuilder](-request-builder/index.md) | Base class for [LoadRequestBuilder](-load-request-builder/index.md) and [GetRequestBuilder](-get-request-builder/index.md).`sealed class RequestBuilder<T : `[`RequestBuilder`](-request-builder/index.md)`<T>>` |
| [RequestDisposable](-request-disposable/index.md) | Represents the work of a launched [LoadRequest](-load-request/index.md).`interface RequestDisposable` |
| [RequestResult](-request-result/index.md) | Represents the result of an image request.`sealed class RequestResult` |
| [SuccessResult](-success-result/index.md) | Indicates that the request completed successfully.`data class SuccessResult : `[`RequestResult`](-request-result/index.md) |

### Exceptions

| Name | Summary |
|---|---|
| [NullRequestDataException](-null-request-data-exception/index.md) | Exception thrown by [ImageLoader.execute](../coil/-image-loader/execute.md) (inside the [CoroutineContext](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.coroutines/-coroutine-context/index.html)) when [Request.data](-request/data.md) is null.`class NullRequestDataException : `[`RuntimeException`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-runtime-exception/index.html) |
