[coil-base](../../index.md) / [coil.size](../index.md) / [ViewSizeResolver](./index.md)

# ViewSizeResolver

`interface ViewSizeResolver<T : `[`View`](https://developer.android.com/reference/android/view/View.html)`> : `[`SizeResolver`](../-size-resolver/index.md)

A [SizeResolver](../-size-resolver/index.md) that measures the size of a [View](https://developer.android.com/reference/android/view/View.html).

### Properties

| Name | Summary |
|---|---|
| [subtractPadding](subtract-padding.md) | If true, the [view](view.md)'s padding will be subtracted from its size.`open val subtractPadding: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [view](view.md) | The [View](https://developer.android.com/reference/android/view/View.html) to measure.`abstract val view: T` |

### Functions

| Name | Summary |
|---|---|
| [size](size.md) | Return the [Size](../-size.md) that the image should be loaded at.`open suspend fun size(): `[`Size`](../-size.md) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [invoke](invoke.md) | Create a [ViewSizeResolver](./index.md) using the default [View](https://developer.android.com/reference/android/view/View.html) measurement implementation.`operator fun <T : `[`View`](https://developer.android.com/reference/android/view/View.html)`> invoke(view: T, subtractPadding: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = true): `[`ViewSizeResolver`](./index.md)`<T>` |
