[coil-base](../../index.md) / [coil.target](../index.md) / [ImageViewTarget](./index.md)

# ImageViewTarget

`open class ImageViewTarget : `[`PoolableViewTarget`](../-poolable-view-target/index.md)`<`[`ImageView`](https://developer.android.com/reference/android/widget/ImageView.html)`>, `[`TransitionTarget`](../../coil.transition/-transition-target/index.md)`<`[`ImageView`](https://developer.android.com/reference/android/widget/ImageView.html)`>, `[`DefaultLifecycleObserver`](https://developer.android.com/reference/androidx/androidx/lifecycle/DefaultLifecycleObserver.html)

A [Target](../-target/index.md) that handles setting images on an [ImageView](https://developer.android.com/reference/android/widget/ImageView.html).

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | A [Target](../-target/index.md) that handles setting images on an [ImageView](https://developer.android.com/reference/android/widget/ImageView.html).`ImageViewTarget(view: `[`ImageView`](https://developer.android.com/reference/android/widget/ImageView.html)`)` |

### Properties

| Name | Summary |
|---|---|
| [drawable](drawable.md) | The [view](../-view-target/view.md)'s current [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html).`open val drawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?` |
| [view](view.md) | The [View](https://developer.android.com/reference/android/view/View.html) used by this [Target](../-target/index.md).`open val view: `[`ImageView`](https://developer.android.com/reference/android/widget/ImageView.html) |

### Functions

| Name | Summary |
|---|---|
| [onClear](on-clear.md) | Called when the current drawable is no longer usable. Targets **must** stop using the current Drawable.`open fun onClear(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onError](on-error.md) | Called if an error occurs while executing the request.`open fun onError(error: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onStart](on-start.md) | Called when the request starts.`open fun onStart(placeholder: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`open fun onStart(owner: `[`LifecycleOwner`](https://developer.android.com/reference/androidx/androidx/lifecycle/LifecycleOwner.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onStop](on-stop.md) | `open fun onStop(owner: `[`LifecycleOwner`](https://developer.android.com/reference/androidx/androidx/lifecycle/LifecycleOwner.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onSuccess](on-success.md) | Called if the request completes successfully.`open fun onSuccess(result: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setDrawable](set-drawable.md) | Replace the [ImageView](https://developer.android.com/reference/android/widget/ImageView.html)'s current drawable with [drawable](set-drawable.md#coil.target.ImageViewTarget$setDrawable(android.graphics.drawable.Drawable)/drawable).`open fun setDrawable(drawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [updateAnimation](update-animation.md) | Start/stop the current [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)'s animation based on the current lifecycle state.`open fun updateAnimation(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
