[coil-base](../../index.md) / [coil](../index.md) / [ComponentRegistry](./index.md)

# ComponentRegistry

`class ComponentRegistry`

Registry for all the components that an [ImageLoader](../-image-loader/index.md) uses to fulfil image requests.

Use this class to register support for custom [Mapper](../../coil.map/-mapper/index.md)s, [MeasuredMapper](../../coil.map/-measured-mapper/index.md)s, [Fetcher](../../coil.fetch/-fetcher/index.md)s, and [Decoder](../../coil.decode/-decoder/index.md)s.

### Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | `class Builder` |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `ComponentRegistry()` |

### Functions

| Name | Summary |
|---|---|
| [getMapper](get-mapper.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> getMapper(data: T): `[`Mapper`](../../coil.map/-mapper/index.md)`<T, *>?` |
| [getMeasuredMapper](get-measured-mapper.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> getMeasuredMapper(data: T): `[`MeasuredMapper`](../../coil.map/-measured-mapper/index.md)`<T, *>?` |
| [newBuilder](new-builder.md) | `fun newBuilder(): Builder` |
| [requireDecoder](require-decoder.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> requireDecoder(data: T, source: `[`BufferedSource`](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md)`, mimeType: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`Decoder`](../../coil.decode/-decoder/index.md) |
| [requireFetcher](require-fetcher.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> requireFetcher(data: T): `[`Fetcher`](../../coil.fetch/-fetcher/index.md)`<T>` |
