[coil-base](../../index.md) / [coil](../index.md) / [EventListener](./index.md)

# EventListener

`@ExperimentalCoilApi interface EventListener : Listener`

An [ImageLoader](../-image-loader/index.md)-scoped listener for tracking the progress of an image request.
This class is useful for measuring analytics, performance, or other metrics tracking.

**See Also**

[ImageLoaderBuilder.eventListener](../-image-loader-builder/event-listener.md)

### Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | A factory that creates new [EventListener](./index.md) instances.`interface Factory` |

### Functions

| Name | Summary |
|---|---|
| [decodeEnd](decode-end.md) | Called after [Decoder.decode](../../coil.decode/-decoder/decode.md).`open fun decodeEnd(request: `[`Request`](../../coil.request/-request/index.md)`, decoder: `[`Decoder`](../../coil.decode/-decoder/index.md)`, options: `[`Options`](../../coil.decode/-options/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [decodeStart](decode-start.md) | Called before [Decoder.decode](../../coil.decode/-decoder/decode.md).`open fun decodeStart(request: `[`Request`](../../coil.request/-request/index.md)`, decoder: `[`Decoder`](../../coil.decode/-decoder/index.md)`, options: `[`Options`](../../coil.decode/-options/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [fetchEnd](fetch-end.md) | Called after [Fetcher.fetch](../../coil.fetch/-fetcher/fetch.md).`open fun fetchEnd(request: `[`Request`](../../coil.request/-request/index.md)`, fetcher: `[`Fetcher`](../../coil.fetch/-fetcher/index.md)`<*>, options: `[`Options`](../../coil.decode/-options/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [fetchStart](fetch-start.md) | Called before [Fetcher.fetch](../../coil.fetch/-fetcher/fetch.md).`open fun fetchStart(request: `[`Request`](../../coil.request/-request/index.md)`, fetcher: `[`Fetcher`](../../coil.fetch/-fetcher/index.md)`<*>, options: `[`Options`](../../coil.decode/-options/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [mapEnd](map-end.md) | Called after the request's data has been converted by all applicable [Mapper](../../coil.map/-mapper/index.md)s and/or [MeasuredMapper](../../coil.map/-measured-mapper/index.md)s.`open fun mapEnd(request: `[`Request`](../../coil.request/-request/index.md)`, mappedData: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [mapStart](map-start.md) | Called before any [Mapper](../../coil.map/-mapper/index.md)s and/or [MeasuredMapper](../../coil.map/-measured-mapper/index.md)s are called to convert the request's data.`open fun mapStart(request: `[`Request`](../../coil.request/-request/index.md)`, data: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onCancel](on-cancel.md) | `open fun onCancel(request: `[`Request`](../../coil.request/-request/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onDispatch](on-dispatch.md) | Called immediately after the request is dispatched.`open fun onDispatch(request: `[`Request`](../../coil.request/-request/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onError](on-error.md) | `open fun onError(request: `[`Request`](../../coil.request/-request/index.md)`, throwable: `[`Throwable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onStart](on-start.md) | `open fun onStart(request: `[`Request`](../../coil.request/-request/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onSuccess](on-success.md) | `open fun onSuccess(request: `[`Request`](../../coil.request/-request/index.md)`, source: `[`DataSource`](../../coil.decode/-data-source/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [resolveSizeEnd](resolve-size-end.md) | Called after [SizeResolver.size](../../coil.size/-size-resolver/size.md).`open fun resolveSizeEnd(request: `[`Request`](../../coil.request/-request/index.md)`, size: `[`Size`](../../coil.size/-size.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [resolveSizeStart](resolve-size-start.md) | Called before [SizeResolver.size](../../coil.size/-size-resolver/size.md).`open fun resolveSizeStart(request: `[`Request`](../../coil.request/-request/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [transformEnd](transform-end.md) | Called after any [Transformation](../../coil.transform/-transformation/index.md)s are applied.`open fun transformEnd(request: `[`Request`](../../coil.request/-request/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [transformStart](transform-start.md) | Called before any [Transformation](../../coil.transform/-transformation/index.md)s are applied.`open fun transformStart(request: `[`Request`](../../coil.request/-request/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [transitionEnd](transition-end.md) | Called after [Transition.transition](../../coil.transition/-transition/transition.md).`open fun transitionEnd(request: `[`Request`](../../coil.request/-request/index.md)`, transition: `[`Transition`](../../coil.transition/-transition/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [transitionStart](transition-start.md) | Called before [Transition.transition](../../coil.transition/-transition/transition.md).`open fun transitionStart(request: `[`Request`](../../coil.request/-request/index.md)`, transition: `[`Transition`](../../coil.transition/-transition/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Properties

| Name | Summary |
|---|---|
| [NONE](-n-o-n-e.md) | `val NONE: `[`EventListener`](./index.md) |
