[coil-base](../../index.md) / [coil](../index.md) / [ImageLoaderBuilder](./index.md)

# ImageLoaderBuilder

`@BuilderMarker class ImageLoaderBuilder`

Builder for an [ImageLoader](../-image-loader/index.md).

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | Builder for an [ImageLoader](../-image-loader/index.md).`ImageLoaderBuilder(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`)` |

### Functions

| Name | Summary |
|---|---|
| [allowHardware](allow-hardware.md) | Allow the use of [Bitmap.Config.HARDWARE](https://developer.android.com/reference/android/graphics/Bitmap/Config.html#HARDWARE).`fun allowHardware(enable: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`ImageLoaderBuilder`](./index.md) |
| [allowRgb565](allow-rgb565.md) | Allow automatically using [Bitmap.Config.RGB_565](https://developer.android.com/reference/android/graphics/Bitmap/Config.html#RGB_565) when an image is guaranteed to not have alpha.`fun allowRgb565(enable: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`ImageLoaderBuilder`](./index.md) |
| [availableMemoryPercentage](available-memory-percentage.md) | Set the percentage of available memory to devote to this [ImageLoader](../-image-loader/index.md)'s memory cache and bitmap pool.`fun availableMemoryPercentage(multiplier: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`): `[`ImageLoaderBuilder`](./index.md) |
| [bitmapConfig](bitmap-config.md) | Set the preferred [Bitmap.Config](https://developer.android.com/reference/android/graphics/Bitmap/Config.html).`fun bitmapConfig(bitmapConfig: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html)`): `[`ImageLoaderBuilder`](./index.md) |
| [bitmapPoolPercentage](bitmap-pool-percentage.md) | Set the percentage of memory allocated to this [ImageLoader](../-image-loader/index.md) to allocate to bitmap pooling.`fun bitmapPoolPercentage(multiplier: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`): `[`ImageLoaderBuilder`](./index.md) |
| [build](build.md) | Create a new [ImageLoader](../-image-loader/index.md) instance.`fun build(): `[`ImageLoader`](../-image-loader/index.md) |
| [callFactory](call-factory.md) | Set the [Call.Factory](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Call/Factory.html) used for network requests.`fun callFactory(callFactory: `[`Factory`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Call/Factory.html)`): `[`ImageLoaderBuilder`](./index.md)<br>Set a lazy callback to create the [Call.Factory](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Call/Factory.html) used for network requests.`fun callFactory(initializer: () -> `[`Factory`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Call/Factory.html)`): `[`ImageLoaderBuilder`](./index.md) |
| [componentRegistry](component-registry.md) | Build and set the [ComponentRegistry](../-component-registry/index.md).`fun componentRegistry(builder: Builder.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`ImageLoaderBuilder`](./index.md)<br>Set the [ComponentRegistry](../-component-registry/index.md).`fun componentRegistry(registry: `[`ComponentRegistry`](../-component-registry/index.md)`): `[`ImageLoaderBuilder`](./index.md) |
| [crossfade](crossfade.md) | Enable a crossfade animation with duration [CrossfadeDrawable.DEFAULT_DURATION](../../coil.drawable/-crossfade-drawable/-d-e-f-a-u-l-t_-d-u-r-a-t-i-o-n.md) milliseconds when a request completes successfully.`fun crossfade(enable: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`ImageLoaderBuilder`](./index.md)<br>Enable a crossfade animation with [durationMillis](crossfade.md#coil.ImageLoaderBuilder$crossfade(kotlin.Int)/durationMillis) milliseconds when a request completes successfully.`fun crossfade(durationMillis: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`ImageLoaderBuilder`](./index.md) |
| [diskCachePolicy](disk-cache-policy.md) | Set the default disk cache policy.`fun diskCachePolicy(policy: `[`CachePolicy`](../../coil.request/-cache-policy/index.md)`): `[`ImageLoaderBuilder`](./index.md) |
| [dispatcher](dispatcher.md) | The default [CoroutineDispatcher](https://kotlin.github.io/kotlinx.coroutines/kotlinx-coroutines-core/kotlinx.coroutines/-coroutine-dispatcher/index.html) to run image requests on.`fun dispatcher(dispatcher: `[`CoroutineDispatcher`](https://kotlin.github.io/kotlinx.coroutines/kotlinx-coroutines-core/kotlinx.coroutines/-coroutine-dispatcher/index.html)`): `[`ImageLoaderBuilder`](./index.md) |
| [error](error.md) | Set the default error drawable to use when a request fails.`fun error(drawableResId: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`ImageLoaderBuilder`](./index.md)<br>`fun error(drawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?): `[`ImageLoaderBuilder`](./index.md) |
| [eventListener](event-listener.md) | Set a single [EventListener](../-event-listener/index.md) that will receive all callbacks for requests launched by this image loader.`fun eventListener(listener: `[`EventListener`](../-event-listener/index.md)`): `[`ImageLoaderBuilder`](./index.md)<br>Set the [EventListener.Factory](../-event-listener/-factory/index.md) to create per-request [EventListener](../-event-listener/index.md)s.`fun eventListener(factory: Factory): `[`ImageLoaderBuilder`](./index.md) |
| [fallback](fallback.md) | Set the default fallback drawable to use if [Request.data](../../coil.request/-request/data.md) is null.`fun fallback(drawableResId: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`ImageLoaderBuilder`](./index.md)<br>`fun fallback(drawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?): `[`ImageLoaderBuilder`](./index.md) |
| [logger](logger.md) | Set the [Logger](../../coil.util/-logger/index.md) to write logs to.`fun logger(logger: `[`Logger`](../../coil.util/-logger/index.md)`?): `[`ImageLoaderBuilder`](./index.md) |
| [memoryCachePolicy](memory-cache-policy.md) | Set the default memory cache policy.`fun memoryCachePolicy(policy: `[`CachePolicy`](../../coil.request/-cache-policy/index.md)`): `[`ImageLoaderBuilder`](./index.md) |
| [networkCachePolicy](network-cache-policy.md) | Set the default network cache policy.`fun networkCachePolicy(policy: `[`CachePolicy`](../../coil.request/-cache-policy/index.md)`): `[`ImageLoaderBuilder`](./index.md) |
| [okHttpClient](ok-http-client.md) | Set the [OkHttpClient](https://square.github.io/okhttp/3.x/okhttp/okhttp3/OkHttpClient.html) used for network requests.`fun okHttpClient(okHttpClient: `[`OkHttpClient`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/OkHttpClient.html)`): `[`ImageLoaderBuilder`](./index.md)<br>Set a lazy callback to create the [OkHttpClient](https://square.github.io/okhttp/3.x/okhttp/okhttp3/OkHttpClient.html) used for network requests.`fun okHttpClient(initializer: () -> `[`OkHttpClient`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/OkHttpClient.html)`): `[`ImageLoaderBuilder`](./index.md) |
| [placeholder](placeholder.md) | Set the default placeholder drawable to use when a request starts.`fun placeholder(drawableResId: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`ImageLoaderBuilder`](./index.md)<br>`fun placeholder(drawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?): `[`ImageLoaderBuilder`](./index.md) |
| [precision](precision.md) | Set the default precision for a request. [Precision](../../coil.size/-precision/index.md) controls whether the size of the loaded image must match the request's size exactly or not.`fun precision(precision: `[`Precision`](../../coil.size/-precision/index.md)`): `[`ImageLoaderBuilder`](./index.md) |
| [trackWeakReferences](track-weak-references.md) | Enables weak reference tracking of loaded images.`fun trackWeakReferences(enable: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`ImageLoaderBuilder`](./index.md) |
| [transition](transition.md) | Set the default [Transition](../../coil.transition/-transition/index.md) for each request.`fun transition(transition: `[`Transition`](../../coil.transition/-transition/index.md)`): `[`ImageLoaderBuilder`](./index.md) |
