[coil-base](../../index.md) / [coil](../index.md) / [ImageLoader](./index.md)

# ImageLoader

`interface ImageLoader`

A service class that loads images by executing [Request](../../coil.request/-request/index.md)s. Image loaders handle caching, data fetching,
image decoding, request management, bitmap pooling, memory management, and more.

Image loaders are designed to be shareable and work best when you create a single instance and
share it throughout your app.

It's recommended, though not required, to call [shutdown](shutdown.md) when you've finished using an image loader.
This preemptively frees its memory and cleans up any observers.

### Properties

| Name | Summary |
|---|---|
| [defaults](defaults.md) | The default options that are used to fill in unset [Request](../../coil.request/-request/index.md) values.`abstract val defaults: `[`DefaultRequestOptions`](../-default-request-options/index.md) |

### Functions

| Name | Summary |
|---|---|
| [clearMemory](clear-memory.md) | Clear this image loader's memory cache and bitmap pool.`abstract fun clearMemory(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [execute](execute.md) | Launch an asynchronous operation that executes the [LoadRequest](../../coil.request/-load-request/index.md) and sets the result on its [Target](../../coil.target/-target/index.md).`abstract fun execute(request: `[`LoadRequest`](../../coil.request/-load-request/index.md)`): `[`RequestDisposable`](../../coil.request/-request-disposable/index.md)<br>Suspends and executes the [GetRequest](../../coil.request/-get-request/index.md). Returns either [SuccessResult](../../coil.request/-success-result/index.md) or [ErrorResult](../../coil.request/-error-result/index.md) depending on how the request completes.`abstract suspend fun execute(request: `[`GetRequest`](../../coil.request/-get-request/index.md)`): `[`RequestResult`](../../coil.request/-request-result/index.md) |
| [invalidate](invalidate.md) | Remove the value referenced by [key](invalidate.md#coil.ImageLoader$invalidate(kotlin.String)/key) from the memory cache.`abstract fun invalidate(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [shutdown](shutdown.md) | Shutdown this image loader.`abstract fun shutdown(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [Builder](-builder.md) | Alias for [ImageLoaderBuilder](../-image-loader-builder/index.md).`fun Builder(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`): `[`ImageLoaderBuilder`](../-image-loader-builder/index.md) |
| [invoke](invoke.md) | Create a new [ImageLoader](./index.md) without configuration.`operator fun invoke(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`): `[`ImageLoader`](./index.md) |
