

### All Types

| Name | Summary |
|---|---|
|

##### [coil.bitmap.BitmapPool](../coil.bitmap/-bitmap-pool/index.md)

An object pool that enables callers to reuse [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) objects.


|

##### [coil.transform.BlurTransformation](../coil.transform/-blur-transformation/index.md)

A [Transformation](../coil.transform/-transformation/index.md) that applies a Gaussian blur to an image.


|

##### [coil.request.CachePolicy](../coil.request/-cache-policy/index.md)

Represents the read/write policy for a cache source.


|

##### [coil.transform.CircleCropTransformation](../coil.transform/-circle-crop-transformation/index.md)

A [Transformation](../coil.transform/-transformation/index.md) that crops an image using a centered circle as the mask.


|

##### [coil.util.CoilUtils](../coil.util/-coil-utils/index.md)

Public utility methods for Coil.


|

##### [coil.ComponentRegistry](../coil/-component-registry/index.md)

Registry for all the components that an [ImageLoader](../coil/-image-loader/index.md) uses to fulfil image requests.


|

##### [coil.drawable.CrossfadeDrawable](../coil.drawable/-crossfade-drawable/index.md)

A [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) that crossfades from [start](../coil.drawable/-crossfade-drawable/start.md) to [end](#).


|

##### [coil.transition.CrossfadeTransition](../coil.transition/-crossfade-transition/index.md)

A [Transition](../coil.transition/-transition/index.md) that crossfades from the current drawable to a new one.


|

##### [coil.decode.DataSource](../coil.decode/-data-source/index.md)

Represents the source that an image was loaded from.


|

##### [coil.util.DebugLogger](../coil.util/-debug-logger/index.md)

A [Logger](../coil.util/-logger/index.md) implementation that writes to Android's [Log](https://developer.android.com/reference/android/util/Log.html).


|

##### [coil.decode.Decoder](../coil.decode/-decoder/index.md)

Converts a [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md) into a [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html).


|

##### [coil.decode.DecodeResult](../coil.decode/-decode-result/index.md)

The result of [Decoder.decode](../coil.decode/-decoder/decode.md).


|

##### [coil.decode.DecodeUtils](../coil.decode/-decode-utils/index.md)

A collection of useful utility methods for decoding images.


|

##### [coil.request.DefaultRequestOptions](../coil.request/-default-request-options/index.md)

A set of default options that are used to fill in unset [ImageRequest](../coil.request/-image-request/index.md) values.


|

##### [coil.request.DefinedRequestOptions](../coil.request/-defined-request-options/index.md)

Tracks which values have been set (instead of computed automatically using a default)
when building an [ImageRequest](../coil.request/-image-request/index.md).


|

##### [coil.size.DisplaySizeResolver](../coil.size/-display-size-resolver/index.md)

A [SizeResolver](../coil.size/-size-resolver/index.md) that measures the size of the display.


|

##### [coil.request.Disposable](../coil.request/-disposable/index.md)

Represents the work of an executed [ImageRequest](../coil.request/-image-request/index.md).


|

##### [coil.fetch.DrawableResult](../coil.fetch/-drawable-result/index.md)

A direct [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) result. Return this from a [Fetcher](../coil.fetch/-fetcher/index.md) if its data cannot be converted into a [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md).


|

##### [coil.request.ErrorResult](../coil.request/-error-result/index.md)

Indicates that an error occurred while executing the request.


|

##### [coil.EventListener](../coil/-event-listener/index.md)

A listener for tracking the progress of an image request. This class is useful for
measuring analytics, performance, or other metrics tracking.


|

##### [coil.annotation.ExperimentalCoilApi](../coil.annotation/-experimental-coil-api/index.md)

Marks declarations that are still **experimental**.
Targets marked by this annotation may contain breaking changes in the future as their design is still incubating.


|

##### [coil.fetch.Fetcher](../coil.fetch/-fetcher/index.md)

A [Fetcher](../coil.fetch/-fetcher/index.md) translates data into either a [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md) or a [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html).


|

##### [coil.fetch.FetchResult](../coil.fetch/-fetch-result.md)

The result of [Fetcher.fetch](../coil.fetch/-fetcher/fetch.md).


|

##### [coil.transform.GrayscaleTransformation](../coil.transform/-grayscale-transformation/index.md)

A [Transformation](../coil.transform/-transformation/index.md) that converts an image to shades of gray.


|

##### [coil.network.HttpException](../coil.network/-http-exception/index.md)

Exception for an unexpected, non-2xx HTTP response.


|

##### [coil.ImageLoader](../coil/-image-loader/index.md)

A service class that loads images by executing [ImageRequest](../coil.request/-image-request/index.md)s. Image loaders handle caching, data fetching,
image decoding, request management, bitmap pooling, memory management, and more.


|

##### [coil.request.ImageRequest](../coil.request/-image-request/index.md)

An immutable value object that represents a request for an image.


|

##### [coil.request.ImageResult](../coil.request/-image-result/index.md)

Represents the result of an image request.


|

##### [coil.target.ImageViewTarget](../coil.target/-image-view-target/index.md)

A [Target](../coil.target/-target/index.md) that handles setting images on an [ImageView](https://developer.android.com/reference/android/widget/ImageView.html).


|

##### [coil.intercept.Interceptor](../coil.intercept/-interceptor/index.md)

Observe, transform, short circuit, or retry requests to an [ImageLoader](../coil/-image-loader/index.md)'s image engine.


|

##### [coil.annotation.InternalCoilApi](../coil.annotation/-internal-coil-api/index.md)

Marks declarations that are part of Coil's internal API. They should not be used outside of the `coil` package
as their signatures and semantics will change between future releases without any warnings and without providing
any migration aids.


|

##### [coil.util.Logger](../coil.util/-logger/index.md)

Logging interface for [ImageLoader](../coil/-image-loader/index.md)s.


|

##### [coil.map.Mapper](../coil.map/-mapper/index.md)

An interface to convert data of type [T](../coil.map/-mapper/index.md#T) into [V](../coil.map/-mapper/index.md#V).


|

##### [coil.memory.MemoryCache](../coil.memory/-memory-cache/index.md)

An in-memory cache of recently loaded images.


|

##### [coil.request.NullRequestData](../coil.request/-null-request-data/index.md)

The value for [ImageRequest.data](../coil.request/-image-request/data.md) if the request's data was not set or was set to null.


|

##### [coil.request.NullRequestDataException](../coil.request/-null-request-data-exception/index.md)

Exception thrown when an [ImageRequest](../coil.request/-image-request/index.md) with empty/null data is executed by an [ImageLoader](../coil/-image-loader/index.md).


|

##### [coil.decode.Options](../coil.decode/-options/index.md)

A set of configuration options for fetching and decoding an image.


|

##### [coil.size.OriginalSize](../coil.size/-original-size/index.md)

Represents the width and height of the source image.


|

##### [coil.request.Parameters](../coil.request/-parameters/index.md)

A map of generic values that can be used to pass custom data to [Fetcher](../coil.fetch/-fetcher/index.md)s and [Decoder](../coil.decode/-decoder/index.md)s.


|

##### [coil.size.PixelSize](../coil.size/-pixel-size/index.md)

A positive width and height in pixels.


|

##### [coil.target.PoolableViewTarget](../coil.target/-poolable-view-target/index.md)

A [ViewTarget](../coil.target/-view-target/index.md) that supports [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) pooling.


|

##### [coil.size.Precision](../coil.size/-precision/index.md)

Represents the required precision for the size of an image in an image request.


|

##### [coil.transform.RoundedCornersTransformation](../coil.transform/-rounded-corners-transformation/index.md)

A [Transformation](../coil.transform/-transformation/index.md) that crops the image to fit the target's dimensions and rounds the corners of the image.


|

##### [coil.size.Scale](../coil.size/-scale/index.md)

Represents a scaling policy.


|

##### [coil.size.Size](../coil.size/-size.md)

Represents the target size of an image request.


|

##### [coil.size.SizeResolver](../coil.size/-size-resolver/index.md)

An interface for measuring the target size for an image request.


|

##### [coil.fetch.SourceResult](../coil.fetch/-source-result/index.md)

A raw [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md) result, which will be consumed by the relevant [Decoder](../coil.decode/-decoder/index.md).


|

##### [coil.request.SuccessResult](../coil.request/-success-result/index.md)

Indicates that the request completed successfully.


|

##### [coil.target.Target](../coil.target/-target/index.md)

A listener that accepts the result of an image request.


|

##### [coil.transform.Transformation](../coil.transform/-transformation/index.md)

An interface for making transformations to an image's pixel data.


|

##### [coil.transition.Transition](../coil.transition/-transition/index.md)

A class to animate between a [Target](../coil.target/-target/index.md)'s current drawable and the result of an image request.


|

##### [coil.transition.TransitionTarget](../coil.transition/-transition-target/index.md)

A [Target](../coil.target/-target/index.md) that supports applying [Transition](../coil.transition/-transition/index.md)s.


|

##### [coil.size.ViewSizeResolver](../coil.size/-view-size-resolver/index.md)

A [SizeResolver](../coil.size/-size-resolver/index.md) that measures the size of a [View](https://developer.android.com/reference/android/view/View.html).


|

##### [coil.target.ViewTarget](../coil.target/-view-target/index.md)

A [Target](../coil.target/-target/index.md) with an associated [View](https://developer.android.com/reference/android/view/View.html). Prefer this to [Target](../coil.target/-target/index.md) if the given drawables will only be used by [view](../coil.target/-view-target/view.md).


